/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockSoil
extends Block {
    public static final MapCodec<BlockSoil> CODEC = BlockSoil.simpleCodec(BlockSoil::new);
    public static final BlockStateInteger MOISTURE = BlockProperties.MOISTURE;
    private static final VoxelShape SHAPE = Block.column(16.0, 0.0, 15.0);
    public static final int MAX_MOISTURE = 7;

    public MapCodec<BlockSoil> codec() {
        return CODEC;
    }

    protected BlockSoil(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(MOISTURE, 0));
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4 == EnumDirection.UP && !var0.canSurvive(var1, var3)) {
            var2.scheduleTick(var3, this, 1);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        IBlockData var3 = var1.getBlockState(var2.above());
        return !var3.isSolid() || var3.getBlock() instanceof BlockFenceGate || var3.getBlock() instanceof BlockPistonMoving;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        if (!this.defaultBlockState().canSurvive(var0.getLevel(), var0.getClickedPos())) {
            return Blocks.DIRT.defaultBlockState();
        }
        return super.getStateForPlacement(var0);
    }

    @Override
    protected boolean useShapeForLightOcclusion(IBlockData var0) {
        return true;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!var0.canSurvive(var1, var2)) {
            BlockSoil.turnToDirt(null, var0, var1, var2);
        }
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        int var4 = var0.getValue(MOISTURE);
        if (BlockSoil.isNearWater(var1, var2) || var1.isRainingAt(var2.above())) {
            if (var4 < 7) {
                var1.setBlock(var2, (IBlockData)var0.setValue(MOISTURE, 7), 2);
            }
        } else if (var4 > 0) {
            var1.setBlock(var2, (IBlockData)var0.setValue(MOISTURE, var4 - 1), 2);
        } else if (!BlockSoil.shouldMaintainFarmland(var1, var2)) {
            BlockSoil.turnToDirt(null, var0, var1, var2);
        }
    }

    @Override
    public void fallOn(World var0, IBlockData var1, BlockPosition var2, Entity var3, double var4) {
        if (var0 instanceof WorldServer) {
            WorldServer var6 = (WorldServer)var0;
            if ((double)var0.random.nextFloat() < var4 - 0.5 && var3 instanceof EntityLiving && (var3 instanceof EntityHuman || var6.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) && var3.getBbWidth() * var3.getBbWidth() * var3.getBbHeight() > 0.512f) {
                BlockSoil.turnToDirt(var3, var1, var0, var2);
            }
        }
        super.fallOn(var0, var1, var2, var3, var4);
    }

    public static void turnToDirt(@Nullable Entity var0, IBlockData var1, World var2, BlockPosition var3) {
        IBlockData var4 = BlockSoil.pushEntitiesUp(var1, Blocks.DIRT.defaultBlockState(), var2, var3);
        var2.setBlockAndUpdate(var3, var4);
        var2.gameEvent(GameEvent.BLOCK_CHANGE, var3, GameEvent.a.of(var0, var4));
    }

    private static boolean shouldMaintainFarmland(IBlockAccess var0, BlockPosition var1) {
        return var0.getBlockState(var1.above()).is(TagsBlock.MAINTAINS_FARMLAND);
    }

    private static boolean isNearWater(IWorldReader var0, BlockPosition var1) {
        for (BlockPosition var3 : BlockPosition.betweenClosed(var1.offset(-4, 0, -4), var1.offset(4, 1, 4))) {
            if (!var0.getFluidState(var3).is(TagsFluid.WATER)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(MOISTURE);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

