/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.SelectableSlotContainer;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class ChiseledBookShelfBlock
extends BlockTileEntity
implements SelectableSlotContainer {
    public static final MapCodec<ChiseledBookShelfBlock> CODEC = ChiseledBookShelfBlock.simpleCodec(ChiseledBookShelfBlock::new);
    public static final BlockStateEnum<EnumDirection> FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateBoolean SLOT_0_OCCUPIED = BlockProperties.SLOT_0_OCCUPIED;
    public static final BlockStateBoolean SLOT_1_OCCUPIED = BlockProperties.SLOT_1_OCCUPIED;
    public static final BlockStateBoolean SLOT_2_OCCUPIED = BlockProperties.SLOT_2_OCCUPIED;
    public static final BlockStateBoolean SLOT_3_OCCUPIED = BlockProperties.SLOT_3_OCCUPIED;
    public static final BlockStateBoolean SLOT_4_OCCUPIED = BlockProperties.SLOT_4_OCCUPIED;
    public static final BlockStateBoolean SLOT_5_OCCUPIED = BlockProperties.SLOT_5_OCCUPIED;
    private static final int MAX_BOOKS_IN_STORAGE = 6;
    private static final int BOOKS_PER_ROW = 3;
    public static final List<BlockStateBoolean> SLOT_OCCUPIED_PROPERTIES = List.of(SLOT_0_OCCUPIED, SLOT_1_OCCUPIED, SLOT_2_OCCUPIED, SLOT_3_OCCUPIED, SLOT_4_OCCUPIED, SLOT_5_OCCUPIED);

    public MapCodec<ChiseledBookShelfBlock> codec() {
        return CODEC;
    }

    @Override
    public int getRows() {
        return 2;
    }

    @Override
    public int getColumns() {
        return 3;
    }

    public ChiseledBookShelfBlock(BlockBase.Info var0) {
        super(var0);
        IBlockData var1 = (IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH);
        for (BlockStateBoolean var3 : SLOT_OCCUPIED_PROPERTIES) {
            var1 = (IBlockData)var1.setValue(var3, false);
        }
        this.registerDefaultState(var1);
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        TileEntity tileEntity = var2.getBlockEntity(var3);
        if (!(tileEntity instanceof ChiseledBookShelfBlockEntity)) {
            return EnumInteractionResult.PASS;
        }
        ChiseledBookShelfBlockEntity var7 = (ChiseledBookShelfBlockEntity)tileEntity;
        if (!var0.is(TagsItem.BOOKSHELF_BOOKS)) {
            return EnumInteractionResult.TRY_WITH_EMPTY_HAND;
        }
        OptionalInt var8 = this.getHitSlot(var6, var1.getValue(FACING));
        if (var8.isEmpty()) {
            return EnumInteractionResult.PASS;
        }
        if (((Boolean)var1.getValue(SLOT_OCCUPIED_PROPERTIES.get(var8.getAsInt()))).booleanValue()) {
            return EnumInteractionResult.TRY_WITH_EMPTY_HAND;
        }
        ChiseledBookShelfBlock.addBook(var2, var3, var4, var7, var0, var8.getAsInt());
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (!(tileEntity instanceof ChiseledBookShelfBlockEntity)) {
            return EnumInteractionResult.PASS;
        }
        ChiseledBookShelfBlockEntity var5 = (ChiseledBookShelfBlockEntity)tileEntity;
        OptionalInt var6 = this.getHitSlot(var4, var0.getValue(FACING));
        if (var6.isEmpty()) {
            return EnumInteractionResult.PASS;
        }
        if (!((Boolean)var0.getValue(SLOT_OCCUPIED_PROPERTIES.get(var6.getAsInt()))).booleanValue()) {
            return EnumInteractionResult.CONSUME;
        }
        ChiseledBookShelfBlock.removeBook(var1, var2, var3, var5, var6.getAsInt());
        return EnumInteractionResult.SUCCESS;
    }

    private static void addBook(World var0, BlockPosition var1, EntityHuman var2, ChiseledBookShelfBlockEntity var3, ItemStack var4, int var5) {
        if (var0.isClientSide()) {
            return;
        }
        var2.awardStat(StatisticList.ITEM_USED.get(var4.getItem()));
        SoundEffect var6 = var4.is(Items.ENCHANTED_BOOK) ? SoundEffects.CHISELED_BOOKSHELF_INSERT_ENCHANTED : SoundEffects.CHISELED_BOOKSHELF_INSERT;
        var3.setItem(var5, var4.consumeAndReturn(1, var2));
        var0.playSound(null, var1, var6, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private static void removeBook(World var0, BlockPosition var1, EntityHuman var2, ChiseledBookShelfBlockEntity var3, int var4) {
        if (var0.isClientSide()) {
            return;
        }
        ItemStack var5 = var3.removeItem(var4, 1);
        SoundEffect var6 = var5.is(Items.ENCHANTED_BOOK) ? SoundEffects.CHISELED_BOOKSHELF_PICKUP_ENCHANTED : SoundEffects.CHISELED_BOOKSHELF_PICKUP;
        var0.playSound(null, var1, var6, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!var2.getInventory().add(var5)) {
            var2.drop(var5, false);
        }
        var0.gameEvent((Entity)var2, GameEvent.BLOCK_CHANGE, var1);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new ChiseledBookShelfBlockEntity(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING);
        SLOT_OCCUPIED_PROPERTIES.forEach(var1 -> var0.add((IBlockState<?>)var1));
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        InventoryUtils.updateNeighboursAfterDestroy(var0, var1, var2);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite());
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2, EnumDirection var3) {
        if (var1.isClientSide()) {
            return 0;
        }
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (tileEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity var4 = (ChiseledBookShelfBlockEntity)tileEntity;
            return var4.getLastInteractedSlot() + 1;
        }
        return 0;
    }
}

