/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.CopperGolemStatueBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jetbrains.annotations.Nullable;

public class CopperGolemStatueBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<CopperGolemStatueBlock> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)WeatheringCopper.a.CODEC.fieldOf("weathering_state").forGetter(CopperGolemStatueBlock::getWeatheringState), CopperGolemStatueBlock.propertiesCodec()).apply((Applicative)var0, CopperGolemStatueBlock::new));
    public static final BlockStateEnum<EnumDirection> FACING = BlockProperties.HORIZONTAL_FACING;
    public static final BlockStateEnum<a> POSE = BlockProperties.COPPER_GOLEM_POSE;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.column(10.0, 0.0, 14.0);
    private final WeatheringCopper.a weatheringState;

    public MapCodec<? extends CopperGolemStatueBlock> codec() {
        return CODEC;
    }

    public CopperGolemStatueBlock(WeatheringCopper.a var0, BlockBase.Info var1) {
        super(var1);
        this.weatheringState = var0;
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, EnumDirection.NORTH)).setValue(POSE, a.STANDING)).setValue(WATERLOGGED, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        super.createBlockStateDefinition(var0);
        var0.add(FACING, POSE, WATERLOGGED);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite())).setValue(WATERLOGGED, var1.getType() == FluidTypes.WATER);
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected VoxelShape getOcclusionShape(IBlockData var0) {
        return VoxelShapes.empty();
    }

    public WeatheringCopper.a getWeatheringState() {
        return this.weatheringState;
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        if (var0.is(TagsItem.AXES)) {
            return EnumInteractionResult.PASS;
        }
        this.updatePose(var2, var1, var3, var4);
        return EnumInteractionResult.SUCCESS;
    }

    void updatePose(World var0, IBlockData var1, BlockPosition var2, EntityHuman var3) {
        var0.playSound(null, var2, SoundEffects.COPPER_GOLEM_BECOME_STATUE, SoundCategory.BLOCKS);
        var0.setBlock(var2, (IBlockData)var1.setValue(POSE, var1.getValue(POSE).getNextPose()), 3);
        var0.gameEvent((Entity)var3, GameEvent.BLOCK_CHANGE, var2);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return var1 == PathMode.WATER && var0.getFluidState().is(TagsFluid.WATER);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new CopperGolemStatueBlockEntity(var0, var1);
    }

    @Override
    public boolean shouldChangedStateKeepBlockEntity(IBlockData var0) {
        return var0.is(TagsBlock.COPPER_GOLEM_STATUES);
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2, EnumDirection var3) {
        return var0.getValue(POSE).ordinal() + 1;
    }

    @Override
    protected ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        TileEntity tileEntity = var0.getBlockEntity(var1);
        if (tileEntity instanceof CopperGolemStatueBlockEntity) {
            CopperGolemStatueBlockEntity var4 = (CopperGolemStatueBlockEntity)tileEntity;
            return var4.getItem(this.asItem().getDefaultInstance(), var2.getValue(POSE));
        }
        return super.getCloneItemStack(var0, var1, var2, var3);
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        var1.updateNeighbourForOutputSignal(var2, var0.getBlock());
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a STANDING = new a("standing");
        public static final /* enum */ a SITTING = new a("sitting");
        public static final /* enum */ a RUNNING = new a("running");
        public static final /* enum */ a STAR = new a("star");
        public static final IntFunction<a> BY_ID;
        public static final Codec<a> CODEC;
        private final String name;
        private static final /* synthetic */ a[] h;

        public static a[] values() {
            return (a[])h.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public a getNextPose() {
            return BY_ID.apply(this.ordinal() + 1);
        }

        private static /* synthetic */ a[] b() {
            return new a[]{STANDING, SITTING, RUNNING, STAR};
        }

        static {
            h = a.b();
            BY_ID = ByIdMap.continuous(Enum::ordinal, a.values(), ByIdMap.a.ZERO);
            CODEC = INamable.fromEnum(a::values);
        }
    }
}

