/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.math.PointGroupO;
import com.mojang.serialization.Codec;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.EnumBlockRotation;

public final class EnumBlockMirror
extends Enum<EnumBlockMirror>
implements INamable {
    public static final /* enum */ EnumBlockMirror NONE = new EnumBlockMirror("none", PointGroupO.IDENTITY);
    public static final /* enum */ EnumBlockMirror LEFT_RIGHT = new EnumBlockMirror("left_right", PointGroupO.INVERT_Z);
    public static final /* enum */ EnumBlockMirror FRONT_BACK = new EnumBlockMirror("front_back", PointGroupO.INVERT_X);
    public static final Codec<EnumBlockMirror> CODEC;
    @Deprecated
    public static final Codec<EnumBlockMirror> LEGACY_CODEC;
    private final String id;
    private final IChatBaseComponent symbol;
    private final PointGroupO rotation;
    private static final /* synthetic */ EnumBlockMirror[] i;

    public static EnumBlockMirror[] values() {
        return (EnumBlockMirror[])i.clone();
    }

    public static EnumBlockMirror valueOf(String var0) {
        return Enum.valueOf(EnumBlockMirror.class, var0);
    }

    private EnumBlockMirror(String var2, PointGroupO var3) {
        this.id = var2;
        this.symbol = IChatBaseComponent.translatable("mirror." + var2);
        this.rotation = var3;
    }

    public int mirror(int var0, int var1) {
        int var2 = var1 / 2;
        int var3 = var0 > var2 ? var0 - var1 : var0;
        switch (this.ordinal()) {
            case 2: {
                return (var1 - var3) % var1;
            }
            case 1: {
                return (var2 - var3 + var1) % var1;
            }
        }
        return var0;
    }

    public EnumBlockRotation getRotation(EnumDirection var0) {
        EnumDirection.EnumAxis var1 = var0.getAxis();
        return this == LEFT_RIGHT && var1 == EnumDirection.EnumAxis.Z || this == FRONT_BACK && var1 == EnumDirection.EnumAxis.X ? EnumBlockRotation.CLOCKWISE_180 : EnumBlockRotation.NONE;
    }

    public EnumDirection mirror(EnumDirection var0) {
        if (this == FRONT_BACK && var0.getAxis() == EnumDirection.EnumAxis.X) {
            return var0.getOpposite();
        }
        if (this == LEFT_RIGHT && var0.getAxis() == EnumDirection.EnumAxis.Z) {
            return var0.getOpposite();
        }
        return var0;
    }

    public PointGroupO rotation() {
        return this.rotation;
    }

    public IChatBaseComponent symbol() {
        return this.symbol;
    }

    @Override
    public String getSerializedName() {
        return this.id;
    }

    private static /* synthetic */ EnumBlockMirror[] d() {
        return new EnumBlockMirror[]{NONE, LEFT_RIGHT, FRONT_BACK};
    }

    static {
        i = EnumBlockMirror.d();
        CODEC = INamable.fromEnum(EnumBlockMirror::values);
        LEGACY_CODEC = ExtraCodecs.legacyEnum(EnumBlockMirror::valueOf);
    }
}

