/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapeCollisionEntity;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class PowderSnowBlock
extends Block
implements IFluidSource {
    public static final MapCodec<PowderSnowBlock> CODEC = PowderSnowBlock.simpleCodec(PowderSnowBlock::new);
    private static final float HORIZONTAL_PARTICLE_MOMENTUM_FACTOR = 0.083333336f;
    private static final float IN_BLOCK_HORIZONTAL_SPEED_MULTIPLIER = 0.9f;
    private static final float IN_BLOCK_VERTICAL_SPEED_MULTIPLIER = 1.5f;
    private static final float NUM_BLOCKS_TO_FALL_INTO_BLOCK = 2.5f;
    private static final VoxelShape FALLING_COLLISION_SHAPE = VoxelShapes.box(0.0, 0.0, 0.0, 1.0, 0.9f, 1.0);
    private static final double MINIMUM_FALL_DISTANCE_FOR_SOUND = 4.0;
    private static final double MINIMUM_FALL_DISTANCE_FOR_BIG_SOUND = 7.0;

    public MapCodec<PowderSnowBlock> codec() {
        return CODEC;
    }

    public PowderSnowBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected boolean skipRendering(IBlockData var0, IBlockData var1, EnumDirection var2) {
        if (var1.is(this)) {
            return true;
        }
        return super.skipRendering(var0, var1, var2);
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4, boolean var5) {
        Object var6;
        if (!(var3 instanceof EntityLiving) || var3.getInBlockState().is(this)) {
            var3.makeStuckInBlock(var0, new Vec3D(0.9f, 1.5, 0.9f));
            if (var1.isClientSide()) {
                boolean var7;
                var6 = var1.getRandom();
                boolean bl = var7 = var3.xOld != var3.getX() || var3.zOld != var3.getZ();
                if (var7 && var6.nextBoolean()) {
                    var1.addParticle(Particles.SNOWFLAKE, var3.getX(), var2.getY() + 1, var3.getZ(), MathHelper.randomBetween((RandomSource)var6, -1.0f, 1.0f) * 0.083333336f, 0.05f, MathHelper.randomBetween((RandomSource)var6, -1.0f, 1.0f) * 0.083333336f);
                }
            }
        }
        var6 = var2.immutable();
        var4.runBefore(InsideBlockEffectType.EXTINGUISH, arg_0 -> PowderSnowBlock.a(var1, (BlockPosition)var6, arg_0));
        var4.apply(InsideBlockEffectType.FREEZE);
        var4.apply(InsideBlockEffectType.EXTINGUISH);
    }

    @Override
    public void fallOn(World var0, IBlockData var1, BlockPosition var2, Entity var3, double var4) {
        if (var4 < 4.0 || !(var3 instanceof EntityLiving)) {
            return;
        }
        EntityLiving var6 = (EntityLiving)var3;
        EntityLiving.a var7 = var6.getFallSounds();
        SoundEffect var8 = var4 < 7.0 ? var7.small() : var7.big();
        var3.playSound(var8, 1.0f, 1.0f);
    }

    @Override
    protected VoxelShape getEntityInsideCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, Entity var3) {
        VoxelShape var4 = this.getCollisionShape(var0, var1, var2, VoxelShapeCollision.of(var3));
        return var4.isEmpty() ? VoxelShapes.block() : var4;
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        VoxelShapeCollisionEntity var4;
        Entity var5;
        if (!var3.isPlacement() && var3 instanceof VoxelShapeCollisionEntity && (var5 = (var4 = (VoxelShapeCollisionEntity)var3).getEntity()) != null) {
            if (var5.fallDistance > 2.5) {
                return FALLING_COLLISION_SHAPE;
            }
            boolean var6 = var5 instanceof EntityFallingBlock;
            if (var6 || PowderSnowBlock.canEntityWalkOnPowderSnow(var5) && var3.isAbove(VoxelShapes.block(), var2, false) && !var3.isDescending()) {
                return super.getCollisionShape(var0, var1, var2, var3);
            }
        }
        return VoxelShapes.empty();
    }

    @Override
    protected VoxelShape getVisualShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return VoxelShapes.empty();
    }

    public static boolean canEntityWalkOnPowderSnow(Entity var0) {
        if (var0.getType().is(TagsEntity.POWDER_SNOW_WALKABLE_MOBS)) {
            return true;
        }
        if (var0 instanceof EntityLiving) {
            return ((EntityLiving)var0).getItemBySlot(EnumItemSlot.FEET).is(Items.LEATHER_BOOTS);
        }
        return false;
    }

    @Override
    public ItemStack pickupBlock(@Nullable EntityLiving var0, GeneratorAccess var1, BlockPosition var2, IBlockData var3) {
        var1.setBlock(var2, Blocks.AIR.defaultBlockState(), 11);
        if (!var1.isClientSide()) {
            var1.levelEvent(2001, var2, Block.getId(var3));
        }
        return new ItemStack(Items.POWDER_SNOW_BUCKET);
    }

    @Override
    public Optional<SoundEffect> getPickupSound() {
        return Optional.of(SoundEffects.BUCKET_FILL_POWDER_SNOW);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return true;
    }

    private static /* synthetic */ void a(World var0, BlockPosition var1, Entity var2) {
        if (var0 instanceof WorldServer) {
            WorldServer var3 = (WorldServer)var0;
            if (var2.isOnFire() && (var3.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) || var2 instanceof EntityHuman) && var2.mayInteract(var3, var1)) {
                var0.destroyBlock(var1, false);
            }
        }
    }
}

