/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Collection;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreadeableBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;

public class SculkVeinBlock
extends MultifaceSpreadeableBlock
implements SculkBehaviour {
    public static final MapCodec<SculkVeinBlock> CODEC = SculkVeinBlock.simpleCodec(SculkVeinBlock::new);
    private final MultifaceSpreader veinSpreader = new MultifaceSpreader(new a(this, MultifaceSpreader.DEFAULT_SPREAD_ORDER));
    private final MultifaceSpreader sameSpaceSpreader = new MultifaceSpreader(new a(this, MultifaceSpreader.e.SAME_POSITION));

    public MapCodec<SculkVeinBlock> codec() {
        return CODEC;
    }

    public SculkVeinBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public MultifaceSpreader getSpreader() {
        return this.veinSpreader;
    }

    public MultifaceSpreader getSameSpaceSpreader() {
        return this.sameSpaceSpreader;
    }

    public static boolean regrow(GeneratorAccess var0, BlockPosition var1, IBlockData var2, Collection<EnumDirection> var3) {
        boolean var4 = false;
        IBlockData var5 = Blocks.SCULK_VEIN.defaultBlockState();
        for (EnumDirection var7 : var3) {
            if (!SculkVeinBlock.canAttachTo(var0, var1, var7)) continue;
            var5 = (IBlockData)var5.setValue(SculkVeinBlock.getFaceProperty(var7), true);
            var4 = true;
        }
        if (!var4) {
            return false;
        }
        if (!var2.getFluidState().isEmpty()) {
            var5 = (IBlockData)var5.setValue(MultifaceBlock.WATERLOGGED, true);
        }
        var0.setBlock(var1, var5, 3);
        return true;
    }

    @Override
    public void onDischarged(GeneratorAccess var0, IBlockData var1, BlockPosition var2, RandomSource var3) {
        if (!var1.is(this)) {
            return;
        }
        for (EnumDirection var7 : DIRECTIONS) {
            BlockStateBoolean var8 = SculkVeinBlock.getFaceProperty(var7);
            if (!var1.getValue(var8).booleanValue() || !var0.getBlockState(var2.relative(var7)).is(Blocks.SCULK)) continue;
            var1 = (IBlockData)var1.setValue(var8, false);
        }
        if (!SculkVeinBlock.hasAnyFace(var1)) {
            Fluid var4 = var0.getFluidState(var2);
            var1 = (var4.isEmpty() ? Blocks.AIR : Blocks.WATER).defaultBlockState();
        }
        var0.setBlock(var2, var1, 3);
        SculkBehaviour.super.onDischarged(var0, var1, var2, var3);
    }

    @Override
    public int attemptUseCharge(SculkSpreader.a var0, GeneratorAccess var1, BlockPosition var2, RandomSource var3, SculkSpreader var4, boolean var5) {
        if (var5 && this.attemptPlaceSculk(var4, var1, var0.getPos(), var3)) {
            return var0.getCharge() - 1;
        }
        return var3.nextInt(var4.chargeDecayRate()) == 0 ? MathHelper.floor((float)var0.getCharge() * 0.5f) : var0.getCharge();
    }

    private boolean attemptPlaceSculk(SculkSpreader var0, GeneratorAccess var1, BlockPosition var2, RandomSource var3) {
        IBlockData var4 = var1.getBlockState(var2);
        TagKey<Block> var5 = var0.replaceableBlocks();
        for (EnumDirection var7 : EnumDirection.allShuffled(var3)) {
            BlockPosition var8;
            IBlockData var9;
            if (!SculkVeinBlock.hasFace(var4, var7) || !(var9 = var1.getBlockState(var8 = var2.relative(var7))).is(var5)) continue;
            IBlockData var10 = Blocks.SCULK.defaultBlockState();
            var1.setBlock(var8, var10, 3);
            Block.pushEntitiesUp(var9, var10, var1, var8);
            var1.playSound(null, var8, SoundEffects.SCULK_BLOCK_SPREAD, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.veinSpreader.spreadAll(var10, var1, var8, var0.isWorldGeneration());
            EnumDirection var11 = var7.getOpposite();
            for (EnumDirection var15 : DIRECTIONS) {
                BlockPosition var16;
                IBlockData var17;
                if (var15 == var11 || !(var17 = var1.getBlockState(var16 = var8.relative(var15))).is(this)) continue;
                this.onDischarged(var1, var17, var16, var3);
            }
            return true;
        }
        return false;
    }

    public static boolean hasSubstrateAccess(GeneratorAccess var0, IBlockData var1, BlockPosition var2) {
        if (!var1.is(Blocks.SCULK_VEIN)) {
            return false;
        }
        for (EnumDirection var6 : DIRECTIONS) {
            if (!SculkVeinBlock.hasFace(var1, var6) || !var0.getBlockState(var2.relative(var6)).is(TagsBlock.SCULK_REPLACEABLE)) continue;
            return true;
        }
        return false;
    }

    class a
    extends MultifaceSpreader.a {
        private final MultifaceSpreader.e[] spreadTypes;

        public a(SculkVeinBlock sculkVeinBlock, MultifaceSpreader.e ... var1) {
            super(sculkVeinBlock);
            this.spreadTypes = var1;
        }

        @Override
        public boolean stateCanBeReplaced(IBlockAccess var0, BlockPosition var1, BlockPosition var2, EnumDirection var3, IBlockData var4) {
            Object var6;
            IBlockData var5 = var0.getBlockState(var2.relative(var3));
            if (var5.is(Blocks.SCULK) || var5.is(Blocks.SCULK_CATALYST) || var5.is(Blocks.MOVING_PISTON)) {
                return false;
            }
            if (var1.distManhattan(var2) == 2 && var0.getBlockState((BlockPosition)(var6 = var1.relative(var3.getOpposite()))).isFaceSturdy(var0, (BlockPosition)var6, var3)) {
                return false;
            }
            var6 = var4.getFluidState();
            if (!((Fluid)var6).isEmpty() && !((Fluid)var6).is(FluidTypes.WATER)) {
                return false;
            }
            if (var4.is(TagsBlock.FIRE)) {
                return false;
            }
            return var4.canBeReplaced() || super.stateCanBeReplaced(var0, var1, var2, var3, var4);
        }

        @Override
        public MultifaceSpreader.e[] getSpreadTypes() {
            return this.spreadTypes;
        }

        @Override
        public boolean isOtherBlockValidAsSource(IBlockData var0) {
            return !var0.is(Blocks.SCULK_VEIN);
        }
    }
}

