/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.piston.PistonExtendsChecker;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockPiston
extends BlockDirectional {
    public static final MapCodec<BlockPiston> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.BOOL.fieldOf("sticky").forGetter(var0 -> var0.isSticky), BlockPiston.propertiesCodec()).apply((Applicative)var02, BlockPiston::new));
    public static final BlockStateBoolean EXTENDED = BlockProperties.EXTENDED;
    public static final int TRIGGER_EXTEND = 0;
    public static final int TRIGGER_CONTRACT = 1;
    public static final int TRIGGER_DROP = 2;
    public static final int PLATFORM_THICKNESS = 4;
    private static final Map<EnumDirection, VoxelShape> SHAPES = VoxelShapes.rotateAll(Block.boxZ(16.0, 4.0, 16.0));
    private final boolean isSticky;

    public MapCodec<BlockPiston> codec() {
        return CODEC;
    }

    public BlockPiston(boolean var0, BlockBase.Info var1) {
        super(var1);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(EXTENDED, false));
        this.isSticky = var0;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (var0.getValue(EXTENDED).booleanValue()) {
            return SHAPES.get(var0.getValue(FACING));
        }
        return VoxelShapes.block();
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, EntityLiving var3, ItemStack var4) {
        if (!var0.isClientSide()) {
            this.checkIfExtend(var0, var1, var2);
        }
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (!var1.isClientSide()) {
            this.checkIfExtend(var1, var2, var0);
        }
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        if (!var1.isClientSide() && var1.getBlockEntity(var2) == null) {
            this.checkIfExtend(var1, var2, var0);
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var0.getNearestLookingDirection().getOpposite())).setValue(EXTENDED, false);
    }

    private void checkIfExtend(World var0, BlockPosition var1, IBlockData var2) {
        EnumDirection var3 = (EnumDirection)var2.getValue(FACING);
        boolean var4 = this.getNeighborSignal(var0, var1, var3);
        if (var4 && !var2.getValue(EXTENDED).booleanValue()) {
            if (new PistonExtendsChecker(var0, var1, var3, true).resolve()) {
                var0.blockEvent(var1, this, 0, var3.get3DDataValue());
            }
        } else if (!var4 && var2.getValue(EXTENDED).booleanValue()) {
            TileEntityPiston var9;
            TileEntity var8;
            BlockPosition var5 = var1.relative(var3, 2);
            IBlockData var6 = var0.getBlockState(var5);
            int var7 = 1;
            if (var6.is(Blocks.MOVING_PISTON) && var6.getValue(FACING) == var3 && (var8 = var0.getBlockEntity(var5)) instanceof TileEntityPiston && (var9 = (TileEntityPiston)var8).isExtending() && (var9.getProgress(0.0f) < 0.5f || var0.getGameTime() == var9.getLastTicked() || ((WorldServer)var0).isHandlingTick())) {
                var7 = 2;
            }
            var0.blockEvent(var1, this, var7, var3.get3DDataValue());
        }
    }

    private boolean getNeighborSignal(SignalGetter var0, BlockPosition var1, EnumDirection var2) {
        for (EnumDirection var6 : EnumDirection.values()) {
            if (var6 == var2 || !var0.hasSignal(var1.relative(var6), var6)) continue;
            return true;
        }
        if (var0.hasSignal(var1, EnumDirection.DOWN)) {
            return true;
        }
        BlockPosition var3 = var1.above();
        for (EnumDirection var7 : EnumDirection.values()) {
            if (var7 == EnumDirection.DOWN || !var0.hasSignal(var3.relative(var7), var7)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean triggerEvent(IBlockData var0, World var1, BlockPosition var2, int var3, int var4) {
        EnumDirection var5 = (EnumDirection)var0.getValue(FACING);
        IBlockData var6 = (IBlockData)var0.setValue(EXTENDED, true);
        if (!var1.isClientSide()) {
            boolean var7 = this.getNeighborSignal(var1, var2, var5);
            if (var7 && (var3 == 1 || var3 == 2)) {
                var1.setBlock(var2, var6, 2);
                return false;
            }
            if (!var7 && var3 == 0) {
                return false;
            }
        }
        if (var3 == 0) {
            if (!this.moveBlocks(var1, var2, var5, true)) return false;
            var1.setBlock(var2, var6, 67);
            var1.playSound(null, var2, SoundEffects.PISTON_EXTEND, SoundCategory.BLOCKS, 0.5f, var1.random.nextFloat() * 0.25f + 0.6f);
            var1.gameEvent(GameEvent.BLOCK_ACTIVATE, var2, GameEvent.a.of(var6));
            return true;
        } else {
            if (var3 != 1 && var3 != 2) return true;
            TileEntity var7 = var1.getBlockEntity(var2.relative(var5));
            if (var7 instanceof TileEntityPiston) {
                ((TileEntityPiston)var7).finalTick();
            }
            IBlockData var8 = (IBlockData)((IBlockData)Blocks.MOVING_PISTON.defaultBlockState().setValue(BlockPistonMoving.FACING, var5)).setValue(BlockPistonMoving.TYPE, this.isSticky ? BlockPropertyPistonType.STICKY : BlockPropertyPistonType.DEFAULT);
            var1.setBlock(var2, var8, 276);
            var1.setBlockEntity(BlockPistonMoving.newMovingBlockEntity(var2, var8, (IBlockData)this.defaultBlockState().setValue(FACING, EnumDirection.from3DDataValue(var4 & 7)), var5, false, true));
            var1.updateNeighborsAt(var2, var8.getBlock());
            var8.updateNeighbourShapes(var1, var2, 2);
            if (this.isSticky) {
                TileEntityPiston var13;
                TileEntity var12;
                BlockPosition var9 = var2.offset(var5.getStepX() * 2, var5.getStepY() * 2, var5.getStepZ() * 2);
                IBlockData var10 = var1.getBlockState(var9);
                boolean var11 = false;
                if (var10.is(Blocks.MOVING_PISTON) && (var12 = var1.getBlockEntity(var9)) instanceof TileEntityPiston && (var13 = (TileEntityPiston)var12).getDirection() == var5 && var13.isExtending()) {
                    var13.finalTick();
                    var11 = true;
                }
                if (!var11) {
                    if (var3 == 1 && !var10.isAir() && BlockPiston.isPushable(var10, var1, var9, var5.getOpposite(), false, var5) && (var10.getPistonPushReaction() == EnumPistonReaction.NORMAL || var10.is(Blocks.PISTON) || var10.is(Blocks.STICKY_PISTON))) {
                        this.moveBlocks(var1, var2, var5, false);
                    } else {
                        var1.removeBlock(var2.relative(var5), false);
                    }
                }
            } else {
                var1.removeBlock(var2.relative(var5), false);
            }
            var1.playSound(null, var2, SoundEffects.PISTON_CONTRACT, SoundCategory.BLOCKS, 0.5f, var1.random.nextFloat() * 0.15f + 0.6f);
            var1.gameEvent(GameEvent.BLOCK_DEACTIVATE, var2, GameEvent.a.of(var8));
        }
        return true;
    }

    public static boolean isPushable(IBlockData var0, World var1, BlockPosition var2, EnumDirection var3, boolean var4, EnumDirection var5) {
        if (var2.getY() < var1.getMinY() || var2.getY() > var1.getMaxY() || !var1.getWorldBorder().isWithinBounds(var2)) {
            return false;
        }
        if (var0.isAir()) {
            return true;
        }
        if (var0.is(Blocks.OBSIDIAN) || var0.is(Blocks.CRYING_OBSIDIAN) || var0.is(Blocks.RESPAWN_ANCHOR) || var0.is(Blocks.REINFORCED_DEEPSLATE)) {
            return false;
        }
        if (var3 == EnumDirection.DOWN && var2.getY() == var1.getMinY()) {
            return false;
        }
        if (var3 == EnumDirection.UP && var2.getY() == var1.getMaxY()) {
            return false;
        }
        if (var0.is(Blocks.PISTON) || var0.is(Blocks.STICKY_PISTON)) {
            if (var0.getValue(EXTENDED).booleanValue()) {
                return false;
            }
        } else {
            if (var0.getDestroySpeed(var1, var2) == -1.0f) {
                return false;
            }
            switch (var0.getPistonPushReaction()) {
                case BLOCK: {
                    return false;
                }
                case DESTROY: {
                    return var4;
                }
                case PUSH_ONLY: {
                    return var3 == var5;
                }
            }
        }
        return !var0.hasBlockEntity();
    }

    /*
     * WARNING - void declaration
     */
    private boolean moveBlocks(World var0, BlockPosition var1, EnumDirection var2, boolean var3) {
        void var16_31;
        void var16_29;
        Object var17;
        Object var16;
        Object var14;
        int var13;
        Object var11;
        PistonExtendsChecker var5;
        BlockPosition var4 = var1.relative(var2);
        if (!var3 && var0.getBlockState(var4).is(Blocks.PISTON_HEAD)) {
            var0.setBlock(var4, Blocks.AIR.defaultBlockState(), 276);
        }
        if (!(var5 = new PistonExtendsChecker(var0, var1, var2, var3)).resolve()) {
            return false;
        }
        HashMap var6 = Maps.newHashMap();
        List<BlockPosition> var7 = var5.getToPush();
        ArrayList var8 = Lists.newArrayList();
        for (BlockPosition blockPosition : var7) {
            var11 = var0.getBlockState(blockPosition);
            var8.add(var11);
            var6.put(blockPosition, var11);
        }
        List<BlockPosition> var9 = var5.getToDestroy();
        IBlockData[] iBlockDataArray = new IBlockData[var7.size() + var9.size()];
        var11 = var3 ? var2 : var2.getOpposite();
        int var12 = 0;
        for (var13 = var9.size() - 1; var13 >= 0; --var13) {
            var14 = var9.get(var13);
            IBlockData iBlockData = var0.getBlockState((BlockPosition)var14);
            var16 = iBlockData.hasBlockEntity() ? var0.getBlockEntity((BlockPosition)var14) : null;
            BlockPiston.dropResources(iBlockData, var0, (BlockPosition)var14, (TileEntity)var16);
            if (!iBlockData.is(TagsBlock.FIRE) && var0.isClientSide()) {
                var0.levelEvent(2001, (BlockPosition)var14, BlockPiston.getId(iBlockData));
            }
            var0.setBlock((BlockPosition)var14, Blocks.AIR.defaultBlockState(), 18);
            var0.gameEvent(GameEvent.BLOCK_DESTROY, (BlockPosition)var14, GameEvent.a.of(iBlockData));
            iBlockDataArray[var12++] = iBlockData;
        }
        for (var13 = var7.size() - 1; var13 >= 0; --var13) {
            var14 = var7.get(var13);
            IBlockData iBlockData = var0.getBlockState((BlockPosition)var14);
            var14 = ((BlockPosition)var14).relative((EnumDirection)var11);
            var6.remove(var14);
            var16 = (IBlockData)Blocks.MOVING_PISTON.defaultBlockState().setValue(FACING, var2);
            var0.setBlock((BlockPosition)var14, (IBlockData)var16, 324);
            var0.setBlockEntity(BlockPistonMoving.newMovingBlockEntity((BlockPosition)var14, (IBlockData)var16, (IBlockData)var8.get(var13), var2, var3, false));
            iBlockDataArray[var12++] = iBlockData;
        }
        if (var3) {
            BlockPropertyPistonType var132 = this.isSticky ? BlockPropertyPistonType.STICKY : BlockPropertyPistonType.DEFAULT;
            var14 = (IBlockData)((IBlockData)Blocks.PISTON_HEAD.defaultBlockState().setValue(BlockPistonExtension.FACING, var2)).setValue(BlockPistonExtension.TYPE, var132);
            IBlockData iBlockData = (IBlockData)((IBlockData)Blocks.MOVING_PISTON.defaultBlockState().setValue(BlockPistonMoving.FACING, var2)).setValue(BlockPistonMoving.TYPE, this.isSticky ? BlockPropertyPistonType.STICKY : BlockPropertyPistonType.DEFAULT);
            var6.remove(var4);
            var0.setBlock(var4, iBlockData, 324);
            var0.setBlockEntity(BlockPistonMoving.newMovingBlockEntity(var4, iBlockData, (IBlockData)var14, var2, true, true));
        }
        IBlockData var133 = Blocks.AIR.defaultBlockState();
        for (BlockPosition blockPosition : var6.keySet()) {
            var0.setBlock(blockPosition, var133, 82);
        }
        for (Map.Entry entry : var6.entrySet()) {
            var16 = (BlockPosition)entry.getKey();
            var17 = (IBlockData)entry.getValue();
            ((BlockBase.BlockData)var17).updateIndirectNeighbourShapes(var0, (BlockPosition)var16, 2);
            var133.updateNeighbourShapes(var0, (BlockPosition)var16, 2);
            var133.updateIndirectNeighbourShapes(var0, (BlockPosition)var16, 2);
        }
        var14 = ExperimentalRedstoneUtils.initialOrientation(var0, var5.getPushDirection(), null);
        var12 = 0;
        int n2 = var9.size() - 1;
        while (var16_29 >= 0) {
            var16 = iBlockDataArray[var12++];
            var17 = var9.get((int)var16_29);
            if (var0 instanceof WorldServer) {
                WorldServer var18 = (WorldServer)var0;
                ((BlockBase.BlockData)var16).affectNeighborsAfterRemoval(var18, (BlockPosition)var17, false);
            }
            ((BlockBase.BlockData)var16).updateIndirectNeighbourShapes(var0, (BlockPosition)var17, 2);
            var0.updateNeighborsAt((BlockPosition)var17, ((BlockBase.BlockData)var16).getBlock(), (Orientation)var14);
            --var16_29;
        }
        int n3 = var7.size() - 1;
        while (var16_31 >= 0) {
            var0.updateNeighborsAt(var7.get((int)var16_31), iBlockDataArray[var12++].getBlock(), (Orientation)var14);
            --var16_31;
        }
        if (var3) {
            var0.updateNeighborsAt(var4, Blocks.PISTON_HEAD, (Orientation)var14);
        }
        return true;
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate((EnumDirection)var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation((EnumDirection)var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, EXTENDED);
    }

    @Override
    protected boolean useShapeForLightOcclusion(IBlockData var0) {
        return var0.getValue(EXTENDED);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

