/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.PistonUtil;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class TileEntityPiston
extends TileEntity {
    private static final int TICKS_TO_EXTEND = 2;
    private static final double PUSH_OFFSET = 0.01;
    public static final double TICK_MOVEMENT = 0.51;
    private static final IBlockData DEFAULT_BLOCK_STATE = Blocks.AIR.defaultBlockState();
    private static final float DEFAULT_PROGRESS = 0.0f;
    private static final boolean DEFAULT_EXTENDING = false;
    private static final boolean DEFAULT_SOURCE = false;
    private IBlockData movedState = DEFAULT_BLOCK_STATE;
    private EnumDirection direction;
    private boolean extending = false;
    private boolean isSourcePiston = false;
    private static final ThreadLocal<EnumDirection> NOCLIP = ThreadLocal.withInitial(() -> null);
    private float progress = 0.0f;
    private float progressO = 0.0f;
    private long lastTicked;
    private int deathTicks;

    public TileEntityPiston(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.PISTON, var0, var1);
    }

    public TileEntityPiston(BlockPosition var0, IBlockData var1, IBlockData var2, EnumDirection var3, boolean var4, boolean var5) {
        this(var0, var1);
        this.movedState = var2;
        this.direction = var3;
        this.extending = var4;
        this.isSourcePiston = var5;
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.saveCustomOnly(var0);
    }

    public boolean isExtending() {
        return this.extending;
    }

    public EnumDirection getDirection() {
        return this.direction;
    }

    public boolean isSourcePiston() {
        return this.isSourcePiston;
    }

    public float getProgress(float var0) {
        if (var0 > 1.0f) {
            var0 = 1.0f;
        }
        return MathHelper.lerp(var0, this.progressO, this.progress);
    }

    public float getXOff(float var0) {
        return (float)this.direction.getStepX() * this.getExtendedProgress(this.getProgress(var0));
    }

    public float getYOff(float var0) {
        return (float)this.direction.getStepY() * this.getExtendedProgress(this.getProgress(var0));
    }

    public float getZOff(float var0) {
        return (float)this.direction.getStepZ() * this.getExtendedProgress(this.getProgress(var0));
    }

    private float getExtendedProgress(float var0) {
        return this.extending ? var0 - 1.0f : 1.0f - var0;
    }

    private IBlockData getCollisionRelatedBlockState() {
        if (!this.isExtending() && this.isSourcePiston() && this.movedState.getBlock() instanceof BlockPiston) {
            return (IBlockData)((IBlockData)((IBlockData)Blocks.PISTON_HEAD.defaultBlockState().setValue(BlockPistonExtension.SHORT, this.progress > 0.25f)).setValue(BlockPistonExtension.TYPE, this.movedState.is(Blocks.STICKY_PISTON) ? BlockPropertyPistonType.STICKY : BlockPropertyPistonType.DEFAULT)).setValue(BlockPistonExtension.FACING, (EnumDirection)this.movedState.getValue(BlockPiston.FACING));
        }
        return this.movedState;
    }

    private static void moveCollidedEntities(World var0, BlockPosition var1, float var2, TileEntityPiston var3) {
        EnumDirection var4 = var3.getMovementDirection();
        double var5 = var2 - var3.progress;
        VoxelShape var7 = var3.getCollisionRelatedBlockState().getCollisionShape(var0, var1);
        if (var7.isEmpty()) {
            return;
        }
        AxisAlignedBB var8 = TileEntityPiston.moveByPositionAndProgress(var1, var7.bounds(), var3);
        List<Entity> var9 = var0.getEntities(null, PistonUtil.getMovementArea(var8, var4, var5).minmax(var8));
        if (var9.isEmpty()) {
            return;
        }
        List<AxisAlignedBB> var10 = var7.toAabbs();
        boolean var11 = var3.movedState.is(Blocks.SLIME_BLOCK);
        for (Entity var13 : var9) {
            AxisAlignedBB var19;
            AxisAlignedBB var17;
            AxisAlignedBB var18;
            if (var13.getPistonPushReaction() == EnumPistonReaction.IGNORE) continue;
            if (var11) {
                if (var13 instanceof EntityPlayer) continue;
                Vec3D var14 = var13.getDeltaMovement();
                double var15 = var14.x;
                double var172 = var14.y;
                double var192 = var14.z;
                switch (var4.getAxis()) {
                    case X: {
                        var15 = var4.getStepX();
                        break;
                    }
                    case Y: {
                        var172 = var4.getStepY();
                        break;
                    }
                    case Z: {
                        var192 = var4.getStepZ();
                    }
                }
                var13.setDeltaMovement(var15, var172, var192);
            }
            double var14 = 0.0;
            Iterator<AxisAlignedBB> iterator = var10.iterator();
            while (!(!iterator.hasNext() || (var18 = PistonUtil.getMovementArea(TileEntityPiston.moveByPositionAndProgress(var1, var17 = iterator.next(), var3), var4, var5)).intersects(var19 = var13.getBoundingBox()) && (var14 = Math.max(var14, TileEntityPiston.getMovement(var18, var4, var19))) >= var5)) {
            }
            if (var14 <= 0.0) continue;
            var14 = Math.min(var14, var5) + 0.01;
            TileEntityPiston.moveEntityByPiston(var4, var13, var14, var4);
            if (var3.extending || !var3.isSourcePiston) continue;
            TileEntityPiston.fixEntityWithinPistonBase(var1, var13, var4, var5);
        }
    }

    private static void moveEntityByPiston(EnumDirection var0, Entity var1, double var2, EnumDirection var4) {
        NOCLIP.set(var0);
        Vec3D var5 = var1.position();
        var1.move(EnumMoveType.PISTON, new Vec3D(var2 * (double)var4.getStepX(), var2 * (double)var4.getStepY(), var2 * (double)var4.getStepZ()));
        var1.applyEffectsFromBlocks(var5, var1.position());
        var1.removeLatestMovementRecording();
        NOCLIP.set(null);
    }

    private static void moveStuckEntities(World var0, BlockPosition var1, float var22, TileEntityPiston var3) {
        if (!var3.isStickyForEntities()) {
            return;
        }
        EnumDirection var4 = var3.getMovementDirection();
        if (!var4.getAxis().isHorizontal()) {
            return;
        }
        double var5 = var3.movedState.getCollisionShape(var0, var1).max(EnumDirection.EnumAxis.Y);
        AxisAlignedBB var7 = TileEntityPiston.moveByPositionAndProgress(var1, new AxisAlignedBB(0.0, var5, 0.0, 1.0, 1.5000010000000001, 1.0), var3);
        double var8 = var22 - var3.progress;
        List<Entity> var10 = var0.getEntities((Entity)null, var7, var2 -> TileEntityPiston.matchesStickyCritera(var7, var2, var1));
        for (Entity var12 : var10) {
            TileEntityPiston.moveEntityByPiston(var4, var12, var8, var4);
        }
    }

    private static boolean matchesStickyCritera(AxisAlignedBB var0, Entity var1, BlockPosition var2) {
        return var1.getPistonPushReaction() == EnumPistonReaction.NORMAL && var1.onGround() && (var1.isSupportedBy(var2) || var1.getX() >= var0.minX && var1.getX() <= var0.maxX && var1.getZ() >= var0.minZ && var1.getZ() <= var0.maxZ);
    }

    private boolean isStickyForEntities() {
        return this.movedState.is(Blocks.HONEY_BLOCK);
    }

    public EnumDirection getMovementDirection() {
        return this.extending ? this.direction : this.direction.getOpposite();
    }

    private static double getMovement(AxisAlignedBB var0, EnumDirection var1, AxisAlignedBB var2) {
        switch (var1) {
            case EAST: {
                return var0.maxX - var2.minX;
            }
            case WEST: {
                return var2.maxX - var0.minX;
            }
            default: {
                return var0.maxY - var2.minY;
            }
            case DOWN: {
                return var2.maxY - var0.minY;
            }
            case SOUTH: {
                return var0.maxZ - var2.minZ;
            }
            case NORTH: 
        }
        return var2.maxZ - var0.minZ;
    }

    private static AxisAlignedBB moveByPositionAndProgress(BlockPosition var0, AxisAlignedBB var1, TileEntityPiston var2) {
        double var3 = var2.getExtendedProgress(var2.progress);
        return var1.move((double)var0.getX() + var3 * (double)var2.direction.getStepX(), (double)var0.getY() + var3 * (double)var2.direction.getStepY(), (double)var0.getZ() + var3 * (double)var2.direction.getStepZ());
    }

    private static void fixEntityWithinPistonBase(BlockPosition var0, Entity var1, EnumDirection var2, double var3) {
        double var10;
        EnumDirection var7;
        double var8;
        AxisAlignedBB var6;
        AxisAlignedBB var5 = var1.getBoundingBox();
        if (var5.intersects(var6 = VoxelShapes.block().bounds().move(var0)) && Math.abs((var8 = TileEntityPiston.getMovement(var6, var7 = var2.getOpposite(), var5) + 0.01) - (var10 = TileEntityPiston.getMovement(var6, var7, var5.intersect(var6)) + 0.01)) < 0.01) {
            var8 = Math.min(var8, var3) + 0.01;
            TileEntityPiston.moveEntityByPiston(var2, var1, var8, var7);
        }
    }

    public IBlockData getMovedState() {
        return this.movedState;
    }

    public void finalTick() {
        if (this.level != null && (this.progressO < 1.0f || this.level.isClientSide())) {
            this.progressO = this.progress = 1.0f;
            this.level.removeBlockEntity(this.worldPosition);
            this.setRemoved();
            if (this.level.getBlockState(this.worldPosition).is(Blocks.MOVING_PISTON)) {
                IBlockData var0 = this.isSourcePiston ? Blocks.AIR.defaultBlockState() : Block.updateFromNeighbourShapes(this.movedState, this.level, this.worldPosition);
                this.level.setBlock(this.worldPosition, var0, 3);
                this.level.neighborChanged(this.worldPosition, var0.getBlock(), ExperimentalRedstoneUtils.initialOrientation(this.level, this.getPushDirection(), null));
            }
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPosition var0, IBlockData var1) {
        this.finalTick();
    }

    public EnumDirection getPushDirection() {
        return this.extending ? this.direction : this.direction.getOpposite();
    }

    public static void tick(World var0, BlockPosition var1, IBlockData var2, TileEntityPiston var3) {
        var3.lastTicked = var0.getGameTime();
        var3.progressO = var3.progress;
        if (var3.progressO >= 1.0f) {
            if (var0.isClientSide() && var3.deathTicks < 5) {
                ++var3.deathTicks;
                return;
            }
            var0.removeBlockEntity(var1);
            var3.setRemoved();
            if (var0.getBlockState(var1).is(Blocks.MOVING_PISTON)) {
                IBlockData var4 = Block.updateFromNeighbourShapes(var3.movedState, var0, var1);
                if (var4.isAir()) {
                    var0.setBlock(var1, var3.movedState, 340);
                    Block.updateOrDestroy(var3.movedState, var4, var0, var1, 3);
                } else {
                    if (var4.hasProperty(BlockProperties.WATERLOGGED) && var4.getValue(BlockProperties.WATERLOGGED).booleanValue()) {
                        var4 = (IBlockData)var4.setValue(BlockProperties.WATERLOGGED, false);
                    }
                    var0.setBlock(var1, var4, 67);
                    var0.neighborChanged(var1, var4.getBlock(), ExperimentalRedstoneUtils.initialOrientation(var0, var3.getPushDirection(), null));
                }
            }
            return;
        }
        float var4 = var3.progress + 0.5f;
        TileEntityPiston.moveCollidedEntities(var0, var1, var4, var3);
        TileEntityPiston.moveStuckEntities(var0, var1, var4, var3);
        var3.progress = var4;
        if (var3.progress >= 1.0f) {
            var3.progress = 1.0f;
        }
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.movedState = var0.read("blockState", IBlockData.CODEC).orElse(DEFAULT_BLOCK_STATE);
        this.direction = var0.read("facing", EnumDirection.LEGACY_ID_CODEC).orElse(EnumDirection.DOWN);
        this.progressO = this.progress = var0.getFloatOr("progress", 0.0f);
        this.extending = var0.getBooleanOr("extending", false);
        this.isSourcePiston = var0.getBooleanOr("source", false);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        var0.store("blockState", IBlockData.CODEC, this.movedState);
        var0.store("facing", EnumDirection.LEGACY_ID_CODEC, this.direction);
        var0.putFloat("progress", this.progressO);
        var0.putBoolean("extending", this.extending);
        var0.putBoolean("source", this.isSourcePiston);
    }

    public VoxelShape getCollisionShape(IBlockAccess var0, BlockPosition var1) {
        VoxelShape var2 = !this.extending && this.isSourcePiston && this.movedState.getBlock() instanceof BlockPiston ? ((IBlockData)this.movedState.setValue(BlockPiston.EXTENDED, true)).getCollisionShape(var0, var1) : VoxelShapes.empty();
        EnumDirection var3 = NOCLIP.get();
        if ((double)this.progress < 1.0 && var3 == this.getMovementDirection()) {
            return var2;
        }
        IBlockData var4 = this.isSourcePiston() ? (IBlockData)((IBlockData)Blocks.PISTON_HEAD.defaultBlockState().setValue(BlockPistonExtension.FACING, this.direction)).setValue(BlockPistonExtension.SHORT, this.extending != 1.0f - this.progress < 0.25f) : this.movedState;
        float var5 = this.getExtendedProgress(this.progress);
        double var6 = (float)this.direction.getStepX() * var5;
        double var8 = (float)this.direction.getStepY() * var5;
        double var10 = (float)this.direction.getStepZ() * var5;
        return VoxelShapes.or(var2, var4.getCollisionShape(var0, var1).move(var6, var8, var10));
    }

    public long getLastTicked() {
        return this.lastTicked;
    }

    @Override
    public void setLevel(World var0) {
        super.setLevel(var0);
        if (var0.holderLookup(Registries.BLOCK).get(this.movedState.getBlock().builtInRegistryHolder().key()).isEmpty()) {
            this.movedState = Blocks.AIR.defaultBlockState();
        }
    }
}

