/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.pattern;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;

public class ShapeDetectorBlock {
    private final IWorldReader level;
    private final BlockPosition pos;
    private final boolean loadChunks;
    @Nullable
    private IBlockData state;
    @Nullable
    private TileEntity entity;
    private boolean cachedEntity;

    public ShapeDetectorBlock(IWorldReader var0, BlockPosition var1, boolean var2) {
        this.level = var0;
        this.pos = var1.immutable();
        this.loadChunks = var2;
    }

    public IBlockData getState() {
        if (this.state == null && (this.loadChunks || this.level.hasChunkAt(this.pos))) {
            this.state = this.level.getBlockState(this.pos);
        }
        return this.state;
    }

    @Nullable
    public TileEntity getEntity() {
        if (this.entity == null && !this.cachedEntity) {
            this.entity = this.level.getBlockEntity(this.pos);
            this.cachedEntity = true;
        }
        return this.entity;
    }

    public IWorldReader getLevel() {
        return this.level;
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public static Predicate<ShapeDetectorBlock> hasState(Predicate<IBlockData> var0) {
        return var1 -> var1 != null && var0.test(var1.getState());
    }
}

