/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.VarInt;
import net.minecraft.util.RegistryID;
import net.minecraft.world.level.chunk.DataPalette;
import net.minecraft.world.level.chunk.DataPaletteExpandable;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;

public class DataPaletteHash<T>
implements DataPalette<T> {
    private final RegistryID<T> values;
    private final int bits;

    public DataPaletteHash(int var0, List<T> var1) {
        this(var0);
        var1.forEach(this.values::add);
    }

    public DataPaletteHash(int var0) {
        this(var0, RegistryID.create(1 << var0));
    }

    private DataPaletteHash(int var0, RegistryID<T> var1) {
        this.bits = var0;
        this.values = var1;
    }

    public static <A> DataPalette<A> create(int var0, List<A> var1) {
        return new DataPaletteHash<A>(var0, var1);
    }

    @Override
    public int idFor(T var0, DataPaletteExpandable<T> var1) {
        int var2 = this.values.getId(var0);
        if (var2 == -1 && (var2 = this.values.add(var0)) >= 1 << this.bits) {
            var2 = var1.onResize(this.bits + 1, var0);
        }
        return var2;
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        for (int var1 = 0; var1 < this.getSize(); ++var1) {
            if (!var0.test(this.values.byId(var1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public T valueFor(int var0) {
        T var1 = this.values.byId(var0);
        if (var1 == null) {
            throw new MissingPaletteEntryException(var0);
        }
        return var1;
    }

    @Override
    public void read(PacketDataSerializer var0, Registry<T> var1) {
        this.values.clear();
        int var2 = var0.readVarInt();
        for (int var3 = 0; var3 < var2; ++var3) {
            this.values.add(var1.byIdOrThrow(var0.readVarInt()));
        }
    }

    @Override
    public void write(PacketDataSerializer var0, Registry<T> var1) {
        int var2 = this.getSize();
        var0.writeVarInt(var2);
        for (int var3 = 0; var3 < var2; ++var3) {
            var0.writeVarInt(var1.getId(this.values.byId(var3)));
        }
    }

    @Override
    public int getSerializedSize(Registry<T> var0) {
        int var1 = VarInt.getByteSize(this.getSize());
        for (int var2 = 0; var2 < this.getSize(); ++var2) {
            var1 += VarInt.getByteSize(var0.getId(this.values.byId(var2)));
        }
        return var1;
    }

    public List<T> getEntries() {
        ArrayList var0 = new ArrayList();
        this.values.iterator().forEachRemaining(var0::add);
        return var0;
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public DataPalette<T> copy() {
        return new DataPaletteHash<T>(this.bits, this.values.copy());
    }
}

