/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;

public record DimensionManager(OptionalLong fixedTime, boolean hasSkyLight, boolean hasCeiling, boolean ultraWarm, boolean natural, double coordinateScale, boolean bedWorks, boolean respawnAnchorWorks, int minY, int height, int logicalHeight, TagKey<Block> infiniburn, MinecraftKey effectsLocation, float ambientLight, Optional<Integer> cloudHeight, a monsterSettings) {
    public static final int BITS_FOR_Y = BlockPosition.PACKED_Y_LENGTH;
    public static final int MIN_HEIGHT = 16;
    public static final int Y_SIZE = (1 << BITS_FOR_Y) - 32;
    public static final int MAX_Y = (Y_SIZE >> 1) - 1;
    public static final int MIN_Y = MAX_Y - Y_SIZE + 1;
    public static final int WAY_ABOVE_MAX_Y = MAX_Y << 4;
    public static final int WAY_BELOW_MIN_Y = MIN_Y << 4;
    public static final Codec<DimensionManager> DIRECT_CODEC = ExtraCodecs.catchDecoderException(RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.asOptionalLong((MapCodec<Optional<Long>>)Codec.LONG.lenientOptionalFieldOf("fixed_time")).forGetter(DimensionManager::fixedTime), (App)Codec.BOOL.fieldOf("has_skylight").forGetter(DimensionManager::hasSkyLight), (App)Codec.BOOL.fieldOf("has_ceiling").forGetter(DimensionManager::hasCeiling), (App)Codec.BOOL.fieldOf("ultrawarm").forGetter(DimensionManager::ultraWarm), (App)Codec.BOOL.fieldOf("natural").forGetter(DimensionManager::natural), (App)Codec.doubleRange((double)1.0E-5f, (double)3.0E7).fieldOf("coordinate_scale").forGetter(DimensionManager::coordinateScale), (App)Codec.BOOL.fieldOf("bed_works").forGetter(DimensionManager::bedWorks), (App)Codec.BOOL.fieldOf("respawn_anchor_works").forGetter(DimensionManager::respawnAnchorWorks), (App)Codec.intRange((int)MIN_Y, (int)MAX_Y).fieldOf("min_y").forGetter(DimensionManager::minY), (App)Codec.intRange((int)16, (int)Y_SIZE).fieldOf("height").forGetter(DimensionManager::height), (App)Codec.intRange((int)0, (int)Y_SIZE).fieldOf("logical_height").forGetter(DimensionManager::logicalHeight), (App)TagKey.hashedCodec(Registries.BLOCK).fieldOf("infiniburn").forGetter(DimensionManager::infiniburn), (App)MinecraftKey.CODEC.fieldOf("effects").orElse((Object)BuiltinDimensionTypes.OVERWORLD_EFFECTS).forGetter(DimensionManager::effectsLocation), (App)Codec.FLOAT.fieldOf("ambient_light").forGetter(DimensionManager::ambientLight), (App)Codec.intRange((int)MIN_Y, (int)MAX_Y).optionalFieldOf("cloud_height").forGetter(DimensionManager::cloudHeight), (App)a.CODEC.forGetter(DimensionManager::monsterSettings)).apply((Applicative)var0, DimensionManager::new)));
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<DimensionManager>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.DIMENSION_TYPE);
    public static final int MOON_PHASES = 8;
    public static final float[] MOON_BRIGHTNESS_PER_PHASE = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    public static final Codec<Holder<DimensionManager>> CODEC = RegistryFileCodec.create(Registries.DIMENSION_TYPE, DIRECT_CODEC);

    public DimensionManager {
        if (var10 < 16) {
            throw new IllegalStateException("height has to be at least 16");
        }
        if (var9 + var10 > MAX_Y + 1) {
            throw new IllegalStateException("min_y + height cannot be higher than: " + (MAX_Y + 1));
        }
        if (var11 > var10) {
            throw new IllegalStateException("logical_height cannot be higher than height");
        }
        if (var10 % 16 != 0) {
            throw new IllegalStateException("height has to be multiple of 16");
        }
        if (var9 % 16 != 0) {
            throw new IllegalStateException("min_y has to be a multiple of 16");
        }
    }

    public static double getTeleportationScale(DimensionManager var0, DimensionManager var1) {
        double var2 = var0.coordinateScale();
        double var4 = var1.coordinateScale();
        return var2 / var4;
    }

    public static Path getStorageFolder(ResourceKey<World> var0, Path var1) {
        if (var0 == World.OVERWORLD) {
            return var1;
        }
        if (var0 == World.END) {
            return var1.resolve("DIM1");
        }
        if (var0 == World.NETHER) {
            return var1.resolve("DIM-1");
        }
        return var1.resolve("dimensions").resolve(var0.location().getNamespace()).resolve(var0.location().getPath());
    }

    public boolean hasFixedTime() {
        return this.fixedTime.isPresent();
    }

    public float timeOfDay(long var0) {
        double var2 = MathHelper.frac((double)this.fixedTime.orElse(var0) / 24000.0 - 0.25);
        double var4 = 0.5 - Math.cos(var2 * Math.PI) / 2.0;
        return (float)(var2 * 2.0 + var4) / 3.0f;
    }

    public int moonPhase(long var0) {
        return (int)(var0 / 24000L % 8L + 8L) % 8;
    }

    public boolean piglinSafe() {
        return this.monsterSettings.piglinSafe();
    }

    public boolean hasRaids() {
        return this.monsterSettings.hasRaids();
    }

    public IntProvider monsterSpawnLightTest() {
        return this.monsterSettings.monsterSpawnLightTest();
    }

    public int monsterSpawnBlockLightLimit() {
        return this.monsterSettings.monsterSpawnBlockLightLimit();
    }

    public record a(boolean piglinSafe, boolean hasRaids, IntProvider monsterSpawnLightTest, int monsterSpawnBlockLightLimit) {
        public static final MapCodec<a> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.BOOL.fieldOf("piglin_safe").forGetter(a::piglinSafe), (App)Codec.BOOL.fieldOf("has_raids").forGetter(a::hasRaids), (App)IntProvider.codec(0, 15).fieldOf("monster_spawn_light_level").forGetter(a::monsterSpawnLightTest), (App)Codec.intRange((int)0, (int)15).fieldOf("monster_spawn_block_light_limit").forGetter(a::monsterSpawnBlockLightLimit)).apply((Applicative)var0, a::new));
    }
}

