/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossBattle;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBuilder;
import net.minecraft.world.level.block.state.predicate.BlockPredicate;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.levelgen.feature.WorldGenEnder;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.phys.AxisAlignedBB;
import org.slf4j.Logger;

public class EnderDragonBattle {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TICKS_BEFORE_DRAGON_RESPAWN = 1200;
    private static final int TIME_BETWEEN_CRYSTAL_SCANS = 100;
    public static final int TIME_BETWEEN_PLAYER_SCANS = 20;
    private static final int ARENA_SIZE_CHUNKS = 8;
    public static final int ARENA_TICKET_LEVEL = 9;
    private static final int GATEWAY_COUNT = 20;
    private static final int GATEWAY_DISTANCE = 96;
    public static final int DRAGON_SPAWN_Y = 128;
    private final Predicate<Entity> validPlayer;
    public final BossBattleServer dragonEvent = (BossBattleServer)new BossBattleServer(IChatBaseComponent.translatable("entity.minecraft.ender_dragon"), BossBattle.BarColor.PINK, BossBattle.BarStyle.PROGRESS).setPlayBossMusic(true).setCreateWorldFog(true);
    public final WorldServer level;
    private final BlockPosition origin;
    private final ObjectArrayList<Integer> gateways = new ObjectArrayList();
    private final ShapeDetector exitPortalPattern;
    private int ticksSinceDragonSeen;
    private int crystalsAlive;
    private int ticksSinceCrystalsScanned;
    private int ticksSinceLastPlayerScan = 21;
    private boolean dragonKilled;
    public boolean previouslyKilled;
    private boolean skipArenaLoadedCheck = false;
    @Nullable
    public UUID dragonUUID;
    private boolean needsStateScanning = true;
    @Nullable
    public BlockPosition portalLocation;
    @Nullable
    public EnumDragonRespawn respawnStage;
    private int respawnTime;
    @Nullable
    private List<EntityEnderCrystal> respawnCrystals;

    public EnderDragonBattle(WorldServer var0, long var1, a var3) {
        this(var0, var1, var3, BlockPosition.ZERO);
    }

    public EnderDragonBattle(WorldServer var0, long var1, a var3, BlockPosition var4) {
        this.level = var0;
        this.origin = var4;
        this.validPlayer = IEntitySelector.ENTITY_STILL_ALIVE.and(IEntitySelector.withinDistance(var4.getX(), 128 + var4.getY(), var4.getZ(), 192.0));
        this.needsStateScanning = var3.needsStateScanning;
        this.dragonUUID = var3.dragonUUID.orElse(null);
        this.dragonKilled = var3.dragonKilled;
        this.previouslyKilled = var3.previouslyKilled;
        if (var3.isRespawning) {
            this.respawnStage = EnumDragonRespawn.START;
        }
        this.portalLocation = var3.exitPortalLocation.orElse(null);
        this.gateways.addAll((Collection)var3.gateways.orElseGet(() -> {
            ObjectArrayList var2 = new ObjectArrayList((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            SystemUtils.shuffle(var2, RandomSource.create(var1));
            return var2;
        }));
        this.exitPortalPattern = ShapeDetectorBuilder.start().aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  ").aisle("       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       ").where('#', ShapeDetectorBlock.hasState(BlockPredicate.forBlock(Blocks.BEDROCK))).build();
    }

    @Deprecated
    @VisibleForTesting
    public void skipArenaLoadedCheck() {
        this.skipArenaLoadedCheck = true;
    }

    public a saveData() {
        return new a(this.needsStateScanning, this.dragonKilled, this.previouslyKilled, false, Optional.ofNullable(this.dragonUUID), Optional.ofNullable(this.portalLocation), Optional.of(this.gateways));
    }

    public void tick() {
        this.dragonEvent.setVisible(!this.dragonKilled);
        if (++this.ticksSinceLastPlayerScan >= 20) {
            this.updatePlayers();
            this.ticksSinceLastPlayerScan = 0;
        }
        if (!this.dragonEvent.getPlayers().isEmpty()) {
            this.level.getChunkSource().addTicketWithRadius(TicketType.DRAGON, new ChunkCoordIntPair(0, 0), 9);
            boolean var0 = this.isArenaLoaded();
            if (this.needsStateScanning && var0) {
                this.scanState();
                this.needsStateScanning = false;
            }
            if (this.respawnStage != null) {
                if (this.respawnCrystals == null && var0) {
                    this.respawnStage = null;
                    this.tryRespawn();
                }
                this.respawnStage.tick(this.level, this, this.respawnCrystals, this.respawnTime++, this.portalLocation);
            }
            if (!this.dragonKilled) {
                if ((this.dragonUUID == null || ++this.ticksSinceDragonSeen >= 1200) && var0) {
                    this.findOrCreateDragon();
                    this.ticksSinceDragonSeen = 0;
                }
                if (++this.ticksSinceCrystalsScanned >= 100 && var0) {
                    this.updateCrystalCount();
                    this.ticksSinceCrystalsScanned = 0;
                }
            }
        } else {
            this.level.getChunkSource().removeTicketWithRadius(TicketType.DRAGON, new ChunkCoordIntPair(0, 0), 9);
        }
    }

    private void scanState() {
        LOGGER.info("Scanning for legacy world dragon fight...");
        boolean var0 = this.hasActiveExitPortal();
        if (var0) {
            LOGGER.info("Found that the dragon has been killed in this world already.");
            this.previouslyKilled = true;
        } else {
            LOGGER.info("Found that the dragon has not yet been killed in this world.");
            this.previouslyKilled = false;
            if (this.findExitPortal() == null) {
                this.spawnExitPortal(false);
            }
        }
        List<? extends EntityEnderDragon> var1 = this.level.getDragons();
        if (var1.isEmpty()) {
            this.dragonKilled = true;
        } else {
            EntityEnderDragon var2 = var1.get(0);
            this.dragonUUID = var2.getUUID();
            LOGGER.info("Found that there's a dragon still alive ({})", (Object)var2);
            this.dragonKilled = false;
            if (!var0) {
                LOGGER.info("But we didn't have a portal, let's remove it.");
                var2.discard();
                this.dragonUUID = null;
            }
        }
        if (!this.previouslyKilled && this.dragonKilled) {
            this.dragonKilled = false;
        }
    }

    private void findOrCreateDragon() {
        List<? extends EntityEnderDragon> var0 = this.level.getDragons();
        if (var0.isEmpty()) {
            LOGGER.debug("Haven't seen the dragon, respawning it");
            this.createNewDragon();
        } else {
            LOGGER.debug("Haven't seen our dragon, but found another one to use.");
            this.dragonUUID = var0.get(0).getUUID();
        }
    }

    public void setRespawnStage(EnumDragonRespawn var0) {
        if (this.respawnStage == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.respawnTime = 0;
        if (var0 == EnumDragonRespawn.END) {
            this.respawnStage = null;
            this.dragonKilled = false;
            EntityEnderDragon var1 = this.createNewDragon();
            if (var1 != null) {
                for (EntityPlayer var3 : this.dragonEvent.getPlayers()) {
                    CriterionTriggers.SUMMONED_ENTITY.trigger(var3, var1);
                }
            }
        } else {
            this.respawnStage = var0;
        }
    }

    private boolean hasActiveExitPortal() {
        for (int var0 = -8; var0 <= 8; ++var0) {
            for (int var1 = -8; var1 <= 8; ++var1) {
                Chunk var2 = this.level.getChunk(var0, var1);
                for (TileEntity var4 : var2.getBlockEntities().values()) {
                    if (!(var4 instanceof TileEntityEnderPortal)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public ShapeDetector.ShapeDetectorCollection findExitPortal() {
        int var2;
        ChunkCoordIntPair var0 = new ChunkCoordIntPair(this.origin);
        for (int var1 = -8 + var0.x; var1 <= 8 + var0.x; ++var1) {
            for (var2 = -8 + var0.z; var2 <= 8 + var0.z; ++var2) {
                Chunk var3 = this.level.getChunk(var1, var2);
                for (TileEntity var5 : var3.getBlockEntities().values()) {
                    ShapeDetector.ShapeDetectorCollection var6;
                    if (!(var5 instanceof TileEntityEnderPortal) || (var6 = this.exitPortalPattern.find(this.level, var5.getBlockPos())) == null) continue;
                    BlockPosition var7 = var6.getBlock(3, 3, 3).getPos();
                    if (this.portalLocation == null) {
                        this.portalLocation = var7;
                    }
                    return var6;
                }
            }
        }
        BlockPosition var1 = WorldGenEndTrophy.getLocation(this.origin);
        for (int var3 = var2 = this.level.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, var1).getY(); var3 >= this.level.getMinY(); --var3) {
            ShapeDetector.ShapeDetectorCollection var4 = this.exitPortalPattern.find(this.level, new BlockPosition(var1.getX(), var3, var1.getZ()));
            if (var4 == null) continue;
            if (this.portalLocation == null) {
                this.portalLocation = var4.getBlock(3, 3, 3).getPos();
            }
            return var4;
        }
        return null;
    }

    private boolean isArenaLoaded() {
        if (this.skipArenaLoadedCheck) {
            return true;
        }
        ChunkCoordIntPair var0 = new ChunkCoordIntPair(this.origin);
        for (int var1 = -8 + var0.x; var1 <= 8 + var0.x; ++var1) {
            for (int var2 = 8 + var0.z; var2 <= 8 + var0.z; ++var2) {
                IChunkAccess var3 = this.level.getChunk(var1, var2, ChunkStatus.FULL, false);
                if (!(var3 instanceof Chunk)) {
                    return false;
                }
                FullChunkStatus var4 = ((Chunk)var3).getFullStatus();
                if (var4.isOrAfter(FullChunkStatus.BLOCK_TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    private void updatePlayers() {
        HashSet var0 = Sets.newHashSet();
        for (EntityPlayer var2 : this.level.getPlayers(this.validPlayer)) {
            this.dragonEvent.addPlayer(var2);
            var0.add(var2);
        }
        HashSet var1 = Sets.newHashSet(this.dragonEvent.getPlayers());
        var1.removeAll(var0);
        for (EntityPlayer var3 : var1) {
            this.dragonEvent.removePlayer(var3);
        }
    }

    private void updateCrystalCount() {
        this.ticksSinceCrystalsScanned = 0;
        this.crystalsAlive = 0;
        for (WorldGenEnder.Spike var1 : WorldGenEnder.getSpikesForLevel(this.level)) {
            this.crystalsAlive += this.level.getEntitiesOfClass(EntityEnderCrystal.class, var1.getTopBoundingBox()).size();
        }
        LOGGER.debug("Found {} end crystals still alive", (Object)this.crystalsAlive);
    }

    public void setDragonKilled(EntityEnderDragon var0) {
        if (var0.getUUID().equals(this.dragonUUID)) {
            this.dragonEvent.setProgress(0.0f);
            this.dragonEvent.setVisible(false);
            this.spawnExitPortal(true);
            this.spawnNewGateway();
            if (!this.previouslyKilled) {
                this.level.setBlockAndUpdate(this.level.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, WorldGenEndTrophy.getLocation(this.origin)), Blocks.DRAGON_EGG.defaultBlockState());
            }
            this.previouslyKilled = true;
            this.dragonKilled = true;
        }
    }

    @Deprecated
    @VisibleForTesting
    public void removeAllGateways() {
        this.gateways.clear();
    }

    private void spawnNewGateway() {
        if (this.gateways.isEmpty()) {
            return;
        }
        int var0 = (Integer)this.gateways.remove(this.gateways.size() - 1);
        int var1 = MathHelper.floor(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)var0)));
        int var2 = MathHelper.floor(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)var0)));
        this.spawnNewGateway(new BlockPosition(var1, 75, var2));
    }

    private void spawnNewGateway(BlockPosition var02) {
        this.level.levelEvent(3000, var02, 0);
        this.level.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(var0 -> var0.get(EndFeatures.END_GATEWAY_DELAYED)).ifPresent(var1 -> ((WorldGenFeatureConfigured)var1.value()).place(this.level, this.level.getChunkSource().getGenerator(), RandomSource.create(), var02));
    }

    public void spawnExitPortal(boolean var0) {
        WorldGenEndTrophy var1 = new WorldGenEndTrophy(var0);
        if (this.portalLocation == null) {
            this.portalLocation = this.level.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, WorldGenEndTrophy.getLocation(this.origin)).below();
            while (this.level.getBlockState(this.portalLocation).is(Blocks.BEDROCK) && this.portalLocation.getY() > 63) {
                this.portalLocation = this.portalLocation.below();
            }
            this.portalLocation = this.portalLocation.atY(Math.max(this.level.getMinY() + 1, this.portalLocation.getY()));
        }
        if (var1.place(WorldGenFeatureConfiguration.NONE, this.level, this.level.getChunkSource().getGenerator(), RandomSource.create(), this.portalLocation)) {
            int var2 = MathHelper.positiveCeilDiv(4, 16);
            this.level.getChunkSource().chunkMap.waitForLightBeforeSending(new ChunkCoordIntPair(this.portalLocation), var2);
        }
    }

    @Nullable
    private EntityEnderDragon createNewDragon() {
        this.level.getChunkAt(new BlockPosition(this.origin.getX(), 128 + this.origin.getY(), this.origin.getZ()));
        EntityEnderDragon var0 = EntityTypes.ENDER_DRAGON.create(this.level, EntitySpawnReason.EVENT);
        if (var0 != null) {
            var0.setDragonFight(this);
            var0.setFightOrigin(this.origin);
            var0.getPhaseManager().setPhase(DragonControllerPhase.HOLDING_PATTERN);
            var0.snapTo(this.origin.getX(), 128 + this.origin.getY(), this.origin.getZ(), this.level.random.nextFloat() * 360.0f, 0.0f);
            this.level.addFreshEntity(var0);
            this.dragonUUID = var0.getUUID();
        }
        return var0;
    }

    public void updateDragon(EntityEnderDragon var0) {
        if (var0.getUUID().equals(this.dragonUUID)) {
            this.dragonEvent.setProgress(var0.getHealth() / var0.getMaxHealth());
            this.ticksSinceDragonSeen = 0;
            if (var0.hasCustomName()) {
                this.dragonEvent.setName(var0.getDisplayName());
            }
        }
    }

    public int getCrystalsAlive() {
        return this.crystalsAlive;
    }

    public void onCrystalDestroyed(EntityEnderCrystal var0, DamageSource var1) {
        if (this.respawnStage != null && this.respawnCrystals.contains(var0)) {
            LOGGER.debug("Aborting respawn sequence");
            this.respawnStage = null;
            this.respawnTime = 0;
            this.resetSpikeCrystals();
            this.spawnExitPortal(true);
        } else {
            this.updateCrystalCount();
            Entity var2 = this.level.getEntity(this.dragonUUID);
            if (var2 instanceof EntityEnderDragon) {
                EntityEnderDragon var3 = (EntityEnderDragon)var2;
                var3.onCrystalDestroyed(this.level, var0, var0.blockPosition(), var1);
            }
        }
    }

    public boolean hasPreviouslyKilledDragon() {
        return this.previouslyKilled;
    }

    public void tryRespawn() {
        if (this.dragonKilled && this.respawnStage == null) {
            Object var1;
            BlockPosition var0 = this.portalLocation;
            if (var0 == null) {
                LOGGER.debug("Tried to respawn, but need to find the portal first.");
                var1 = this.findExitPortal();
                if (var1 == null) {
                    LOGGER.debug("Couldn't find a portal, so we made one.");
                    this.spawnExitPortal(true);
                } else {
                    LOGGER.debug("Found the exit portal & saved its location for next time.");
                }
                var0 = this.portalLocation;
            }
            var1 = Lists.newArrayList();
            BlockPosition var2 = var0.above(1);
            for (EnumDirection var4 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                List<EntityEnderCrystal> var5 = this.level.getEntitiesOfClass(EntityEnderCrystal.class, new AxisAlignedBB(var2.relative(var4, 2)));
                if (var5.isEmpty()) {
                    return;
                }
                var1.addAll(var5);
            }
            LOGGER.debug("Found all crystals, respawning dragon.");
            this.respawnDragon((List<EntityEnderCrystal>)var1);
        }
    }

    public void respawnDragon(List<EntityEnderCrystal> var0) {
        if (this.dragonKilled && this.respawnStage == null) {
            ShapeDetector.ShapeDetectorCollection var1 = this.findExitPortal();
            while (var1 != null) {
                for (int var2 = 0; var2 < this.exitPortalPattern.getWidth(); ++var2) {
                    for (int var3 = 0; var3 < this.exitPortalPattern.getHeight(); ++var3) {
                        for (int var4 = 0; var4 < this.exitPortalPattern.getDepth(); ++var4) {
                            ShapeDetectorBlock var5 = var1.getBlock(var2, var3, var4);
                            if (!var5.getState().is(Blocks.BEDROCK) && !var5.getState().is(Blocks.END_PORTAL)) continue;
                            this.level.setBlockAndUpdate(var5.getPos(), Blocks.END_STONE.defaultBlockState());
                        }
                    }
                }
                var1 = this.findExitPortal();
            }
            this.respawnStage = EnumDragonRespawn.START;
            this.respawnTime = 0;
            this.spawnExitPortal(false);
            this.respawnCrystals = var0;
        }
    }

    public void resetSpikeCrystals() {
        for (WorldGenEnder.Spike var1 : WorldGenEnder.getSpikesForLevel(this.level)) {
            List<EntityEnderCrystal> var2 = this.level.getEntitiesOfClass(EntityEnderCrystal.class, var1.getTopBoundingBox());
            for (EntityEnderCrystal var4 : var2) {
                var4.setInvulnerable(false);
                var4.setBeamTarget(null);
            }
        }
    }

    @Nullable
    public UUID getDragonUUID() {
        return this.dragonUUID;
    }

    public static final class a
    extends Record {
        final boolean needsStateScanning;
        final boolean dragonKilled;
        final boolean previouslyKilled;
        final boolean isRespawning;
        final Optional<UUID> dragonUUID;
        final Optional<BlockPosition> exitPortalLocation;
        final Optional<List<Integer>> gateways;
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.BOOL.fieldOf("NeedsStateScanning").orElse((Object)true).forGetter(a::needsStateScanning), (App)Codec.BOOL.fieldOf("DragonKilled").orElse((Object)false).forGetter(a::dragonKilled), (App)Codec.BOOL.fieldOf("PreviouslyKilled").orElse((Object)false).forGetter(a::previouslyKilled), (App)Codec.BOOL.lenientOptionalFieldOf("IsRespawning", (Object)false).forGetter(a::isRespawning), (App)UUIDUtil.CODEC.lenientOptionalFieldOf("Dragon").forGetter(a::dragonUUID), (App)BlockPosition.CODEC.lenientOptionalFieldOf("ExitPortalLocation").forGetter(a::exitPortalLocation), (App)Codec.list((Codec)Codec.INT).lenientOptionalFieldOf("Gateways").forGetter(a::gateways)).apply((Applicative)var0, a::new));
        public static final a DEFAULT = new a(true, false, false, false, Optional.empty(), Optional.empty(), Optional.empty());

        public a(boolean var0, boolean var1, boolean var2, boolean var3, Optional<UUID> var4, Optional<BlockPosition> var5, Optional<List<Integer>> var6) {
            this.needsStateScanning = var0;
            this.dragonKilled = var1;
            this.previouslyKilled = var2;
            this.isRespawning = var3;
            this.dragonUUID = var4;
            this.exitPortalLocation = var5;
            this.gateways = var6;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "needsStateScanning;dragonKilled;previouslyKilled;isRespawning;dragonUUID;exitPortalLocation;gateways", "needsStateScanning", "dragonKilled", "previouslyKilled", "isRespawning", "dragonUUID", "exitPortalLocation", "gateways"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "needsStateScanning;dragonKilled;previouslyKilled;isRespawning;dragonUUID;exitPortalLocation;gateways", "needsStateScanning", "dragonKilled", "previouslyKilled", "isRespawning", "dragonUUID", "exitPortalLocation", "gateways"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "needsStateScanning;dragonKilled;previouslyKilled;isRespawning;dragonUUID;exitPortalLocation;gateways", "needsStateScanning", "dragonKilled", "previouslyKilled", "isRespawning", "dragonUUID", "exitPortalLocation", "gateways"}, this, var0);
        }

        public boolean needsStateScanning() {
            return this.needsStateScanning;
        }

        public boolean dragonKilled() {
            return this.dragonKilled;
        }

        public boolean previouslyKilled() {
            return this.previouslyKilled;
        }

        public boolean isRespawning() {
            return this.isRespawning;
        }

        public Optional<UUID> dragonUUID() {
            return this.dragonUUID;
        }

        public Optional<BlockPosition> exitPortalLocation() {
            return this.exitPortalLocation;
        }

        public Optional<List<Integer>> gateways() {
            return this.gateways;
        }
    }
}

