/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;

public class WorldGenFeatureBasaltPillar
extends WorldGenerator<WorldGenFeatureEmptyConfiguration> {
    public WorldGenFeatureBasaltPillar(Codec<WorldGenFeatureEmptyConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureEmptyConfiguration> var0) {
        BlockPosition var1 = var0.origin();
        GeneratorAccessSeed var2 = var0.level();
        RandomSource var3 = var0.random();
        if (!var2.isEmptyBlock(var1) || var2.isEmptyBlock(var1.above())) {
            return false;
        }
        BlockPosition.MutableBlockPosition var4 = var1.mutable();
        BlockPosition.MutableBlockPosition var5 = var1.mutable();
        boolean var6 = true;
        boolean var7 = true;
        boolean var8 = true;
        boolean var9 = true;
        while (var2.isEmptyBlock(var4)) {
            if (var2.isOutsideBuildHeight(var4)) {
                return true;
            }
            var2.setBlock(var4, Blocks.BASALT.defaultBlockState(), 2);
            var6 = var6 && this.placeHangOff(var2, var3, var5.setWithOffset((BaseBlockPosition)var4, EnumDirection.NORTH));
            var7 = var7 && this.placeHangOff(var2, var3, var5.setWithOffset((BaseBlockPosition)var4, EnumDirection.SOUTH));
            var8 = var8 && this.placeHangOff(var2, var3, var5.setWithOffset((BaseBlockPosition)var4, EnumDirection.WEST));
            var9 = var9 && this.placeHangOff(var2, var3, var5.setWithOffset((BaseBlockPosition)var4, EnumDirection.EAST));
            var4.move(EnumDirection.DOWN);
        }
        var4.move(EnumDirection.UP);
        this.placeBaseHangOff(var2, var3, var5.setWithOffset((BaseBlockPosition)var4, EnumDirection.NORTH));
        this.placeBaseHangOff(var2, var3, var5.setWithOffset((BaseBlockPosition)var4, EnumDirection.SOUTH));
        this.placeBaseHangOff(var2, var3, var5.setWithOffset((BaseBlockPosition)var4, EnumDirection.WEST));
        this.placeBaseHangOff(var2, var3, var5.setWithOffset((BaseBlockPosition)var4, EnumDirection.EAST));
        var4.move(EnumDirection.DOWN);
        BlockPosition.MutableBlockPosition var10 = new BlockPosition.MutableBlockPosition();
        for (int var11 = -3; var11 < 4; ++var11) {
            for (int var12 = -3; var12 < 4; ++var12) {
                int var13 = MathHelper.abs(var11) * MathHelper.abs(var12);
                if (var3.nextInt(10) >= 10 - var13) continue;
                var10.set(var4.offset(var11, 0, var12));
                int var14 = 3;
                while (var2.isEmptyBlock(var5.setWithOffset((BaseBlockPosition)var10, EnumDirection.DOWN))) {
                    var10.move(EnumDirection.DOWN);
                    if (--var14 > 0) continue;
                }
                if (var2.isEmptyBlock(var5.setWithOffset((BaseBlockPosition)var10, EnumDirection.DOWN))) continue;
                var2.setBlock(var10, Blocks.BASALT.defaultBlockState(), 2);
            }
        }
        return true;
    }

    private void placeBaseHangOff(GeneratorAccess var0, RandomSource var1, BlockPosition var2) {
        if (var1.nextBoolean()) {
            var0.setBlock(var2, Blocks.BASALT.defaultBlockState(), 2);
        }
    }

    private boolean placeHangOff(GeneratorAccess var0, RandomSource var1, BlockPosition var2) {
        if (var1.nextInt(10) != 0) {
            var0.setBlock(var2, Blocks.BASALT.defaultBlockState(), 2);
            return true;
        }
        return false;
    }
}

