/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBlockConfiguration;

public class WorldGenFeatureBlock
extends WorldGenerator<WorldGenFeatureBlockConfiguration> {
    public WorldGenFeatureBlock(Codec<WorldGenFeatureBlockConfiguration> var0) {
        super(var0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureBlockConfiguration> var0) {
        WorldGenFeatureBlockConfiguration var1 = var0.config();
        GeneratorAccessSeed var2 = var0.level();
        BlockPosition var3 = var0.origin();
        IBlockData var4 = var1.toPlace().getState(var0.random(), var3);
        if (!var4.canSurvive(var2, var3)) return false;
        if (var4.getBlock() instanceof BlockTallPlant) {
            if (!var2.isEmptyBlock(var3.above())) return false;
            BlockTallPlant.placeAt(var2, var4, var3, 2);
        } else if (var4.getBlock() instanceof MossyCarpetBlock) {
            MossyCarpetBlock.placeAt(var2, var3, var2.getRandom(), 2);
        } else {
            var2.setBlock(var3, var4, 2);
        }
        if (!var1.scheduleTick()) return true;
        var2.scheduleTick(var3, var2.getBlockState(var3).getBlock(), 1);
        return true;
    }
}

