/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.stateproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviders;

public class RandomizedIntStateProvider
extends WorldGenFeatureStateProvider {
    public static final MapCodec<RandomizedIntStateProvider> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)WorldGenFeatureStateProvider.CODEC.fieldOf("source").forGetter(var0 -> var0.source), (App)Codec.STRING.fieldOf("property").forGetter(var0 -> var0.propertyName), (App)IntProvider.CODEC.fieldOf("values").forGetter(var0 -> var0.values)).apply((Applicative)var02, RandomizedIntStateProvider::new));
    private final WorldGenFeatureStateProvider source;
    private final String propertyName;
    @Nullable
    private BlockStateInteger property;
    private final IntProvider values;

    public RandomizedIntStateProvider(WorldGenFeatureStateProvider var0, BlockStateInteger var1, IntProvider var2) {
        this.source = var0;
        this.property = var1;
        this.propertyName = var1.getName();
        this.values = var2;
        List<Integer> var3 = var1.getPossibleValues();
        for (int var4 = var2.getMinValue(); var4 <= var2.getMaxValue(); ++var4) {
            if (var3.contains(var4)) continue;
            throw new IllegalArgumentException("Property value out of range: " + var1.getName() + ": " + var4);
        }
    }

    public RandomizedIntStateProvider(WorldGenFeatureStateProvider var0, String var1, IntProvider var2) {
        this.source = var0;
        this.propertyName = var1;
        this.values = var2;
    }

    @Override
    protected WorldGenFeatureStateProviders<?> type() {
        return WorldGenFeatureStateProviders.RANDOMIZED_INT_STATE_PROVIDER;
    }

    @Override
    public IBlockData getState(RandomSource var0, BlockPosition var1) {
        IBlockData var2 = this.source.getState(var0, var1);
        if (this.property == null || !var2.hasProperty(this.property)) {
            BlockStateInteger var3 = RandomizedIntStateProvider.findProperty(var2, this.propertyName);
            if (var3 == null) {
                return var2;
            }
            this.property = var3;
        }
        return (IBlockData)var2.setValue(this.property, this.values.sample(var0));
    }

    @Nullable
    private static BlockStateInteger findProperty(IBlockData var02, String var12) {
        Collection<IBlockState<?>> var2 = var02.getProperties();
        Optional<BlockStateInteger> var3 = var2.stream().filter(var1 -> var1.getName().equals(var12)).filter(var0 -> var0 instanceof BlockStateInteger).map(var0 -> (BlockStateInteger)var0).findAny();
        return var3.orElse(null);
    }
}

