/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.TrapezoidHeight;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class HeightRangePlacement
extends PlacementModifier {
    public static final MapCodec<HeightRangePlacement> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)HeightProvider.CODEC.fieldOf("height").forGetter(var0 -> var0.height)).apply((Applicative)var02, HeightRangePlacement::new));
    private final HeightProvider height;

    private HeightRangePlacement(HeightProvider var0) {
        this.height = var0;
    }

    public static HeightRangePlacement of(HeightProvider var0) {
        return new HeightRangePlacement(var0);
    }

    public static HeightRangePlacement uniform(VerticalAnchor var0, VerticalAnchor var1) {
        return HeightRangePlacement.of(UniformHeight.of(var0, var1));
    }

    public static HeightRangePlacement triangle(VerticalAnchor var0, VerticalAnchor var1) {
        return HeightRangePlacement.of(TrapezoidHeight.of(var0, var1));
    }

    @Override
    public Stream<BlockPosition> getPositions(PlacementContext var0, RandomSource var1, BlockPosition var2) {
        return Stream.of(var2.atY(this.height.sample(var1, var0)));
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.HEIGHT_RANGE;
    }
}

