/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Comparator;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.HeightMap;

public class PortalTravelAgent {
    public static final int TICKET_RADIUS = 3;
    private static final int NETHER_PORTAL_RADIUS = 16;
    private static final int OVERWORLD_PORTAL_RADIUS = 128;
    private static final int FRAME_HEIGHT = 5;
    private static final int FRAME_WIDTH = 4;
    private static final int FRAME_BOX = 3;
    private static final int FRAME_HEIGHT_START = -1;
    private static final int FRAME_HEIGHT_END = 4;
    private static final int FRAME_WIDTH_START = -1;
    private static final int FRAME_WIDTH_END = 3;
    private static final int FRAME_BOX_START = -1;
    private static final int FRAME_BOX_END = 2;
    private static final int NOTHING_FOUND = -1;
    private final WorldServer level;

    public PortalTravelAgent(WorldServer var0) {
        this.level = var0;
    }

    public Optional<BlockPosition> findClosestPortalPosition(BlockPosition var02, boolean var12, WorldBorder var2) {
        VillagePlace var3 = this.level.getPoiManager();
        int var4 = var12 ? 16 : 128;
        var3.ensureLoadedAndValid(this.level, var02, var4);
        return var3.getInSquare(var0 -> var0.is(PoiTypes.NETHER_PORTAL), var02, var4, VillagePlace.Occupancy.ANY).map(VillagePlaceRecord::getPos).filter(var2::isWithinBounds).filter(var0 -> this.level.getBlockState((BlockPosition)var0).hasProperty(BlockProperties.HORIZONTAL_AXIS)).min(Comparator.comparingDouble(var1 -> var1.distSqr(var02)).thenComparingInt(BaseBlockPosition::getY));
    }

    public Optional<BlockUtil.Rectangle> createPortal(BlockPosition var0, EnumDirection.EnumAxis var1) {
        int var18;
        int var17;
        int var16;
        EnumDirection var2 = EnumDirection.get(EnumDirection.EnumAxisDirection.POSITIVE, var1);
        double var3 = -1.0;
        BlockPosition var5 = null;
        double var6 = -1.0;
        BlockPosition var8 = null;
        WorldBorder var9 = this.level.getWorldBorder();
        int var10 = Math.min(this.level.getMaxY(), this.level.getMinY() + this.level.getLogicalHeight() - 1);
        boolean var11 = true;
        BlockPosition.MutableBlockPosition var12 = var0.mutable();
        for (BlockPosition.MutableBlockPosition var14 : BlockPosition.spiralAround(var0, 16, EnumDirection.EAST, EnumDirection.SOUTH)) {
            int var15 = Math.min(var10, this.level.getHeight(HeightMap.Type.MOTION_BLOCKING, var14.getX(), var14.getZ()));
            if (!var9.isWithinBounds(var14) || !var9.isWithinBounds(var14.move(var2, 1))) continue;
            var14.move(var2.getOpposite(), 1);
            for (var16 = var15; var16 >= this.level.getMinY(); --var16) {
                var14.setY(var16);
                if (!this.canPortalReplaceBlock(var14)) continue;
                var17 = var16;
                while (var16 > this.level.getMinY() && this.canPortalReplaceBlock(var14.move(EnumDirection.DOWN))) {
                    --var16;
                }
                if (var16 + 4 > var10 || (var18 = var17 - var16) > 0 && var18 < 3) continue;
                var14.setY(var16);
                if (!this.canHostFrame(var14, var12, var2, 0)) continue;
                double var19 = var0.distSqr(var14);
                if (this.canHostFrame(var14, var12, var2, -1) && this.canHostFrame(var14, var12, var2, 1) && (var3 == -1.0 || var3 > var19)) {
                    var3 = var19;
                    var5 = var14.immutable();
                }
                if (var3 != -1.0 || var6 != -1.0 && !(var6 > var19)) continue;
                var6 = var19;
                var8 = var14.immutable();
            }
        }
        if (var3 == -1.0 && var6 != -1.0) {
            var5 = var8;
            var3 = var6;
        }
        if (var3 == -1.0) {
            int var14 = var10 - 9;
            int var13 = Math.max(this.level.getMinY() - -1, 70);
            if (var14 < var13) {
                return Optional.empty();
            }
            var5 = new BlockPosition(var0.getX() - var2.getStepX() * 1, MathHelper.clamp(var0.getY(), var13, var14), var0.getZ() - var2.getStepZ() * 1).immutable();
            var5 = var9.clampToBounds(var5);
            EnumDirection var15 = var2.getClockWise();
            for (var16 = -1; var16 < 2; ++var16) {
                for (var17 = 0; var17 < 2; ++var17) {
                    for (var18 = -1; var18 < 3; ++var18) {
                        IBlockData var19 = var18 < 0 ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.AIR.defaultBlockState();
                        var12.setWithOffset(var5, var17 * var2.getStepX() + var16 * var15.getStepX(), var18, var17 * var2.getStepZ() + var16 * var15.getStepZ());
                        this.level.setBlockAndUpdate(var12, var19);
                    }
                }
            }
        }
        for (int var13 = -1; var13 < 3; ++var13) {
            for (int var14 = -1; var14 < 4; ++var14) {
                if (var13 != -1 && var13 != 2 && var14 != -1 && var14 != 3) continue;
                var12.setWithOffset(var5, var13 * var2.getStepX(), var14, var13 * var2.getStepZ());
                this.level.setBlock(var12, Blocks.OBSIDIAN.defaultBlockState(), 3);
            }
        }
        IBlockData var13 = (IBlockData)Blocks.NETHER_PORTAL.defaultBlockState().setValue(BlockPortal.AXIS, var1);
        for (int var14 = 0; var14 < 2; ++var14) {
            for (int var15 = 0; var15 < 3; ++var15) {
                var12.setWithOffset(var5, var14 * var2.getStepX(), var15, var14 * var2.getStepZ());
                this.level.setBlock(var12, var13, 18);
            }
        }
        return Optional.of(new BlockUtil.Rectangle(var5.immutable(), 2, 3));
    }

    private boolean canPortalReplaceBlock(BlockPosition.MutableBlockPosition var0) {
        IBlockData var1 = this.level.getBlockState(var0);
        return var1.canBeReplaced() && var1.getFluidState().isEmpty();
    }

    private boolean canHostFrame(BlockPosition var0, BlockPosition.MutableBlockPosition var1, EnumDirection var2, int var3) {
        EnumDirection var4 = var2.getClockWise();
        for (int var5 = -1; var5 < 3; ++var5) {
            for (int var6 = -1; var6 < 4; ++var6) {
                var1.setWithOffset(var0, var2.getStepX() * var5 + var4.getStepX() * var3, var6, var2.getStepZ() * var5 + var4.getStepZ() * var3);
                if (var6 < 0 && !this.level.getBlockState(var1).isSolid()) {
                    return false;
                }
                if (var6 < 0 || this.canPortalReplaceBlock(var1)) continue;
                return false;
            }
        }
        return true;
    }
}

