/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;

public class DefaultRedstoneWireEvaluator
extends RedstoneWireEvaluator {
    public DefaultRedstoneWireEvaluator(BlockRedstoneWire var0) {
        super(var0);
    }

    @Override
    public void updatePowerStrength(World var0, BlockPosition var1, IBlockData var2, @Nullable Orientation var3, boolean var4) {
        int var5 = this.calculateTargetStrength(var0, var1);
        if (var2.getValue(BlockRedstoneWire.POWER) != var5) {
            if (var0.getBlockState(var1) == var2) {
                var0.setBlock(var1, (IBlockData)var2.setValue(BlockRedstoneWire.POWER, var5), 2);
            }
            HashSet var6 = Sets.newHashSet();
            var6.add(var1);
            for (EnumDirection var10 : EnumDirection.values()) {
                var6.add(var1.relative(var10));
            }
            for (BlockPosition var8 : var6) {
                var0.updateNeighborsAt(var8, this.wireBlock);
            }
        }
    }

    private int calculateTargetStrength(World var0, BlockPosition var1) {
        int var2 = this.getBlockSignal(var0, var1);
        if (var2 == 15) {
            return var2;
        }
        return Math.max(var2, this.getIncomingWireSignal(var0, var1));
    }
}

