/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import net.minecraft.SharedConstants;
import net.minecraft.world.level.storage.DataVersion;

public class LevelVersion {
    private final int levelDataVersion;
    private final long lastPlayed;
    private final String minecraftVersionName;
    private final DataVersion minecraftVersion;
    private final boolean snapshot;

    private LevelVersion(int var0, long var1, String var3, int var4, String var5, boolean var6) {
        this.levelDataVersion = var0;
        this.lastPlayed = var1;
        this.minecraftVersionName = var3;
        this.minecraftVersion = new DataVersion(var4, var5);
        this.snapshot = var6;
    }

    public static LevelVersion parse(Dynamic<?> var0) {
        int var1 = var0.get("version").asInt(0);
        long var2 = var0.get("LastPlayed").asLong(0L);
        OptionalDynamic var4 = var0.get("Version");
        if (var4.result().isPresent()) {
            return new LevelVersion(var1, var2, var4.get("Name").asString(SharedConstants.getCurrentVersion().name()), var4.get("Id").asInt(SharedConstants.getCurrentVersion().dataVersion().version()), var4.get("Series").asString("main"), var4.get("Snapshot").asBoolean(!SharedConstants.getCurrentVersion().stable()));
        }
        return new LevelVersion(var1, var2, "", 0, "main", false);
    }

    public int levelDataVersion() {
        return this.levelDataVersion;
    }

    public long lastPlayed() {
        return this.lastPlayed;
    }

    public String minecraftVersionName() {
        return this.minecraftVersionName;
    }

    public DataVersion minecraftVersion() {
        return this.minecraftVersion;
    }

    public boolean snapshot() {
        return this.snapshot;
    }
}

