/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public class WorldNBTStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File playerDir;
    protected final DataFixer fixerUpper;
    private static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();

    public WorldNBTStorage(Convertable.ConversionSession var0, DataFixer var1) {
        this.fixerUpper = var1;
        this.playerDir = var0.getLevelPath(SavedFile.PLAYER_DATA_DIR).toFile();
        this.playerDir.mkdirs();
    }

    public void save(EntityHuman var0) {
        try (ProblemReporter.j var1 = new ProblemReporter.j(var0.problemPath(), LOGGER);){
            TagValueOutput var2 = TagValueOutput.createWithContext(var1, var0.registryAccess());
            var0.saveWithoutId(var2);
            Path var3 = this.playerDir.toPath();
            Path var4 = Files.createTempFile(var3, var0.getStringUUID() + "-", ".dat", new FileAttribute[0]);
            NBTTagCompound var5 = var2.buildResult();
            NBTCompressedStreamTools.writeCompressed(var5, var4);
            Path var6 = var3.resolve(var0.getStringUUID() + ".dat");
            Path var7 = var3.resolve(var0.getStringUUID() + ".dat_old");
            SystemUtils.safeReplaceFile(var6, var4, var7);
        }
        catch (Exception var12) {
            LOGGER.warn("Failed to save player data for {}", (Object)var0.getPlainTextName());
        }
    }

    private void backup(NameAndId var0, String var1) {
        Path var2 = this.playerDir.toPath();
        String var3 = var0.id().toString();
        Path var4 = var2.resolve(var3 + var1);
        Path var5 = var2.resolve(var3 + "_corrupted_" + LocalDateTime.now().format(FORMATTER) + var1);
        if (!Files.isRegularFile(var4, new LinkOption[0])) {
            return;
        }
        try {
            Files.copy(var4, var5, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (Exception var6) {
            LOGGER.warn("Failed to copy the player.dat file for {}", (Object)var0.name(), (Object)var6);
        }
    }

    private Optional<NBTTagCompound> load(NameAndId var0, String var1) {
        File var2 = new File(this.playerDir, var0.id().toString() + var1);
        if (var2.exists() && var2.isFile()) {
            try {
                return Optional.of(NBTCompressedStreamTools.readCompressed(var2.toPath(), NBTReadLimiter.unlimitedHeap()));
            }
            catch (Exception var3) {
                LOGGER.warn("Failed to load player data for {}", (Object)var0.name());
            }
        }
        return Optional.empty();
    }

    public Optional<NBTTagCompound> load(NameAndId var02) {
        Optional<NBTTagCompound> var1 = this.load(var02, ".dat");
        if (var1.isEmpty()) {
            this.backup(var02, ".dat");
        }
        return var1.or(() -> this.load(var02, ".dat_old")).map(var0 -> {
            int var1 = GameProfileSerializer.getDataVersion(var0, -1);
            var0 = DataFixTypes.PLAYER.updateToCurrentVersion(this.fixerUpper, (NBTTagCompound)var0, var1);
            return var0;
        });
    }
}

