/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.MathHelper;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.OminousBottleAmplifier;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class SetOminousBottleAmplifierFunction
extends LootItemFunctionConditional {
    static final MapCodec<SetOminousBottleAmplifierFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetOminousBottleAmplifierFunction.commonFields(var02).and((App)NumberProviders.CODEC.fieldOf("amplifier").forGetter(var0 -> var0.amplifierGenerator)).apply((Applicative)var02, SetOminousBottleAmplifierFunction::new));
    private final NumberProvider amplifierGenerator;

    private SetOminousBottleAmplifierFunction(List<LootItemCondition> var0, NumberProvider var1) {
        super(var0);
        this.amplifierGenerator = var1;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.amplifierGenerator.getReferencedContextParams();
    }

    public LootItemFunctionType<SetOminousBottleAmplifierFunction> getType() {
        return LootItemFunctions.SET_OMINOUS_BOTTLE_AMPLIFIER;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        int var2 = MathHelper.clamp(this.amplifierGenerator.getInt(var1), 0, 4);
        var0.set(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, new OminousBottleAmplifier(var2));
        return var0;
    }

    public NumberProvider amplifier() {
        return this.amplifierGenerator;
    }

    public static LootItemFunctionConditional.a<?> setAmplifier(NumberProvider var0) {
        return SetOminousBottleAmplifierFunction.simpleBuilder(var1 -> new SetOminousBottleAmplifierFunction((List<LootItemCondition>)var1, var0));
    }
}

