/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public record LootItemConditionBlockStateProperty(Holder<Block> block, Optional<CriterionTriggerProperties> properties) implements LootItemCondition
{
    public static final MapCodec<LootItemConditionBlockStateProperty> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("block").forGetter(LootItemConditionBlockStateProperty::block), (App)CriterionTriggerProperties.CODEC.optionalFieldOf("properties").forGetter(LootItemConditionBlockStateProperty::properties)).apply((Applicative)var0, LootItemConditionBlockStateProperty::new)).validate(LootItemConditionBlockStateProperty::validate);

    private static DataResult<LootItemConditionBlockStateProperty> validate(LootItemConditionBlockStateProperty var0) {
        return var0.properties().flatMap(var1 -> var1.checkState(var0.block().value().getStateDefinition())).map(var1 -> DataResult.error(() -> "Block " + String.valueOf(var0.block()) + " has no property" + var1)).orElse(DataResult.success((Object)var0));
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.BLOCK_STATE_PROPERTY;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParameters.BLOCK_STATE);
    }

    @Override
    public boolean test(LootTableInfo var0) {
        IBlockData var1 = var0.getOptionalParameter(LootContextParameters.BLOCK_STATE);
        return var1 != null && var1.is(this.block) && (this.properties.isEmpty() || this.properties.get().matches(var1));
    }

    public static a hasBlockStateProperties(Block var0) {
        return new a(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootItemCondition.a {
        private final Holder<Block> block;
        private Optional<CriterionTriggerProperties> properties = Optional.empty();

        public a(Block var0) {
            this.block = var0.builtInRegistryHolder();
        }

        public a setProperties(CriterionTriggerProperties.a var0) {
            this.properties = var0.build();
            return this;
        }

        @Override
        public LootItemCondition build() {
            return new LootItemConditionBlockStateProperty(this.block, this.properties);
        }
    }
}

