/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.waypoints;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.ClientboundTrackedWaypointPacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.waypoints.Waypoint;

public interface WaypointTransmitter
extends Waypoint {
    public static final int REALLY_FAR_DISTANCE = 332;

    public boolean isTransmittingWaypoint();

    public Optional<c> makeWaypointConnectionWith(EntityPlayer var1);

    public Waypoint.a waypointIcon();

    public static boolean doesSourceIgnoreReceiver(EntityLiving var0, EntityPlayer var1) {
        if (var1.isSpectator()) {
            return false;
        }
        if (var0.isSpectator() || var0.hasIndirectPassenger(var1)) {
            return true;
        }
        double var2 = Math.min(var0.getAttributeValue(GenericAttributes.WAYPOINT_TRANSMIT_RANGE), var1.getAttributeValue(GenericAttributes.WAYPOINT_RECEIVE_RANGE));
        return (double)var0.distanceTo(var1) >= var2;
    }

    public static boolean isChunkVisible(ChunkCoordIntPair var0, EntityPlayer var1) {
        return var1.getChunkTrackingView().isInViewDistance(var0.x, var0.z);
    }

    public static boolean isReallyFar(EntityLiving var0, EntityPlayer var1) {
        return var0.distanceTo(var1) > 332.0f;
    }

    public static class d
    implements c {
        private final EntityLiving source;
        private final Waypoint.a icon;
        private final EntityPlayer receiver;
        private float lastAngle;

        public d(EntityLiving var0, Waypoint.a var1, EntityPlayer var2) {
            this.source = var0;
            this.icon = var1;
            this.receiver = var2;
            Vec3D var3 = var2.position().subtract(var0.position()).rotateClockwise90();
            this.lastAngle = (float)MathHelper.atan2(var3.z(), var3.x());
        }

        @Override
        public boolean isBroken() {
            return WaypointTransmitter.doesSourceIgnoreReceiver(this.source, this.receiver) || WaypointTransmitter.isChunkVisible(this.source.chunkPosition(), this.receiver) || !WaypointTransmitter.isReallyFar(this.source, this.receiver);
        }

        @Override
        public void connect() {
            this.receiver.connection.send(ClientboundTrackedWaypointPacket.addWaypointAzimuth(this.source.getUUID(), this.icon, this.lastAngle));
        }

        @Override
        public void disconnect() {
            this.receiver.connection.send(ClientboundTrackedWaypointPacket.removeWaypoint(this.source.getUUID()));
        }

        @Override
        public void update() {
            Vec3D var0 = this.receiver.position().subtract(this.source.position()).rotateClockwise90();
            float var1 = (float)MathHelper.atan2(var0.z(), var0.x());
            if (MathHelper.abs(var1 - this.lastAngle) > (float)Math.PI / 360) {
                this.receiver.connection.send(ClientboundTrackedWaypointPacket.updateWaypointAzimuth(this.source.getUUID(), this.icon, var1));
                this.lastAngle = var1;
            }
        }
    }

    public static class f
    implements b {
        private final EntityLiving source;
        private final Waypoint.a icon;
        private final EntityPlayer receiver;
        private ChunkCoordIntPair lastPosition;

        public f(EntityLiving var0, Waypoint.a var1, EntityPlayer var2) {
            this.source = var0;
            this.icon = var1;
            this.receiver = var2;
            this.lastPosition = var0.chunkPosition();
        }

        @Override
        public int distanceChessboard() {
            return this.lastPosition.getChessboardDistance(this.source.chunkPosition());
        }

        @Override
        public void connect() {
            this.receiver.connection.send(ClientboundTrackedWaypointPacket.addWaypointChunk(this.source.getUUID(), this.icon, this.lastPosition));
        }

        @Override
        public void disconnect() {
            this.receiver.connection.send(ClientboundTrackedWaypointPacket.removeWaypoint(this.source.getUUID()));
        }

        @Override
        public void update() {
            ChunkCoordIntPair var0 = this.source.chunkPosition();
            if (var0.getChessboardDistance(this.lastPosition) > 0) {
                this.receiver.connection.send(ClientboundTrackedWaypointPacket.updateWaypointChunk(this.source.getUUID(), this.icon, var0));
                this.lastPosition = var0;
            }
        }

        @Override
        public boolean isBroken() {
            if (b.super.isBroken() || WaypointTransmitter.doesSourceIgnoreReceiver(this.source, this.receiver)) {
                return true;
            }
            return WaypointTransmitter.isChunkVisible(this.lastPosition, this.receiver);
        }
    }

    public static interface b
    extends c {
        public int distanceChessboard();

        @Override
        default public boolean isBroken() {
            return this.distanceChessboard() > 1;
        }
    }

    public static class e
    implements a {
        private final EntityLiving source;
        private final Waypoint.a icon;
        private final EntityPlayer receiver;
        private BlockPosition lastPosition;

        public e(EntityLiving var0, Waypoint.a var1, EntityPlayer var2) {
            this.source = var0;
            this.receiver = var2;
            this.icon = var1;
            this.lastPosition = var0.blockPosition();
        }

        @Override
        public void connect() {
            this.receiver.connection.send(ClientboundTrackedWaypointPacket.addWaypointPosition(this.source.getUUID(), this.icon, this.lastPosition));
        }

        @Override
        public void disconnect() {
            this.receiver.connection.send(ClientboundTrackedWaypointPacket.removeWaypoint(this.source.getUUID()));
        }

        @Override
        public void update() {
            BlockPosition var0 = this.source.blockPosition();
            if (var0.distManhattan(this.lastPosition) > 0) {
                this.receiver.connection.send(ClientboundTrackedWaypointPacket.updateWaypointPosition(this.source.getUUID(), this.icon, var0));
                this.lastPosition = var0;
            }
        }

        @Override
        public int distanceManhattan() {
            return this.lastPosition.distManhattan(this.source.blockPosition());
        }

        @Override
        public boolean isBroken() {
            return a.super.isBroken() || WaypointTransmitter.doesSourceIgnoreReceiver(this.source, this.receiver);
        }
    }

    public static interface a
    extends c {
        public int distanceManhattan();

        @Override
        default public boolean isBroken() {
            return this.distanceManhattan() > 1;
        }
    }

    public static interface c {
        public void connect();

        public void disconnect();

        public void update();

        public boolean isBroken();
    }
}

