/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.MatrixUtil;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SystemUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public final class Transformation {
    private final Matrix4fc matrix;
    public static final Codec<Transformation> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ExtraCodecs.VECTOR3F.fieldOf("translation").forGetter(var0 -> var0.translation), (App)ExtraCodecs.QUATERNIONF.fieldOf("left_rotation").forGetter(var0 -> var0.leftRotation), (App)ExtraCodecs.VECTOR3F.fieldOf("scale").forGetter(var0 -> var0.scale), (App)ExtraCodecs.QUATERNIONF.fieldOf("right_rotation").forGetter(var0 -> var0.rightRotation)).apply((Applicative)var02, Transformation::new));
    public static final Codec<Transformation> EXTENDED_CODEC = Codec.withAlternative(CODEC, (Codec)ExtraCodecs.MATRIX4F.xmap(Transformation::new, Transformation::getMatrix));
    private boolean decomposed;
    private @Nullable Vector3fc translation;
    private @Nullable Quaternionfc leftRotation;
    private @Nullable Vector3fc scale;
    private @Nullable Quaternionfc rightRotation;
    private static final Transformation IDENTITY = SystemUtils.make(() -> {
        Transformation var0 = new Transformation((Matrix4fc)new Matrix4f());
        var0.translation = new Vector3f();
        var0.leftRotation = new Quaternionf();
        var0.scale = new Vector3f(1.0f, 1.0f, 1.0f);
        var0.rightRotation = new Quaternionf();
        var0.decomposed = true;
        return var0;
    });

    public Transformation(@Nullable Matrix4fc var0) {
        this.matrix = var0 == null ? new Matrix4f() : var0;
    }

    public Transformation(@Nullable Vector3fc var0, @Nullable Quaternionfc var1, @Nullable Vector3fc var2, @Nullable Quaternionfc var3) {
        this.matrix = Transformation.compose(var0, var1, var2, var3);
        this.translation = var0 != null ? var0 : new Vector3f();
        this.leftRotation = var1 != null ? var1 : new Quaternionf();
        this.scale = var2 != null ? var2 : new Vector3f(1.0f, 1.0f, 1.0f);
        this.rightRotation = var3 != null ? var3 : new Quaternionf();
        this.decomposed = true;
    }

    public static Transformation identity() {
        return IDENTITY;
    }

    public Transformation compose(Transformation var0) {
        Matrix4f var1 = this.getMatrixCopy();
        var1.mul(var0.getMatrix());
        return new Transformation((Matrix4fc)var1);
    }

    public @Nullable Transformation inverse() {
        if (this == IDENTITY) {
            return this;
        }
        Matrix4f var0 = this.getMatrixCopy().invertAffine();
        if (var0.isFinite()) {
            return new Transformation((Matrix4fc)var0);
        }
        return null;
    }

    private void ensureDecomposed() {
        if (!this.decomposed) {
            float var0 = 1.0f / this.matrix.m33();
            Triple<Quaternionf, Vector3f, Quaternionf> var1 = MatrixUtil.svdDecompose(new Matrix3f(this.matrix).scale(var0));
            this.translation = this.matrix.getTranslation(new Vector3f()).mul(var0);
            this.leftRotation = new Quaternionf((Quaternionfc)var1.getLeft());
            this.scale = new Vector3f((Vector3fc)var1.getMiddle());
            this.rightRotation = new Quaternionf((Quaternionfc)var1.getRight());
            this.decomposed = true;
        }
    }

    private static Matrix4f compose(@Nullable Vector3fc var0, @Nullable Quaternionfc var1, @Nullable Vector3fc var2, @Nullable Quaternionfc var3) {
        Matrix4f var4 = new Matrix4f();
        if (var0 != null) {
            var4.translation(var0);
        }
        if (var1 != null) {
            var4.rotate(var1);
        }
        if (var2 != null) {
            var4.scale(var2);
        }
        if (var3 != null) {
            var4.rotate(var3);
        }
        return var4;
    }

    public Matrix4fc getMatrix() {
        return this.matrix;
    }

    public Matrix4f getMatrixCopy() {
        return new Matrix4f(this.matrix);
    }

    public Vector3fc getTranslation() {
        this.ensureDecomposed();
        return this.translation;
    }

    public Quaternionfc getLeftRotation() {
        this.ensureDecomposed();
        return this.leftRotation;
    }

    public Vector3fc getScale() {
        this.ensureDecomposed();
        return this.scale;
    }

    public Quaternionfc getRightRotation() {
        this.ensureDecomposed();
        return this.rightRotation;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        Transformation var1 = (Transformation)var0;
        return Objects.equals(this.matrix, var1.matrix);
    }

    public int hashCode() {
        return Objects.hash(this.matrix);
    }

    public Transformation slerp(Transformation var0, float var1) {
        return new Transformation((Vector3fc)this.getTranslation().lerp(var0.getTranslation(), var1, new Vector3f()), (Quaternionfc)this.getLeftRotation().slerp(var0.getLeftRotation(), var1, new Quaternionf()), (Vector3fc)this.getScale().lerp(var0.getScale(), var1, new Vector3f()), (Quaternionfc)this.getRightRotation().slerp(var0.getRightRotation(), var1, new Quaternionf()));
    }
}

