/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.criterion.ContextAwarePredicate;
import net.minecraft.advancements.criterion.CriterionConditionEntity;
import net.minecraft.advancements.criterion.CriterionTriggerAbstract;
import net.minecraft.advancements.criterion.CriterionValidator;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public class AnyBlockInteractionTrigger
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    public void trigger(EntityPlayer var0, BlockPosition var12, ItemStack var2) {
        WorldServer var3 = var0.level();
        IBlockData var4 = var3.getBlockState(var12);
        LootParams var5 = new LootParams.a(var3).withParameter(LootContextParameters.ORIGIN, var12.getCenter()).withParameter(LootContextParameters.THIS_ENTITY, var0).withParameter(LootContextParameters.BLOCK_STATE, var4).withParameter(LootContextParameters.TOOL, var2).create(LootContextParameterSets.ADVANCEMENT_LOCATION);
        LootTableInfo var6 = new LootTableInfo.Builder(var5).create(Optional.empty());
        this.trigger(var0, var1 -> var1.matches(var6));
    }

    public record a(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> location) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(a::player), (App)ContextAwarePredicate.CODEC.optionalFieldOf("location").forGetter(a::location)).apply((Applicative)var0, a::new));

        public boolean matches(LootTableInfo var0) {
            return this.location.isEmpty() || this.location.get().matches(var0);
        }

        @Override
        public void validate(CriterionValidator var0) {
            CriterionTriggerAbstract.a.super.validate(var0);
            this.location.ifPresent(var1 -> var0.validate((ContextAwarePredicate)var1, LootContextParameterSets.ADVANCEMENT_LOCATION, "location"));
        }
    }
}

