/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.criterion.CriterionTriggerProperties;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;

public record CriterionConditionFluid(Optional<HolderSet<FluidType>> fluids, Optional<CriterionTriggerProperties> properties) {
    public static final Codec<CriterionConditionFluid> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)RegistryCodecs.homogeneousList(Registries.FLUID).optionalFieldOf("fluids").forGetter(CriterionConditionFluid::fluids), (App)CriterionTriggerProperties.CODEC.optionalFieldOf("state").forGetter(CriterionConditionFluid::properties)).apply((Applicative)var0, CriterionConditionFluid::new));

    public boolean matches(WorldServer var0, BlockPosition var1) {
        if (!var0.isLoaded(var1)) {
            return false;
        }
        Fluid var2 = var0.getFluidState(var1);
        if (this.fluids.isPresent() && !var2.is(this.fluids.get())) {
            return false;
        }
        return !this.properties.isPresent() || this.properties.get().matches(var2);
    }

    public static class a {
        private Optional<HolderSet<FluidType>> fluids = Optional.empty();
        private Optional<CriterionTriggerProperties> properties = Optional.empty();

        private a() {
        }

        public static a fluid() {
            return new a();
        }

        public a of(FluidType var0) {
            this.fluids = Optional.of(HolderSet.direct(var0.builtInRegistryHolder()));
            return this;
        }

        public a of(HolderSet<FluidType> var0) {
            this.fluids = Optional.of(var0);
            return this;
        }

        public a setProperties(CriterionTriggerProperties var0) {
            this.properties = Optional.of(var0);
            return this;
        }

        public CriterionConditionFluid build() {
            return new CriterionConditionFluid(this.fluids, this.properties);
        }
    }
}

