/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.criterion.CriterionConditionValue;
import net.minecraft.util.MathHelper;

public record MovementPredicate(CriterionConditionValue.DoubleRange x, CriterionConditionValue.DoubleRange y, CriterionConditionValue.DoubleRange z, CriterionConditionValue.DoubleRange speed, CriterionConditionValue.DoubleRange horizontalSpeed, CriterionConditionValue.DoubleRange verticalSpeed, CriterionConditionValue.DoubleRange fallDistance) {
    public static final Codec<MovementPredicate> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionValue.DoubleRange.CODEC.optionalFieldOf("x", (Object)CriterionConditionValue.DoubleRange.ANY).forGetter(MovementPredicate::x), (App)CriterionConditionValue.DoubleRange.CODEC.optionalFieldOf("y", (Object)CriterionConditionValue.DoubleRange.ANY).forGetter(MovementPredicate::y), (App)CriterionConditionValue.DoubleRange.CODEC.optionalFieldOf("z", (Object)CriterionConditionValue.DoubleRange.ANY).forGetter(MovementPredicate::z), (App)CriterionConditionValue.DoubleRange.CODEC.optionalFieldOf("speed", (Object)CriterionConditionValue.DoubleRange.ANY).forGetter(MovementPredicate::speed), (App)CriterionConditionValue.DoubleRange.CODEC.optionalFieldOf("horizontal_speed", (Object)CriterionConditionValue.DoubleRange.ANY).forGetter(MovementPredicate::horizontalSpeed), (App)CriterionConditionValue.DoubleRange.CODEC.optionalFieldOf("vertical_speed", (Object)CriterionConditionValue.DoubleRange.ANY).forGetter(MovementPredicate::verticalSpeed), (App)CriterionConditionValue.DoubleRange.CODEC.optionalFieldOf("fall_distance", (Object)CriterionConditionValue.DoubleRange.ANY).forGetter(MovementPredicate::fallDistance)).apply((Applicative)var0, MovementPredicate::new));

    public static MovementPredicate speed(CriterionConditionValue.DoubleRange var0) {
        return new MovementPredicate(CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, var0, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY);
    }

    public static MovementPredicate horizontalSpeed(CriterionConditionValue.DoubleRange var0) {
        return new MovementPredicate(CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, var0, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY);
    }

    public static MovementPredicate verticalSpeed(CriterionConditionValue.DoubleRange var0) {
        return new MovementPredicate(CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, var0, CriterionConditionValue.DoubleRange.ANY);
    }

    public static MovementPredicate fallDistance(CriterionConditionValue.DoubleRange var0) {
        return new MovementPredicate(CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, var0);
    }

    public boolean matches(double var0, double var2, double var4, double var6) {
        if (!(this.x.matches(var0) && this.y.matches(var2) && this.z.matches(var4))) {
            return false;
        }
        double var8 = MathHelper.lengthSquared(var0, var2, var4);
        if (!this.speed.matchesSqr(var8)) {
            return false;
        }
        double var10 = MathHelper.lengthSquared(var0, var4);
        if (!this.horizontalSpeed.matchesSqr(var10)) {
            return false;
        }
        double var12 = Math.abs(var2);
        if (!this.verticalSpeed.matches(var12)) {
            return false;
        }
        return this.fallDistance.matches(var6);
    }
}

