/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.criterion.ContextAwarePredicate;
import net.minecraft.advancements.criterion.CriterionConditionEntity;
import net.minecraft.advancements.criterion.CriterionConditionItem;
import net.minecraft.advancements.criterion.CriterionTriggerAbstract;
import net.minecraft.advancements.criterion.CriterionValidator;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import org.jspecify.annotations.Nullable;

public class PickedUpItemTrigger
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    public void trigger(EntityPlayer var0, ItemStack var1, @Nullable Entity var2) {
        LootTableInfo var32 = CriterionConditionEntity.createContext(var0, var2);
        this.trigger(var0, var3 -> var3.matches(var0, var1, var32));
    }

    public record a(Optional<ContextAwarePredicate> player, Optional<CriterionConditionItem> item, Optional<ContextAwarePredicate> entity) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(a::player), (App)CriterionConditionItem.CODEC.optionalFieldOf("item").forGetter(a::item), (App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("entity").forGetter(a::entity)).apply((Applicative)var0, a::new));

        public static Criterion<a> thrownItemPickedUpByEntity(ContextAwarePredicate var0, Optional<CriterionConditionItem> var1, Optional<ContextAwarePredicate> var2) {
            return CriterionTriggers.THROWN_ITEM_PICKED_UP_BY_ENTITY.createCriterion(new a(Optional.of(var0), var1, var2));
        }

        public static Criterion<a> thrownItemPickedUpByPlayer(Optional<ContextAwarePredicate> var0, Optional<CriterionConditionItem> var1, Optional<ContextAwarePredicate> var2) {
            return CriterionTriggers.THROWN_ITEM_PICKED_UP_BY_PLAYER.createCriterion(new a(var0, var1, var2));
        }

        public boolean matches(EntityPlayer var0, ItemStack var1, LootTableInfo var2) {
            if (this.item.isPresent() && !this.item.get().test(var1)) {
                return false;
            }
            return !this.entity.isPresent() || this.entity.get().matches(var2);
        }

        @Override
        public void validate(CriterionValidator var0) {
            CriterionTriggerAbstract.a.super.validate(var0);
            var0.validateEntity(this.entity, "entity");
        }
    }
}

