/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.server.permissions.PermissionSetSupplier;
import org.jspecify.annotations.Nullable;

public interface ExecutionCommandSource<T extends ExecutionCommandSource<T>>
extends PermissionSetSupplier {
    public T withCallback(CommandResultCallback var1);

    public CommandResultCallback callback();

    default public T clearCallbacks() {
        return this.withCallback(CommandResultCallback.EMPTY);
    }

    public CommandDispatcher<T> dispatcher();

    public void handleError(CommandExceptionType var1, Message var2, boolean var3, @Nullable TraceCallbacks var4);

    public boolean isSilent();

    default public void handleError(CommandSyntaxException var0, boolean var1, @Nullable TraceCallbacks var2) {
        this.handleError(var0.getType(), var0.getRawMessage(), var1, var2);
    }

    public static <T extends ExecutionCommandSource<T>> ResultConsumer<T> resultConsumer() {
        return (var0, var1, var2) -> ((ExecutionCommandSource)var0.getSource()).callback().onResult(var1, var2);
    }
}

