/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.SnbtGrammar;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.parsing.packrat.commands.CommandArgumentParser;
import net.minecraft.util.parsing.packrat.commands.ParserBasedArgument;
import net.minecraft.world.entity.Entity;
import org.jspecify.annotations.Nullable;

public class ArgumentChatComponent
extends ParserBasedArgument<IChatBaseComponent> {
    private static final Collection<String> EXAMPLES = Arrays.asList("\"hello world\"", "'hello world'", "\"\"", "{text:\"hello world\"}", "[\"\"]");
    public static final DynamicCommandExceptionType ERROR_INVALID_COMPONENT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("argument.component.invalid", var0));
    private static final DynamicOps<NBTBase> OPS = DynamicOpsNBT.INSTANCE;
    private static final CommandArgumentParser<NBTBase> TAG_PARSER = SnbtGrammar.createParser(OPS);

    private ArgumentChatComponent(HolderLookup.a var0) {
        super(TAG_PARSER.withCodec(var0.createSerializationContext(OPS), TAG_PARSER, ComponentSerialization.CODEC, ERROR_INVALID_COMPONENT));
    }

    public static IChatBaseComponent getRawComponent(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (IChatBaseComponent)var0.getArgument(var1, IChatBaseComponent.class);
    }

    public static IChatBaseComponent getResolvedComponent(CommandContext<CommandListenerWrapper> var0, String var1, @Nullable Entity var2) throws CommandSyntaxException {
        return ChatComponentUtils.updateForEntity((CommandListenerWrapper)var0.getSource(), ArgumentChatComponent.getRawComponent(var0, var1), var2, 0);
    }

    public static IChatBaseComponent getResolvedComponent(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ArgumentChatComponent.getResolvedComponent(var0, var1, ((CommandListenerWrapper)var0.getSource()).getEntity());
    }

    public static ArgumentChatComponent textComponent(CommandBuildContext var0) {
        return new ArgumentChatComponent(var0);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

