/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.execution;

import com.google.common.collect.Queues;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Deque;
import java.util.List;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.CommandQueueEntry;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.tasks.BuildContexts;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ExecutionContext<T>
implements AutoCloseable {
    private static final int MAX_QUEUE_DEPTH = 10000000;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final int commandLimit;
    private final int forkLimit;
    private final GameProfilerFiller profiler;
    private @Nullable TraceCallbacks tracer;
    private int commandQuota;
    private boolean queueOverflow;
    private final Deque<CommandQueueEntry<T>> commandQueue = Queues.newArrayDeque();
    private final List<CommandQueueEntry<T>> newTopCommands = new ObjectArrayList();
    private int currentFrameDepth;

    public ExecutionContext(int var0, int var1, GameProfilerFiller var2) {
        this.commandLimit = var0;
        this.forkLimit = var1;
        this.profiler = var2;
        this.commandQuota = var0;
    }

    private static <T extends ExecutionCommandSource<T>> Frame createTopFrame(ExecutionContext<T> var0, CommandResultCallback var1) {
        if (var0.currentFrameDepth == 0) {
            return new Frame(0, var1, var0.commandQueue::clear);
        }
        int var2 = var0.currentFrameDepth + 1;
        return new Frame(var2, var1, var0.frameControlForDepth(var2));
    }

    public static <T extends ExecutionCommandSource<T>> void queueInitialFunctionCall(ExecutionContext<T> var0, InstantiatedFunction<T> var1, T var2, CommandResultCallback var3) {
        var0.queueNext(new CommandQueueEntry<T>(ExecutionContext.createTopFrame(var0, var3), new CallFunction<T>(var1, var2.callback(), false).bind(var2)));
    }

    public static <T extends ExecutionCommandSource<T>> void queueInitialCommandExecution(ExecutionContext<T> var0, String var1, ContextChain<T> var2, T var3, CommandResultCallback var4) {
        var0.queueNext(new CommandQueueEntry<T>(ExecutionContext.createTopFrame(var0, var4), new BuildContexts.b<T>(var1, var2, var3)));
    }

    private void handleQueueOverflow() {
        this.queueOverflow = true;
        this.newTopCommands.clear();
        this.commandQueue.clear();
    }

    public void queueNext(CommandQueueEntry<T> var0) {
        if (this.newTopCommands.size() + this.commandQueue.size() > 10000000) {
            this.handleQueueOverflow();
        }
        if (!this.queueOverflow) {
            this.newTopCommands.add(var0);
        }
    }

    public void discardAtDepthOrHigher(int var0) {
        while (!this.commandQueue.isEmpty() && this.commandQueue.peek().frame().depth() >= var0) {
            this.commandQueue.removeFirst();
        }
    }

    public Frame.a frameControlForDepth(int var0) {
        return () -> this.discardAtDepthOrHigher(var0);
    }

    public void runCommandQueue() {
        this.pushNewCommands();
        while (true) {
            if (this.commandQuota <= 0) {
                LOGGER.info("Command execution stopped due to limit (executed {} commands)", (Object)this.commandLimit);
                break;
            }
            CommandQueueEntry<T> var0 = this.commandQueue.pollFirst();
            if (var0 == null) {
                return;
            }
            this.currentFrameDepth = var0.frame().depth();
            var0.execute(this);
            if (this.queueOverflow) {
                LOGGER.error("Command execution stopped due to command queue overflow (max {})", (Object)10000000);
                break;
            }
            this.pushNewCommands();
        }
        this.currentFrameDepth = 0;
    }

    private void pushNewCommands() {
        for (int var0 = this.newTopCommands.size() - 1; var0 >= 0; --var0) {
            this.commandQueue.addFirst(this.newTopCommands.get(var0));
        }
        this.newTopCommands.clear();
    }

    public void tracer(@Nullable TraceCallbacks var0) {
        this.tracer = var0;
    }

    public @Nullable TraceCallbacks tracer() {
        return this.tracer;
    }

    public GameProfilerFiller profiler() {
        return this.profiler;
    }

    public int forkLimit() {
        return this.forkLimit;
    }

    public void incrementCost() {
        --this.commandQuota;
    }

    @Override
    public void close() {
        if (this.tracer != null) {
            this.tracer.close();
        }
    }
}

