/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.network.PacketDataSerializer;

public class FloatArgumentInfo
implements ArgumentTypeInfo<FloatArgumentType, a> {
    @Override
    public void serializeToNetwork(a var0, PacketDataSerializer var1) {
        boolean var2 = var0.min != -3.4028235E38f;
        boolean var3 = var0.max != Float.MAX_VALUE;
        var1.writeByte(ArgumentUtils.createNumberFlags(var2, var3));
        if (var2) {
            var1.writeFloat(var0.min);
        }
        if (var3) {
            var1.writeFloat(var0.max);
        }
    }

    @Override
    public a deserializeFromNetwork(PacketDataSerializer var0) {
        byte var1 = var0.readByte();
        float var2 = ArgumentUtils.numberHasMin(var1) ? var0.readFloat() : -3.4028235E38f;
        float var3 = ArgumentUtils.numberHasMax(var1) ? var0.readFloat() : Float.MAX_VALUE;
        return new a(var2, var3);
    }

    @Override
    public void serializeToJson(a var0, JsonObject var1) {
        if (var0.min != -3.4028235E38f) {
            var1.addProperty("min", (Number)Float.valueOf(var0.min));
        }
        if (var0.max != Float.MAX_VALUE) {
            var1.addProperty("max", (Number)Float.valueOf(var0.max));
        }
    }

    @Override
    public a unpack(FloatArgumentType var0) {
        return new a(var0.getMinimum(), var0.getMaximum());
    }

    @Override
    public /* synthetic */ ArgumentTypeInfo.a deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
        return this.deserializeFromNetwork(packetDataSerializer);
    }

    public final class a
    implements ArgumentTypeInfo.a<FloatArgumentType> {
        final float min;
        final float max;

        a(float var1, float var2) {
            this.min = var1;
            this.max = var2;
        }

        @Override
        public FloatArgumentType instantiate(CommandBuildContext var0) {
            return FloatArgumentType.floatArg((float)this.min, (float)this.max);
        }

        @Override
        public ArgumentTypeInfo<FloatArgumentType, ?> type() {
            return FloatArgumentInfo.this;
        }

        @Override
        public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
            return this.instantiate(commandBuildContext);
        }
    }
}

