/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.biome;

import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeSettings;
import net.minecraft.data.worldgen.WorldGenCarvers;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.attribute.BackgroundMusic;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.attribute.modifier.FloatModifier;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class OverworldBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    private static final int DARK_DRY_FOLIAGE_COLOR = 8082228;
    public static final int SWAMP_SKELETON_WEIGHT = 70;

    public static int calculateSkyColor(float var0) {
        float var1 = var0;
        var1 /= 3.0f;
        var1 = MathHelper.clamp(var1, -1.0f, 1.0f);
        return ARGB.opaque(MathHelper.hsvToRgb(0.62222224f - var1 * 0.05f, 0.5f + var1 * 0.1f, 1.0f));
    }

    private static BiomeBase.a baseBiome(float var0, float var1) {
        return new BiomeBase.a().hasPrecipitation(true).temperature(var0).downfall(var1).setAttribute(EnvironmentAttributes.SKY_COLOR, OverworldBiomes.calculateSkyColor(var0)).specialEffects(new BiomeFog.a().waterColor(4159204).build());
    }

    private static void globalOverworldGeneration(BiomeSettingsGeneration.a var0) {
        BiomeSettings.addDefaultCarversAndLakes(var0);
        BiomeSettings.addDefaultCrystalFormations(var0);
        BiomeSettings.addDefaultMonsterRoom(var0);
        BiomeSettings.addDefaultUndergroundVariety(var0);
        BiomeSettings.addDefaultSprings(var0);
        BiomeSettings.addSurfaceFreezing(var0);
    }

    public static BiomeBase oldGrowthTaiga(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var3);
        var3.addSpawn(EnumCreatureType.CREATURE, 8, new BiomeSettingsMobs.c(EntityTypes.WOLF, 4, 4));
        var3.addSpawn(EnumCreatureType.CREATURE, 4, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 2, 3));
        var3.addSpawn(EnumCreatureType.CREATURE, 8, new BiomeSettingsMobs.c(EntityTypes.FOX, 2, 4));
        if (var2) {
            BiomeSettings.commonSpawns(var3);
        } else {
            BiomeSettings.caveSpawns(var3);
            BiomeSettings.monsters(var3, 100, 25, 0, 100, false);
        }
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeSettings.addMossyStoneBlock(var4);
        BiomeSettings.addFerns(var4);
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, var2 ? VegetationPlacements.TREES_OLD_GROWTH_SPRUCE_TAIGA : VegetationPlacements.TREES_OLD_GROWTH_PINE_TAIGA);
        BiomeSettings.addDefaultFlowers(var4);
        BiomeSettings.addGiantTaigaVegetation(var4);
        BiomeSettings.addDefaultMushrooms(var4);
        BiomeSettings.addDefaultExtraVegetation(var4, true);
        BiomeSettings.addCommonBerryBushes(var4);
        return OverworldBiomes.baseBiome(var2 ? 0.25f : 0.3f, 0.8f).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_OLD_GROWTH_TAIGA)).mobSpawnSettings(var3.build()).generationSettings(var4.build()).build();
    }

    public static BiomeBase sparseJungle(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.baseJungleSpawns(var2);
        var2.addSpawn(EnumCreatureType.CREATURE, 8, new BiomeSettingsMobs.c(EntityTypes.WOLF, 2, 4));
        return OverworldBiomes.baseJungle(var0, var1, 0.8f, false, true, false).mobSpawnSettings(var2.build()).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_SPARSE_JUNGLE)).build();
    }

    public static BiomeBase jungle(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.baseJungleSpawns(var2);
        var2.addSpawn(EnumCreatureType.CREATURE, 40, new BiomeSettingsMobs.c(EntityTypes.PARROT, 1, 2)).addSpawn(EnumCreatureType.MONSTER, 2, new BiomeSettingsMobs.c(EntityTypes.OCELOT, 1, 3)).addSpawn(EnumCreatureType.CREATURE, 1, new BiomeSettingsMobs.c(EntityTypes.PANDA, 1, 2));
        return OverworldBiomes.baseJungle(var0, var1, 0.9f, false, false, true).mobSpawnSettings(var2.build()).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_JUNGLE)).setAttribute(EnvironmentAttributes.INCREASED_FIRE_BURNOUT, true).build();
    }

    public static BiomeBase bambooJungle(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.baseJungleSpawns(var2);
        var2.addSpawn(EnumCreatureType.CREATURE, 40, new BiomeSettingsMobs.c(EntityTypes.PARROT, 1, 2)).addSpawn(EnumCreatureType.CREATURE, 80, new BiomeSettingsMobs.c(EntityTypes.PANDA, 1, 2)).addSpawn(EnumCreatureType.MONSTER, 2, new BiomeSettingsMobs.c(EntityTypes.OCELOT, 1, 1));
        return OverworldBiomes.baseJungle(var0, var1, 0.9f, true, false, true).mobSpawnSettings(var2.build()).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_BAMBOO_JUNGLE)).setAttribute(EnvironmentAttributes.INCREASED_FIRE_BURNOUT, true).build();
    }

    private static BiomeBase.a baseJungle(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, float var2, boolean var3, boolean var4, boolean var5) {
        BiomeSettingsGeneration.a var6 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var6);
        BiomeSettings.addDefaultOres(var6);
        BiomeSettings.addDefaultSoftDisks(var6);
        if (var3) {
            BiomeSettings.addBambooVegetation(var6);
        } else {
            if (var5) {
                BiomeSettings.addLightBambooVegetation(var6);
            }
            if (var4) {
                BiomeSettings.addSparseJungleTrees(var6);
            } else {
                BiomeSettings.addJungleTrees(var6);
            }
        }
        BiomeSettings.addWarmFlowers(var6);
        BiomeSettings.addJungleGrass(var6);
        BiomeSettings.addDefaultMushrooms(var6);
        BiomeSettings.addDefaultExtraVegetation(var6, true);
        BiomeSettings.addJungleVines(var6);
        if (var4) {
            BiomeSettings.addSparseJungleMelons(var6);
        } else {
            BiomeSettings.addJungleMelons(var6);
        }
        return OverworldBiomes.baseBiome(0.95f, var2).generationSettings(var6.build());
    }

    public static BiomeBase windsweptHills(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var3);
        var3.addSpawn(EnumCreatureType.CREATURE, 5, new BiomeSettingsMobs.c(EntityTypes.LLAMA, 4, 6));
        BiomeSettings.commonSpawns(var3);
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        if (var2) {
            BiomeSettings.addMountainForestTrees(var4);
        } else {
            BiomeSettings.addMountainTrees(var4);
        }
        BiomeSettings.addBushes(var4);
        BiomeSettings.addDefaultFlowers(var4);
        BiomeSettings.addDefaultGrass(var4);
        BiomeSettings.addDefaultMushrooms(var4);
        BiomeSettings.addDefaultExtraVegetation(var4, true);
        BiomeSettings.addExtraEmeralds(var4);
        BiomeSettings.addInfestedStone(var4);
        return OverworldBiomes.baseBiome(0.2f, 0.3f).mobSpawnSettings(var3.build()).generationSettings(var4.build()).build();
    }

    public static BiomeBase desert(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.desertSpawns(var2);
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettings.addFossilDecoration(var3);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        BiomeSettings.addDefaultFlowers(var3);
        BiomeSettings.addDefaultGrass(var3);
        BiomeSettings.addDesertVegetation(var3);
        BiomeSettings.addDefaultMushrooms(var3);
        BiomeSettings.addDesertExtraVegetation(var3);
        BiomeSettings.addDesertExtraDecoration(var3);
        return OverworldBiomes.baseBiome(2.0f, 0.0f).hasPrecipitation(false).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_DESERT)).setAttribute(EnvironmentAttributes.SNOW_GOLEM_MELTS, true).mobSpawnSettings(var2.build()).generationSettings(var3.build()).build();
    }

    public static BiomeBase plains(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2, boolean var3, boolean var4) {
        BiomeSettingsMobs.a var5 = new BiomeSettingsMobs.a();
        BiomeSettingsGeneration.a var6 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var6);
        if (var3) {
            var5.creatureGenerationProbability(0.07f);
            BiomeSettings.snowySpawns(var5, !var4);
            if (var4) {
                var6.addFeature(WorldGenStage.Decoration.SURFACE_STRUCTURES, MiscOverworldPlacements.ICE_SPIKE);
                var6.addFeature(WorldGenStage.Decoration.SURFACE_STRUCTURES, MiscOverworldPlacements.ICE_PATCH);
            }
        } else {
            BiomeSettings.plainsSpawns(var5);
            BiomeSettings.addPlainGrass(var6);
            if (var2) {
                var6.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_SUNFLOWER);
            } else {
                BiomeSettings.addBushes(var6);
            }
        }
        BiomeSettings.addDefaultOres(var6);
        BiomeSettings.addDefaultSoftDisks(var6);
        if (var3) {
            BiomeSettings.addSnowyTrees(var6);
            BiomeSettings.addDefaultFlowers(var6);
            BiomeSettings.addDefaultGrass(var6);
        } else {
            BiomeSettings.addPlainVegetation(var6);
        }
        BiomeSettings.addDefaultMushrooms(var6);
        BiomeSettings.addDefaultExtraVegetation(var6, true);
        return OverworldBiomes.baseBiome(var3 ? 0.0f : 0.8f, var3 ? 0.5f : 0.4f).mobSpawnSettings(var5.build()).generationSettings(var6.build()).build();
    }

    public static BiomeBase mushroomFields(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.mooshroomSpawns(var2);
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        BiomeSettings.addMushroomFieldVegetation(var3);
        BiomeSettings.addNearWaterVegetation(var3);
        return OverworldBiomes.baseBiome(0.9f, 1.0f).setAttribute(EnvironmentAttributes.INCREASED_FIRE_BURNOUT, true).setAttribute(EnvironmentAttributes.CAN_PILLAGER_PATROL_SPAWN, false).mobSpawnSettings(var2.build()).generationSettings(var3.build()).build();
    }

    public static BiomeBase savanna(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2, boolean var3) {
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        if (!var2) {
            BiomeSettings.addSavannaGrass(var4);
        }
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        if (var2) {
            BiomeSettings.addShatteredSavannaTrees(var4);
            BiomeSettings.addDefaultFlowers(var4);
            BiomeSettings.addShatteredSavannaGrass(var4);
        } else {
            BiomeSettings.addSavannaTrees(var4);
            BiomeSettings.addWarmFlowers(var4);
            BiomeSettings.addSavannaExtraGrass(var4);
        }
        BiomeSettings.addDefaultMushrooms(var4);
        BiomeSettings.addDefaultExtraVegetation(var4, true);
        BiomeSettingsMobs.a var5 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var5);
        var5.addSpawn(EnumCreatureType.CREATURE, 1, new BiomeSettingsMobs.c(EntityTypes.HORSE, 2, 6)).addSpawn(EnumCreatureType.CREATURE, 1, new BiomeSettingsMobs.c(EntityTypes.DONKEY, 1, 1)).addSpawn(EnumCreatureType.CREATURE, 10, new BiomeSettingsMobs.c(EntityTypes.ARMADILLO, 2, 3));
        BiomeSettings.commonSpawnWithZombieHorse(var5);
        if (var3) {
            var5.addSpawn(EnumCreatureType.CREATURE, 8, new BiomeSettingsMobs.c(EntityTypes.LLAMA, 4, 4));
            var5.addSpawn(EnumCreatureType.CREATURE, 8, new BiomeSettingsMobs.c(EntityTypes.WOLF, 4, 8));
        }
        return OverworldBiomes.baseBiome(2.0f, 0.0f).hasPrecipitation(false).setAttribute(EnvironmentAttributes.SNOW_GOLEM_MELTS, true).mobSpawnSettings(var5.build()).generationSettings(var4.build()).build();
    }

    public static BiomeBase badlands(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var3);
        BiomeSettings.commonSpawns(var3);
        var3.addSpawn(EnumCreatureType.CREATURE, 6, new BiomeSettingsMobs.c(EntityTypes.ARMADILLO, 1, 2));
        var3.creatureGenerationProbability(0.03f);
        if (var2) {
            var3.addSpawn(EnumCreatureType.CREATURE, 2, new BiomeSettingsMobs.c(EntityTypes.WOLF, 4, 8));
            var3.creatureGenerationProbability(0.04f);
        }
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addExtraGold(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        if (var2) {
            BiomeSettings.addBadlandsTrees(var4);
        }
        BiomeSettings.addBadlandGrass(var4);
        BiomeSettings.addDefaultMushrooms(var4);
        BiomeSettings.addBadlandExtraVegetation(var4);
        return OverworldBiomes.baseBiome(2.0f, 0.0f).hasPrecipitation(false).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_BADLANDS)).setAttribute(EnvironmentAttributes.SNOW_GOLEM_MELTS, true).specialEffects(new BiomeFog.a().waterColor(4159204).foliageColorOverride(10387789).grassColorOverride(9470285).build()).mobSpawnSettings(var3.build()).generationSettings(var4.build()).build();
    }

    private static BiomeBase.a baseOcean() {
        return OverworldBiomes.baseBiome(0.5f, 0.5f).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, BackgroundMusic.OVERWORLD.withUnderwater(Musics.UNDER_WATER));
    }

    private static BiomeSettingsGeneration.a baseOceanGeneration(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        BiomeSettings.addWaterTrees(var2);
        BiomeSettings.addDefaultFlowers(var2);
        BiomeSettings.addDefaultGrass(var2);
        BiomeSettings.addDefaultMushrooms(var2);
        BiomeSettings.addDefaultExtraVegetation(var2, true);
        return var2;
    }

    public static BiomeBase coldOcean(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.oceanSpawns(var3, 3, 4, 15);
        var3.addSpawn(EnumCreatureType.WATER_AMBIENT, 15, new BiomeSettingsMobs.c(EntityTypes.SALMON, 1, 5));
        var3.addSpawn(EnumCreatureType.WATER_CREATURE, 2, new BiomeSettingsMobs.c(EntityTypes.NAUTILUS, 1, 1));
        BiomeSettingsGeneration.a var4 = OverworldBiomes.baseOceanGeneration(var0, var1);
        var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, var2 ? AquaticPlacements.SEAGRASS_DEEP_COLD : AquaticPlacements.SEAGRASS_COLD);
        BiomeSettings.addColdOceanExtraVegetation(var4);
        return OverworldBiomes.baseOcean().specialEffects(new BiomeFog.a().waterColor(4020182).build()).mobSpawnSettings(var3.build()).generationSettings(var4.build()).build();
    }

    public static BiomeBase ocean(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.oceanSpawns(var3, 1, 4, 10);
        var3.addSpawn(EnumCreatureType.WATER_CREATURE, 1, new BiomeSettingsMobs.c(EntityTypes.DOLPHIN, 1, 2)).addSpawn(EnumCreatureType.WATER_CREATURE, 5, new BiomeSettingsMobs.c(EntityTypes.NAUTILUS, 1, 1));
        BiomeSettingsGeneration.a var4 = OverworldBiomes.baseOceanGeneration(var0, var1);
        var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, var2 ? AquaticPlacements.SEAGRASS_DEEP : AquaticPlacements.SEAGRASS_NORMAL);
        BiomeSettings.addColdOceanExtraVegetation(var4);
        return OverworldBiomes.baseOcean().mobSpawnSettings(var3.build()).generationSettings(var4.build()).build();
    }

    public static BiomeBase lukeWarmOcean(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        if (var2) {
            BiomeSettings.oceanSpawns(var3, 8, 4, 8);
        } else {
            BiomeSettings.oceanSpawns(var3, 10, 2, 15);
        }
        var3.addSpawn(EnumCreatureType.WATER_AMBIENT, 5, new BiomeSettingsMobs.c(EntityTypes.PUFFERFISH, 1, 3)).addSpawn(EnumCreatureType.WATER_AMBIENT, 25, new BiomeSettingsMobs.c(EntityTypes.TROPICAL_FISH, 8, 8)).addSpawn(EnumCreatureType.WATER_CREATURE, 2, new BiomeSettingsMobs.c(EntityTypes.DOLPHIN, 1, 2)).addSpawn(EnumCreatureType.WATER_CREATURE, 5, new BiomeSettingsMobs.c(EntityTypes.NAUTILUS, 1, 1));
        BiomeSettingsGeneration.a var4 = OverworldBiomes.baseOceanGeneration(var0, var1);
        var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, var2 ? AquaticPlacements.SEAGRASS_DEEP_WARM : AquaticPlacements.SEAGRASS_WARM);
        BiomeSettings.addLukeWarmKelp(var4);
        return OverworldBiomes.baseOcean().setAttribute(EnvironmentAttributes.WATER_FOG_COLOR, -16509389).specialEffects(new BiomeFog.a().waterColor(4566514).build()).mobSpawnSettings(var3.build()).generationSettings(var4.build()).build();
    }

    public static BiomeBase warmOcean(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.WATER_AMBIENT, 15, new BiomeSettingsMobs.c(EntityTypes.PUFFERFISH, 1, 3)).addSpawn(EnumCreatureType.WATER_CREATURE, 5, new BiomeSettingsMobs.c(EntityTypes.NAUTILUS, 1, 1));
        BiomeSettings.warmOceanSpawns(var2, 10, 4);
        BiomeSettingsGeneration.a var3 = OverworldBiomes.baseOceanGeneration(var0, var1).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_WARM).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE);
        return OverworldBiomes.baseOcean().setAttribute(EnvironmentAttributes.WATER_FOG_COLOR, -16507085).specialEffects(new BiomeFog.a().waterColor(4445678).build()).mobSpawnSettings(var2.build()).generationSettings(var3.build()).build();
    }

    public static BiomeBase frozenOcean(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.WATER_CREATURE, 1, new BiomeSettingsMobs.c(EntityTypes.SQUID, 1, 4)).addSpawn(EnumCreatureType.WATER_AMBIENT, 15, new BiomeSettingsMobs.c(EntityTypes.SALMON, 1, 5)).addSpawn(EnumCreatureType.CREATURE, 1, new BiomeSettingsMobs.c(EntityTypes.POLAR_BEAR, 1, 2)).addSpawn(EnumCreatureType.WATER_CREATURE, 2, new BiomeSettingsMobs.c(EntityTypes.NAUTILUS, 1, 1));
        BiomeSettings.commonSpawns(var3);
        var3.addSpawn(EnumCreatureType.MONSTER, 5, new BiomeSettingsMobs.c(EntityTypes.DROWNED, 1, 1));
        float var4 = var2 ? 0.5f : 0.0f;
        BiomeSettingsGeneration.a var5 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettings.addIcebergs(var5);
        OverworldBiomes.globalOverworldGeneration(var5);
        BiomeSettings.addBlueIce(var5);
        BiomeSettings.addDefaultOres(var5);
        BiomeSettings.addDefaultSoftDisks(var5);
        BiomeSettings.addWaterTrees(var5);
        BiomeSettings.addDefaultFlowers(var5);
        BiomeSettings.addDefaultGrass(var5);
        BiomeSettings.addDefaultMushrooms(var5);
        BiomeSettings.addDefaultExtraVegetation(var5, true);
        return OverworldBiomes.baseBiome(var4, 0.5f).temperatureAdjustment(BiomeBase.TemperatureModifier.FROZEN).specialEffects(new BiomeFog.a().waterColor(3750089).build()).mobSpawnSettings(var3.build()).generationSettings(var5.build()).build();
    }

    public static BiomeBase forest(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2, boolean var3, boolean var4) {
        BackgroundMusic var6;
        BiomeSettingsGeneration.a var5 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var5);
        if (var4) {
            var6 = new BackgroundMusic(SoundEffects.MUSIC_BIOME_FLOWER_FOREST);
            var5.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FOREST_FLOWERS);
        } else {
            var6 = new BackgroundMusic(SoundEffects.MUSIC_BIOME_FOREST);
            BiomeSettings.addForestFlowers(var5);
        }
        BiomeSettings.addDefaultOres(var5);
        BiomeSettings.addDefaultSoftDisks(var5);
        if (var4) {
            var5.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.TREES_FLOWER_FOREST);
            var5.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FLOWER_FOREST);
            BiomeSettings.addDefaultGrass(var5);
        } else {
            if (var2) {
                BiomeSettings.addBirchForestFlowers(var5);
                if (var3) {
                    BiomeSettings.addTallBirchTrees(var5);
                } else {
                    BiomeSettings.addBirchTrees(var5);
                }
            } else {
                BiomeSettings.addOtherBirchTrees(var5);
            }
            BiomeSettings.addBushes(var5);
            BiomeSettings.addDefaultFlowers(var5);
            BiomeSettings.addForestGrass(var5);
        }
        BiomeSettings.addDefaultMushrooms(var5);
        BiomeSettings.addDefaultExtraVegetation(var5, true);
        BiomeSettingsMobs.a var7 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var7);
        BiomeSettings.commonSpawns(var7);
        if (var4) {
            var7.addSpawn(EnumCreatureType.CREATURE, 4, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 2, 3));
        } else if (!var2) {
            var7.addSpawn(EnumCreatureType.CREATURE, 5, new BiomeSettingsMobs.c(EntityTypes.WOLF, 4, 4));
        }
        return OverworldBiomes.baseBiome(var2 ? 0.6f : 0.7f, var2 ? 0.6f : 0.8f).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, var6).mobSpawnSettings(var7.build()).generationSettings(var5.build()).build();
    }

    public static BiomeBase taiga(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var3);
        var3.addSpawn(EnumCreatureType.CREATURE, 8, new BiomeSettingsMobs.c(EntityTypes.WOLF, 4, 4)).addSpawn(EnumCreatureType.CREATURE, 4, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 2, 3)).addSpawn(EnumCreatureType.CREATURE, 8, new BiomeSettingsMobs.c(EntityTypes.FOX, 2, 4));
        BiomeSettings.commonSpawns(var3);
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeSettings.addFerns(var4);
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        BiomeSettings.addTaigaTrees(var4);
        BiomeSettings.addDefaultFlowers(var4);
        BiomeSettings.addTaigaGrass(var4);
        BiomeSettings.addDefaultExtraVegetation(var4, true);
        if (var2) {
            BiomeSettings.addRareBerryBushes(var4);
        } else {
            BiomeSettings.addCommonBerryBushes(var4);
        }
        int var5 = var2 ? 4020182 : 4159204;
        return OverworldBiomes.baseBiome(var2 ? -0.5f : 0.25f, var2 ? 0.4f : 0.8f).specialEffects(new BiomeFog.a().waterColor(var5).build()).mobSpawnSettings(var3.build()).generationSettings(var4.build()).build();
    }

    public static BiomeBase darkForest(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        if (!var2) {
            BiomeSettings.farmAnimals(var3);
        }
        BiomeSettings.commonSpawns(var3);
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, var2 ? VegetationPlacements.PALE_GARDEN_VEGETATION : VegetationPlacements.DARK_FOREST_VEGETATION);
        if (!var2) {
            BiomeSettings.addForestFlowers(var4);
        } else {
            var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.PALE_MOSS_PATCH);
            var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.PALE_GARDEN_FLOWERS);
        }
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        if (!var2) {
            BiomeSettings.addDefaultFlowers(var4);
        } else {
            var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_PALE_GARDEN);
        }
        BiomeSettings.addForestGrass(var4);
        if (!var2) {
            BiomeSettings.addDefaultMushrooms(var4);
            BiomeSettings.addLeafLitterPatch(var4);
        }
        BiomeSettings.addDefaultExtraVegetation(var4, true);
        EnvironmentAttributeMap var5 = EnvironmentAttributeMap.builder().set(EnvironmentAttributes.SKY_COLOR, -4605511).set(EnvironmentAttributes.FOG_COLOR, -8292496).set(EnvironmentAttributes.WATER_FOG_COLOR, -11179648).set(EnvironmentAttributes.BACKGROUND_MUSIC, BackgroundMusic.EMPTY).set(EnvironmentAttributes.MUSIC_VOLUME, Float.valueOf(0.0f)).build();
        EnvironmentAttributeMap var6 = EnvironmentAttributeMap.builder().set(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_FOREST)).build();
        return OverworldBiomes.baseBiome(0.7f, 0.8f).putAttributes(var2 ? var5 : var6).specialEffects(var2 ? new BiomeFog.a().waterColor(7768221).grassColorOverride(0x778272).foliageColorOverride(8883574).dryFoliageColorOverride(10528412).build() : new BiomeFog.a().waterColor(4159204).dryFoliageColorOverride(8082228).grassColorModifier(BiomeFog.GrassColor.DARK_FOREST).build()).mobSpawnSettings(var3.build()).generationSettings(var4.build()).build();
    }

    public static BiomeBase swamp(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var2);
        BiomeSettings.swampSpawns(var2, 70);
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettings.addFossilDecoration(var3);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addSwampClayDisk(var3);
        BiomeSettings.addSwampVegetation(var3);
        BiomeSettings.addDefaultMushrooms(var3);
        BiomeSettings.addSwampExtraVegetation(var3);
        var3.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SWAMP);
        return OverworldBiomes.baseBiome(0.8f, 0.9f).setAttribute(EnvironmentAttributes.WATER_FOG_COLOR, -14474473).modifyAttribute(EnvironmentAttributes.WATER_FOG_END_DISTANCE, FloatModifier.MULTIPLY, Float.valueOf(0.85f)).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_SWAMP)).setAttribute(EnvironmentAttributes.INCREASED_FIRE_BURNOUT, true).specialEffects(new BiomeFog.a().waterColor(6388580).foliageColorOverride(6975545).dryFoliageColorOverride(8082228).grassColorModifier(BiomeFog.GrassColor.SWAMP).build()).mobSpawnSettings(var2.build()).generationSettings(var3.build()).build();
    }

    public static BiomeBase mangroveSwamp(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.swampSpawns(var2, 70);
        var2.addSpawn(EnumCreatureType.WATER_AMBIENT, 25, new BiomeSettingsMobs.c(EntityTypes.TROPICAL_FISH, 8, 8));
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettings.addFossilDecoration(var3);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addMangroveSwampDisks(var3);
        BiomeSettings.addMangroveSwampVegetation(var3);
        BiomeSettings.addMangroveSwampExtraVegetation(var3);
        return OverworldBiomes.baseBiome(0.8f, 0.9f).setAttribute(EnvironmentAttributes.FOG_COLOR, -4138753).setAttribute(EnvironmentAttributes.WATER_FOG_COLOR, -11699616).modifyAttribute(EnvironmentAttributes.WATER_FOG_END_DISTANCE, FloatModifier.MULTIPLY, Float.valueOf(0.85f)).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_SWAMP)).setAttribute(EnvironmentAttributes.INCREASED_FIRE_BURNOUT, true).specialEffects(new BiomeFog.a().waterColor(3832426).foliageColorOverride(9285927).dryFoliageColorOverride(8082228).grassColorModifier(BiomeFog.GrassColor.SWAMP).build()).mobSpawnSettings(var2.build()).generationSettings(var3.build()).build();
    }

    public static BiomeBase river(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.WATER_CREATURE, 2, new BiomeSettingsMobs.c(EntityTypes.SQUID, 1, 4)).addSpawn(EnumCreatureType.WATER_AMBIENT, 5, new BiomeSettingsMobs.c(EntityTypes.SALMON, 1, 5));
        BiomeSettings.commonSpawns(var3);
        var3.addSpawn(EnumCreatureType.MONSTER, var2 ? 1 : 100, new BiomeSettingsMobs.c(EntityTypes.DROWNED, 1, 1));
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        BiomeSettings.addWaterTrees(var4);
        BiomeSettings.addBushes(var4);
        BiomeSettings.addDefaultFlowers(var4);
        BiomeSettings.addDefaultGrass(var4);
        BiomeSettings.addDefaultMushrooms(var4);
        BiomeSettings.addDefaultExtraVegetation(var4, true);
        if (!var2) {
            var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_RIVER);
        }
        return OverworldBiomes.baseBiome(var2 ? 0.0f : 0.5f, 0.5f).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, BackgroundMusic.OVERWORLD.withUnderwater(Musics.UNDER_WATER)).specialEffects(new BiomeFog.a().waterColor(var2 ? 3750089 : 4159204).build()).mobSpawnSettings(var3.build()).generationSettings(var4.build()).build();
    }

    public static BiomeBase beach(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2, boolean var3) {
        boolean var5;
        BiomeSettingsMobs.a var4 = new BiomeSettingsMobs.a();
        boolean bl = var5 = !var3 && !var2;
        if (var5) {
            var4.addSpawn(EnumCreatureType.CREATURE, 5, new BiomeSettingsMobs.c(EntityTypes.TURTLE, 2, 5));
        }
        BiomeSettings.commonSpawns(var4);
        BiomeSettingsGeneration.a var6 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var6);
        BiomeSettings.addDefaultOres(var6);
        BiomeSettings.addDefaultSoftDisks(var6);
        BiomeSettings.addDefaultFlowers(var6);
        BiomeSettings.addDefaultGrass(var6);
        BiomeSettings.addDefaultMushrooms(var6);
        BiomeSettings.addDefaultExtraVegetation(var6, true);
        float var7 = var2 ? 0.05f : (var3 ? 0.2f : 0.8f);
        int var8 = var2 ? 4020182 : 4159204;
        return OverworldBiomes.baseBiome(var7, var5 ? 0.4f : 0.3f).specialEffects(new BiomeFog.a().waterColor(var8).build()).mobSpawnSettings(var4.build()).generationSettings(var6.build()).build();
    }

    public static BiomeBase theVoid(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a(var0, var1);
        var2.addFeature(WorldGenStage.Decoration.TOP_LAYER_MODIFICATION, MiscOverworldPlacements.VOID_START_PLATFORM);
        return OverworldBiomes.baseBiome(0.5f, 0.5f).hasPrecipitation(false).mobSpawnSettings(new BiomeSettingsMobs.a().build()).generationSettings(var2.build()).build();
    }

    public static BiomeBase meadowOrCherryGrove(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettingsMobs.a var4 = new BiomeSettingsMobs.a();
        var4.addSpawn(EnumCreatureType.CREATURE, 1, new BiomeSettingsMobs.c(var2 ? EntityTypes.PIG : EntityTypes.DONKEY, 1, 2)).addSpawn(EnumCreatureType.CREATURE, 2, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 2, 6)).addSpawn(EnumCreatureType.CREATURE, 2, new BiomeSettingsMobs.c(EntityTypes.SHEEP, 2, 4));
        BiomeSettings.commonSpawns(var4);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addPlainGrass(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        if (var2) {
            BiomeSettings.addCherryGroveVegetation(var3);
        } else {
            BiomeSettings.addMeadowVegetation(var3);
        }
        BiomeSettings.addExtraEmeralds(var3);
        BiomeSettings.addInfestedStone(var3);
        if (var2) {
            BiomeFog.a var5 = new BiomeFog.a().waterColor(6141935).grassColorOverride(11983713).foliageColorOverride(11983713);
            return OverworldBiomes.baseBiome(0.5f, 0.8f).setAttribute(EnvironmentAttributes.WATER_FOG_COLOR, -10635281).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_CHERRY_GROVE)).specialEffects(var5.build()).mobSpawnSettings(var4.build()).generationSettings(var3.build()).build();
        }
        return OverworldBiomes.baseBiome(0.5f, 0.8f).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_MEADOW)).specialEffects(new BiomeFog.a().waterColor(937679).build()).mobSpawnSettings(var4.build()).generationSettings(var3.build()).build();
    }

    private static BiomeBase.a basePeaks(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        var3.addSpawn(EnumCreatureType.CREATURE, 5, new BiomeSettingsMobs.c(EntityTypes.GOAT, 1, 3));
        BiomeSettings.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addFrozenSprings(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        BiomeSettings.addExtraEmeralds(var2);
        BiomeSettings.addInfestedStone(var2);
        return OverworldBiomes.baseBiome(-0.7f, 0.9f).setAttribute(EnvironmentAttributes.INCREASED_FIRE_BURNOUT, true).mobSpawnSettings(var3.build()).generationSettings(var2.build());
    }

    public static BiomeBase frozenPeaks(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        return OverworldBiomes.basePeaks(var0, var1).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_FROZEN_PEAKS)).build();
    }

    public static BiomeBase jaggedPeaks(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        return OverworldBiomes.basePeaks(var0, var1).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_JAGGED_PEAKS)).build();
    }

    public static BiomeBase stonyPeaks(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        BiomeSettings.addExtraEmeralds(var2);
        BiomeSettings.addInfestedStone(var2);
        return OverworldBiomes.baseBiome(1.0f, 0.3f).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_STONY_PEAKS)).mobSpawnSettings(var3.build()).generationSettings(var2.build()).build();
    }

    public static BiomeBase snowySlopes(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        var3.addSpawn(EnumCreatureType.CREATURE, 4, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 2, 3)).addSpawn(EnumCreatureType.CREATURE, 5, new BiomeSettingsMobs.c(EntityTypes.GOAT, 1, 3));
        BiomeSettings.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addFrozenSprings(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        BiomeSettings.addDefaultExtraVegetation(var2, false);
        BiomeSettings.addExtraEmeralds(var2);
        BiomeSettings.addInfestedStone(var2);
        return OverworldBiomes.baseBiome(-0.3f, 0.9f).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_SNOWY_SLOPES)).setAttribute(EnvironmentAttributes.INCREASED_FIRE_BURNOUT, true).mobSpawnSettings(var3.build()).generationSettings(var2.build()).build();
    }

    public static BiomeBase grove(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        var3.addSpawn(EnumCreatureType.CREATURE, 1, new BiomeSettingsMobs.c(EntityTypes.WOLF, 1, 1)).addSpawn(EnumCreatureType.CREATURE, 8, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 2, 3)).addSpawn(EnumCreatureType.CREATURE, 4, new BiomeSettingsMobs.c(EntityTypes.FOX, 2, 4));
        BiomeSettings.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addFrozenSprings(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        BiomeSettings.addGroveTrees(var2);
        BiomeSettings.addDefaultExtraVegetation(var2, false);
        BiomeSettings.addExtraEmeralds(var2);
        BiomeSettings.addInfestedStone(var2);
        return OverworldBiomes.baseBiome(-0.2f, 0.8f).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_GROVE)).mobSpawnSettings(var3.build()).generationSettings(var2.build()).build();
    }

    public static BiomeBase lushCaves(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        var2.addSpawn(EnumCreatureType.AXOLOTLS, 10, new BiomeSettingsMobs.c(EntityTypes.AXOLOTL, 4, 6));
        var2.addSpawn(EnumCreatureType.WATER_AMBIENT, 25, new BiomeSettingsMobs.c(EntityTypes.TROPICAL_FISH, 8, 8));
        BiomeSettings.commonSpawns(var2);
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addPlainGrass(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addLushCavesSpecialOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        BiomeSettings.addLushCavesVegetationFeatures(var3);
        return OverworldBiomes.baseBiome(0.5f, 0.5f).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_LUSH_CAVES)).mobSpawnSettings(var2.build()).generationSettings(var3.build()).build();
    }

    public static BiomeBase dripstoneCaves(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.dripstoneCavesSpawns(var2);
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addPlainGrass(var3);
        BiomeSettings.addDefaultOres(var3, true);
        BiomeSettings.addDefaultSoftDisks(var3);
        BiomeSettings.addPlainVegetation(var3);
        BiomeSettings.addDefaultMushrooms(var3);
        BiomeSettings.addDefaultExtraVegetation(var3, false);
        BiomeSettings.addDripstone(var3);
        return OverworldBiomes.baseBiome(0.8f, 0.4f).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_DRIPSTONE_CAVES)).mobSpawnSettings(var2.build()).generationSettings(var3.build()).build();
    }

    public static BiomeBase deepDark(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        var3.addCarver(WorldGenCarvers.CAVE);
        var3.addCarver(WorldGenCarvers.CAVE_EXTRA_UNDERGROUND);
        var3.addCarver(WorldGenCarvers.CANYON);
        BiomeSettings.addDefaultCrystalFormations(var3);
        BiomeSettings.addDefaultMonsterRoom(var3);
        BiomeSettings.addDefaultUndergroundVariety(var3);
        BiomeSettings.addSurfaceFreezing(var3);
        BiomeSettings.addPlainGrass(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        BiomeSettings.addPlainVegetation(var3);
        BiomeSettings.addDefaultMushrooms(var3);
        BiomeSettings.addDefaultExtraVegetation(var3, false);
        BiomeSettings.addSculk(var3);
        return OverworldBiomes.baseBiome(0.8f, 0.4f).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_DEEP_DARK)).mobSpawnSettings(var2.build()).generationSettings(var3.build()).build();
    }
}

