/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.gametest.framework.GameTestException;
import net.minecraft.gametest.framework.GameTestHarnessAssertion;
import net.minecraft.gametest.framework.GameTestHarnessEvent;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.network.chat.IChatBaseComponent;

public class GameTestHarnessSequence {
    final GameTestHarnessInfo parent;
    private final List<GameTestHarnessEvent> events = Lists.newArrayList();
    private int lastTick;

    GameTestHarnessSequence(GameTestHarnessInfo var0) {
        this.parent = var0;
        this.lastTick = var0.getTick();
    }

    public GameTestHarnessSequence thenWaitUntil(Runnable var0) {
        this.events.add(GameTestHarnessEvent.create(var0));
        return this;
    }

    public GameTestHarnessSequence thenWaitUntil(long var0, Runnable var2) {
        this.events.add(GameTestHarnessEvent.create(var0, var2));
        return this;
    }

    public GameTestHarnessSequence thenIdle(int var0) {
        return this.thenExecuteAfter(var0, () -> {});
    }

    public GameTestHarnessSequence thenExecute(Runnable var0) {
        this.events.add(GameTestHarnessEvent.create(() -> this.executeWithoutFail(var0)));
        return this;
    }

    public GameTestHarnessSequence thenExecuteAfter(int var0, Runnable var1) {
        this.events.add(GameTestHarnessEvent.create(() -> {
            if (this.parent.getTick() < this.lastTick + var0) {
                throw new GameTestHarnessAssertion(IChatBaseComponent.translatable("test.error.sequence.not_completed"), this.parent.getTick());
            }
            this.executeWithoutFail(var1);
        }));
        return this;
    }

    public GameTestHarnessSequence thenExecuteFor(int var0, Runnable var1) {
        this.events.add(GameTestHarnessEvent.create(() -> {
            if (this.parent.getTick() < this.lastTick + var0) {
                this.executeWithoutFail(var1);
                throw new GameTestHarnessAssertion(IChatBaseComponent.translatable("test.error.sequence.not_completed"), this.parent.getTick());
            }
        }));
        return this;
    }

    public void thenSucceed() {
        this.events.add(GameTestHarnessEvent.create(this.parent::succeed));
    }

    public void thenFail(Supplier<GameTestException> var0) {
        this.events.add(GameTestHarnessEvent.create(() -> this.parent.fail((GameTestException)var0.get())));
    }

    public a thenTrigger() {
        a var0 = new a();
        this.events.add(GameTestHarnessEvent.create(() -> var0.trigger(this.parent.getTick())));
        return var0;
    }

    public void tickAndContinue(int var0) {
        try {
            this.tick(var0);
        }
        catch (GameTestHarnessAssertion gameTestHarnessAssertion) {
            // empty catch block
        }
    }

    public void tickAndFailIfNotComplete(int var0) {
        try {
            this.tick(var0);
        }
        catch (GameTestHarnessAssertion var1) {
            this.parent.fail(var1);
        }
    }

    private void executeWithoutFail(Runnable var0) {
        try {
            var0.run();
        }
        catch (GameTestHarnessAssertion var1) {
            this.parent.fail(var1);
        }
    }

    private void tick(int var0) {
        Iterator<GameTestHarnessEvent> var1 = this.events.iterator();
        while (var1.hasNext()) {
            GameTestHarnessEvent var2 = var1.next();
            var2.assertion.run();
            var1.remove();
            int var3 = var0 - this.lastTick;
            int var4 = this.lastTick;
            this.lastTick = var0;
            if (var2.expectedDelay == null || var2.expectedDelay == (long)var3) continue;
            this.parent.fail(new GameTestHarnessAssertion(IChatBaseComponent.translatable("test.error.sequence.invalid_tick", (long)var4 + var2.expectedDelay), var0));
            break;
        }
    }

    public class a {
        private static final int NOT_TRIGGERED = -1;
        private int triggerTime = -1;

        void trigger(int var0) {
            if (this.triggerTime != -1) {
                throw new IllegalStateException("Condition already triggered at " + this.triggerTime);
            }
            this.triggerTime = var0;
        }

        public void assertTriggeredThisTick() {
            int var0 = GameTestHarnessSequence.this.parent.getTick();
            if (this.triggerTime != var0) {
                if (this.triggerTime == -1) {
                    throw new GameTestHarnessAssertion(IChatBaseComponent.translatable("test.error.sequence.condition_not_triggered"), var0);
                }
                throw new GameTestHarnessAssertion(IChatBaseComponent.translatable("test.error.sequence.condition_already_triggered", this.triggerTime), var0);
            }
        }
    }
}

