/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceSelectorArgument;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.FailedTestTracker;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestBatchListener;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.gametest.framework.TestFinder;
import net.minecraft.gametest.framework.TestInstanceFinder;
import net.minecraft.gametest.framework.TestPosFinder;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.ClientboundGameTestHighlightPosPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.apache.commons.lang3.mutable.MutableInt;

public class GameTestHarnessTestCommand {
    public static final int TEST_NEARBY_SEARCH_RADIUS = 15;
    public static final int TEST_FULL_SEARCH_RADIUS = 250;
    public static final int VERIFY_TEST_GRID_AXIS_SIZE = 10;
    public static final int VERIFY_TEST_BATCH_SIZE = 100;
    private static final int DEFAULT_CLEAR_RADIUS = 250;
    private static final int MAX_CLEAR_RADIUS = 1024;
    private static final int TEST_POS_Z_OFFSET_FROM_PLAYER = 3;
    private static final int DEFAULT_X_SIZE = 5;
    private static final int DEFAULT_Y_SIZE = 5;
    private static final int DEFAULT_Z_SIZE = 5;
    private static final SimpleCommandExceptionType CLEAR_NO_TESTS = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.test.clear.error.no_tests"));
    private static final SimpleCommandExceptionType RESET_NO_TESTS = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.test.reset.error.no_tests"));
    private static final SimpleCommandExceptionType TEST_INSTANCE_COULD_NOT_BE_FOUND = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.test.error.test_instance_not_found"));
    private static final SimpleCommandExceptionType NO_STRUCTURES_TO_EXPORT = new SimpleCommandExceptionType((Message)IChatBaseComponent.literal("Could not find any structures to export"));
    private static final SimpleCommandExceptionType NO_TEST_INSTANCES = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.test.error.no_test_instances"));
    private static final Dynamic3CommandExceptionType NO_TEST_CONTAINING = new Dynamic3CommandExceptionType((var0, var1, var2) -> IChatBaseComponent.translatableEscape("commands.test.error.no_test_containing_pos", var0, var1, var2));
    private static final DynamicCommandExceptionType TOO_LARGE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.test.error.too_large", var0));

    private static int reset(TestFinder var0) throws CommandSyntaxException {
        GameTestHarnessTestCommand.stopTests();
        int var12 = GameTestHarnessTestCommand.toGameTestInfos(var0.source(), RetryOptions.noRetries(), var0).map(var1 -> GameTestHarnessTestCommand.resetGameTestInfo(var0.source(), var1)).toList().size();
        if (var12 == 0) {
            throw CLEAR_NO_TESTS.create();
        }
        var0.source().sendSuccess(() -> IChatBaseComponent.translatable("commands.test.reset.success", var12), true);
        return var12;
    }

    private static int clear(TestFinder var0) throws CommandSyntaxException {
        GameTestHarnessTestCommand.stopTests();
        CommandListenerWrapper var12 = var0.source();
        WorldServer var2 = var12.getLevel();
        List var3 = var0.findTestPos().flatMap(var1 -> var2.getBlockEntity((BlockPosition)var1, TileEntityTypes.TEST_INSTANCE_BLOCK).stream()).toList();
        for (TestInstanceBlockEntity var5 : var3) {
            GameTestHarnessStructures.clearSpaceForStructure(var5.getStructureBoundingBox(), var2);
            var5.removeBarriers();
            var2.destroyBlock(var5.getBlockPos(), false);
        }
        if (var3.isEmpty()) {
            throw CLEAR_NO_TESTS.create();
        }
        var12.sendSuccess(() -> IChatBaseComponent.translatable("commands.test.clear.success", var3.size()), true);
        return var3.size();
    }

    private static int export(TestFinder var0) throws CommandSyntaxException {
        CommandListenerWrapper var1 = var0.source();
        WorldServer var2 = var1.getLevel();
        int var3 = 0;
        boolean var4 = true;
        Object var5 = var0.findTestPos().iterator();
        while (var5.hasNext()) {
            BlockPosition var6 = (BlockPosition)var5.next();
            TileEntity tileEntity = var2.getBlockEntity(var6);
            if (tileEntity instanceof TestInstanceBlockEntity) {
                TestInstanceBlockEntity var7 = (TestInstanceBlockEntity)tileEntity;
                if (!var7.exportTest(var1::sendSystemMessage)) {
                    var4 = false;
                }
                ++var3;
                continue;
            }
            throw TEST_INSTANCE_COULD_NOT_BE_FOUND.create();
        }
        if (var3 == 0) {
            throw NO_STRUCTURES_TO_EXPORT.create();
        }
        var5 = "Exported " + var3 + " structures";
        var0.source().sendSuccess(() -> GameTestHarnessTestCommand.a((String)var5), true);
        return var4 ? 0 : 1;
    }

    private static int verify(TestFinder var0) {
        GameTestHarnessTestCommand.stopTests();
        CommandListenerWrapper var1 = var0.source();
        WorldServer var2 = var1.getLevel();
        BlockPosition var3 = GameTestHarnessTestCommand.createTestPositionAround(var1);
        List<GameTestHarnessInfo> var4 = Stream.concat(GameTestHarnessTestCommand.toGameTestInfos(var1, RetryOptions.noRetries(), var0), GameTestHarnessTestCommand.toGameTestInfo(var1, RetryOptions.noRetries(), var0, 0)).toList();
        FailedTestTracker.forgetFailedTests();
        ArrayList<GameTestHarnessBatch> var5 = new ArrayList<GameTestHarnessBatch>();
        for (GameTestHarnessInfo gameTestHarnessInfo : var4) {
            for (EnumBlockRotation var11 : EnumBlockRotation.values()) {
                ArrayList<GameTestHarnessInfo> var12 = new ArrayList<GameTestHarnessInfo>();
                for (int var13 = 0; var13 < 100; ++var13) {
                    GameTestHarnessInfo var14 = new GameTestHarnessInfo(gameTestHarnessInfo.getTestHolder(), var11, var2, new RetryOptions(1, true));
                    var14.setTestBlockPos(gameTestHarnessInfo.getTestBlockPos());
                    var12.add(var14);
                }
                GameTestHarnessBatch var13 = GameTestBatchFactory.toGameTestBatch(var12, gameTestHarnessInfo.getTest().batch(), var11.ordinal());
                var5.add(var13);
            }
        }
        StructureGridSpawner var6 = new StructureGridSpawner(var3, 10, true);
        GameTestHarnessRunner gameTestHarnessRunner = GameTestHarnessRunner.a.fromBatches(var5, var2).batcher(GameTestBatchFactory.fromGameTestInfo(100)).newStructureSpawner(var6).existingStructureSpawner(var6).haltOnError().clearBetweenBatches().build();
        return GameTestHarnessTestCommand.trackAndStartRunner(var1, gameTestHarnessRunner);
    }

    private static int run(TestFinder var0, RetryOptions var1, int var2, int var3) {
        GameTestHarnessTestCommand.stopTests();
        CommandListenerWrapper var4 = var0.source();
        WorldServer var5 = var4.getLevel();
        BlockPosition var6 = GameTestHarnessTestCommand.createTestPositionAround(var4);
        List<GameTestHarnessInfo> var7 = Stream.concat(GameTestHarnessTestCommand.toGameTestInfos(var4, var1, var0), GameTestHarnessTestCommand.toGameTestInfo(var4, var1, var0, var2)).toList();
        if (var7.isEmpty()) {
            var4.sendSuccess(() -> IChatBaseComponent.translatable("commands.test.no_tests"), false);
            return 0;
        }
        FailedTestTracker.forgetFailedTests();
        var4.sendSuccess(() -> IChatBaseComponent.translatable("commands.test.run.running", var7.size()), false);
        GameTestHarnessRunner var8 = GameTestHarnessRunner.a.fromInfo(var7, var5).newStructureSpawner(new StructureGridSpawner(var6, var3, false)).build();
        return GameTestHarnessTestCommand.trackAndStartRunner(var4, var8);
    }

    private static int locate(TestFinder var0) throws CommandSyntaxException {
        var0.source().sendSystemMessage(IChatBaseComponent.translatable("commands.test.locate.started"));
        MutableInt var1 = new MutableInt(0);
        BlockPosition var2 = BlockPosition.containing(var0.source().getPosition());
        var0.findTestPos().forEach(var3 -> {
            Object var5 = var0.source().getLevel().getBlockEntity((BlockPosition)var3);
            if (!(var5 instanceof TestInstanceBlockEntity)) {
                return;
            }
            TestInstanceBlockEntity var4 = (TestInstanceBlockEntity)var5;
            var5 = var4.getRotation().rotate(EnumDirection.NORTH);
            BlockPosition var6 = var4.getBlockPos().relative((EnumDirection)var5, 2);
            int var7 = (int)((EnumDirection)var5).getOpposite().toYRot();
            String var8 = String.format(Locale.ROOT, "/tp @s %d %d %d %d 0", var6.getX(), var6.getY(), var6.getZ(), var7);
            int var9 = var2.getX() - var3.getX();
            int var10 = var2.getZ() - var3.getZ();
            int var11 = MathHelper.floor(MathHelper.sqrt(var9 * var9 + var10 * var10));
            IChatMutableComponent var122 = ChatComponentUtils.wrapInSquareBrackets(IChatBaseComponent.translatable("chat.coordinates", var3.getX(), var3.getY(), var3.getZ())).withStyle(var1 -> var1.withColor(EnumChatFormat.GREEN).withClickEvent(new ChatClickable.SuggestCommand(var8)).withHoverEvent(new ChatHoverable.e(IChatBaseComponent.translatable("chat.coordinates.tooltip"))));
            var0.source().sendSuccess(() -> IChatBaseComponent.translatable("commands.test.locate.found", var122, var11), false);
            var1.increment();
        });
        int var32 = var1.intValue();
        if (var32 == 0) {
            throw NO_TEST_INSTANCES.create();
        }
        var0.source().sendSuccess(() -> IChatBaseComponent.translatable("commands.test.locate.done", var32), true);
        return var32;
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> runWithRetryOptions(ArgumentBuilder<CommandListenerWrapper, ?> var0, InCommandFunction<CommandContext<CommandListenerWrapper>, TestFinder> var12, Function<ArgumentBuilder<CommandListenerWrapper, ?>, ArgumentBuilder<CommandListenerWrapper, ?>> var2) {
        return var0.executes(var1 -> GameTestHarnessTestCommand.run((TestFinder)var12.apply(var1), RetryOptions.noRetries(), 0, 8)).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("numberOfTimes", IntegerArgumentType.integer((int)0)).executes(var1 -> GameTestHarnessTestCommand.run((TestFinder)var12.apply(var1), new RetryOptions(IntegerArgumentType.getInteger((CommandContext)var1, (String)"numberOfTimes"), false), 0, 8))).then(var2.apply(net.minecraft.commands.CommandDispatcher.argument("untilFailed", BoolArgumentType.bool()).executes(var1 -> GameTestHarnessTestCommand.run((TestFinder)var12.apply(var1), new RetryOptions(IntegerArgumentType.getInteger((CommandContext)var1, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)var1, (String)"untilFailed")), 0, 8)))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> runWithRetryOptions(ArgumentBuilder<CommandListenerWrapper, ?> var02, InCommandFunction<CommandContext<CommandListenerWrapper>, TestFinder> var1) {
        return GameTestHarnessTestCommand.runWithRetryOptions(var02, var1, var0 -> var0);
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> runWithRetryOptionsAndBuildInfo(ArgumentBuilder<CommandListenerWrapper, ?> var0, InCommandFunction<CommandContext<CommandListenerWrapper>, TestFinder> var1) {
        return GameTestHarnessTestCommand.runWithRetryOptions(var0, var1, var12 -> var12.then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("rotationSteps", IntegerArgumentType.integer()).executes(var1 -> GameTestHarnessTestCommand.run((TestFinder)var1.apply(var1), new RetryOptions(IntegerArgumentType.getInteger((CommandContext)var1, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)var1, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)var1, (String)"rotationSteps"), 8))).then(net.minecraft.commands.CommandDispatcher.argument("testsPerRow", IntegerArgumentType.integer()).executes(var1 -> GameTestHarnessTestCommand.run((TestFinder)var1.apply(var1), new RetryOptions(IntegerArgumentType.getInteger((CommandContext)var1, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)var1, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)var1, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)var1, (String)"testsPerRow"))))));
    }

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        ArgumentBuilder<CommandListenerWrapper, ?> var2 = GameTestHarnessTestCommand.runWithRetryOptionsAndBuildInfo(net.minecraft.commands.CommandDispatcher.argument("onlyRequiredTests", BoolArgumentType.bool()), var0 -> TestFinder.builder().failedTests((CommandContext<CommandListenerWrapper>)var0, BoolArgumentType.getBool((CommandContext)var0, (String)"onlyRequiredTests")));
        LiteralArgumentBuilder var3 = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("test").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).then(net.minecraft.commands.CommandDispatcher.literal("run").then(GameTestHarnessTestCommand.runWithRetryOptionsAndBuildInfo(net.minecraft.commands.CommandDispatcher.argument("tests", ResourceSelectorArgument.resourceSelector(var1, Registries.TEST_INSTANCE)), var0 -> TestFinder.builder().byResourceSelection((CommandContext<CommandListenerWrapper>)var0, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandListenerWrapper>)var0, "tests")))))).then(net.minecraft.commands.CommandDispatcher.literal("runmultiple").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("tests", ResourceSelectorArgument.resourceSelector(var1, Registries.TEST_INSTANCE)).executes(var0 -> GameTestHarnessTestCommand.run(TestFinder.builder().byResourceSelection((CommandContext<CommandListenerWrapper>)var0, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandListenerWrapper>)var0, "tests")), RetryOptions.noRetries(), 0, 8))).then(net.minecraft.commands.CommandDispatcher.argument("amount", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.run(TestFinder.builder().createMultipleCopies(IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount")).byResourceSelection((CommandContext<CommandListenerWrapper>)var0, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandListenerWrapper>)var0, "tests")), RetryOptions.noRetries(), 0, 8)))))).then(GameTestHarnessTestCommand.runWithRetryOptions(net.minecraft.commands.CommandDispatcher.literal("runthese"), TestFinder.builder()::allNearby))).then(GameTestHarnessTestCommand.runWithRetryOptions(net.minecraft.commands.CommandDispatcher.literal("runclosest"), TestFinder.builder()::nearest))).then(GameTestHarnessTestCommand.runWithRetryOptions(net.minecraft.commands.CommandDispatcher.literal("runthat"), TestFinder.builder()::lookedAt))).then(GameTestHarnessTestCommand.runWithRetryOptionsAndBuildInfo(net.minecraft.commands.CommandDispatcher.literal("runfailed").then(var2), TestFinder.builder()::failedTests))).then(net.minecraft.commands.CommandDispatcher.literal("verify").then(net.minecraft.commands.CommandDispatcher.argument("tests", ResourceSelectorArgument.resourceSelector(var1, Registries.TEST_INSTANCE)).executes(var0 -> GameTestHarnessTestCommand.verify(TestFinder.builder().byResourceSelection((CommandContext<CommandListenerWrapper>)var0, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandListenerWrapper>)var0, "tests"))))))).then(net.minecraft.commands.CommandDispatcher.literal("locate").then(net.minecraft.commands.CommandDispatcher.argument("tests", ResourceSelectorArgument.resourceSelector(var1, Registries.TEST_INSTANCE)).executes(var0 -> GameTestHarnessTestCommand.locate(TestFinder.builder().byResourceSelection((CommandContext<CommandListenerWrapper>)var0, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandListenerWrapper>)var0, "tests"))))))).then(net.minecraft.commands.CommandDispatcher.literal("resetclosest").executes(var0 -> GameTestHarnessTestCommand.reset(TestFinder.builder().nearest((CommandContext<CommandListenerWrapper>)var0))))).then(net.minecraft.commands.CommandDispatcher.literal("resetthese").executes(var0 -> GameTestHarnessTestCommand.reset(TestFinder.builder().allNearby((CommandContext<CommandListenerWrapper>)var0))))).then(net.minecraft.commands.CommandDispatcher.literal("resetthat").executes(var0 -> GameTestHarnessTestCommand.reset(TestFinder.builder().lookedAt((CommandContext<CommandListenerWrapper>)var0))))).then(net.minecraft.commands.CommandDispatcher.literal("clearthat").executes(var0 -> GameTestHarnessTestCommand.clear(TestFinder.builder().lookedAt((CommandContext<CommandListenerWrapper>)var0))))).then(net.minecraft.commands.CommandDispatcher.literal("clearthese").executes(var0 -> GameTestHarnessTestCommand.clear(TestFinder.builder().allNearby((CommandContext<CommandListenerWrapper>)var0))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("clearall").executes(var0 -> GameTestHarnessTestCommand.clear(TestFinder.builder().radius((CommandContext<CommandListenerWrapper>)var0, 250)))).then(net.minecraft.commands.CommandDispatcher.argument("radius", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.clear(TestFinder.builder().radius((CommandContext<CommandListenerWrapper>)var0, MathHelper.clamp(IntegerArgumentType.getInteger((CommandContext)var0, (String)"radius"), 0, 1024))))))).then(net.minecraft.commands.CommandDispatcher.literal("stop").executes(var0 -> GameTestHarnessTestCommand.stopTests()))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("pos").executes(var0 -> GameTestHarnessTestCommand.showPos((CommandListenerWrapper)var0.getSource(), "pos"))).then(net.minecraft.commands.CommandDispatcher.argument("var", StringArgumentType.word()).executes(var0 -> GameTestHarnessTestCommand.showPos((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"var")))))).then(net.minecraft.commands.CommandDispatcher.literal("create").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("id", ArgumentMinecraftKeyRegistered.id()).suggests(GameTestHarnessTestCommand::suggestTestFunction).executes(var0 -> GameTestHarnessTestCommand.createNewStructure((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "id"), 5, 5, 5))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("width", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.createNewStructure((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "id"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width")))).then(net.minecraft.commands.CommandDispatcher.argument("height", IntegerArgumentType.integer()).then(net.minecraft.commands.CommandDispatcher.argument("depth", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.createNewStructure((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "id"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"height"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"depth"))))))));
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            var3 = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)var3.then(net.minecraft.commands.CommandDispatcher.literal("export").then(net.minecraft.commands.CommandDispatcher.argument("test", ResourceArgument.resource(var1, Registries.TEST_INSTANCE)).executes(var0 -> GameTestHarnessTestCommand.exportTestStructure((CommandListenerWrapper)var0.getSource(), ResourceArgument.getResource((CommandContext<CommandListenerWrapper>)var0, "test", Registries.TEST_INSTANCE)))))).then(net.minecraft.commands.CommandDispatcher.literal("exportclosest").executes(var0 -> GameTestHarnessTestCommand.export(TestFinder.builder().nearest((CommandContext<CommandListenerWrapper>)var0))))).then(net.minecraft.commands.CommandDispatcher.literal("exportthese").executes(var0 -> GameTestHarnessTestCommand.export(TestFinder.builder().allNearby((CommandContext<CommandListenerWrapper>)var0))))).then(net.minecraft.commands.CommandDispatcher.literal("exportthat").executes(var0 -> GameTestHarnessTestCommand.export(TestFinder.builder().lookedAt((CommandContext<CommandListenerWrapper>)var0))));
        }
        var02.register(var3);
    }

    public static CompletableFuture<Suggestions> suggestTestFunction(CommandContext<CommandListenerWrapper> var0, SuggestionsBuilder var1) {
        Stream<String> var2 = ((CommandListenerWrapper)var0.getSource()).registryAccess().lookupOrThrow(Registries.TEST_FUNCTION).listElements().map(Holder::getRegisteredName);
        return ICompletionProvider.suggest(var2, var1);
    }

    private static int resetGameTestInfo(CommandListenerWrapper var0, GameTestHarnessInfo var1) {
        TestInstanceBlockEntity var2 = var1.getTestInstanceBlockEntity();
        var2.resetTest(var0::sendSystemMessage);
        return 1;
    }

    private static Stream<GameTestHarnessInfo> toGameTestInfos(CommandListenerWrapper var0, RetryOptions var1, TestPosFinder var22) {
        return var22.findTestPos().map(var2 -> GameTestHarnessTestCommand.createGameTestInfo(var2, var0, var1)).flatMap(Optional::stream);
    }

    private static Stream<GameTestHarnessInfo> toGameTestInfo(CommandListenerWrapper var0, RetryOptions var12, TestInstanceFinder var2, int var32) {
        return var2.findTests().filter(var1 -> GameTestHarnessTestCommand.verifyStructureExists(var0, ((GameTestInstance)var1.value()).structure())).map(var3 -> new GameTestHarnessInfo((Holder.c<GameTestInstance>)var3, GameTestHarnessStructures.getRotationForRotationSteps(var32), var0.getLevel(), var12));
    }

    private static Optional<GameTestHarnessInfo> createGameTestInfo(BlockPosition var0, CommandListenerWrapper var1, RetryOptions var2) {
        WorldServer var3 = var1.getLevel();
        TileEntity tileEntity = var3.getBlockEntity(var0);
        if (!(tileEntity instanceof TestInstanceBlockEntity)) {
            var1.sendFailure(IChatBaseComponent.translatable("commands.test.error.test_instance_not_found.position", var0.getX(), var0.getY(), var0.getZ()));
            return Optional.empty();
        }
        TestInstanceBlockEntity var4 = (TestInstanceBlockEntity)tileEntity;
        Optional var5 = var4.test().flatMap(((IRegistry)var1.registryAccess().lookupOrThrow(Registries.TEST_INSTANCE))::get);
        if (var5.isEmpty()) {
            var1.sendFailure(IChatBaseComponent.translatable("commands.test.error.non_existant_test", var4.getTestName()));
            return Optional.empty();
        }
        Holder.c var6 = (Holder.c)var5.get();
        GameTestHarnessInfo var7 = new GameTestHarnessInfo(var6, var4.getRotation(), var3, var2);
        var7.setTestBlockPos(var0);
        if (!GameTestHarnessTestCommand.verifyStructureExists(var1, var7.getStructure())) {
            return Optional.empty();
        }
        return Optional.of(var7);
    }

    private static int createNewStructure(CommandListenerWrapper var0, MinecraftKey var12, int var2, int var3, int var4) throws CommandSyntaxException {
        if (var2 > 48 || var3 > 48 || var4 > 48) {
            throw TOO_LARGE.create((Object)48);
        }
        WorldServer var5 = var0.getLevel();
        BlockPosition var6 = GameTestHarnessTestCommand.createTestPositionAround(var0);
        TestInstanceBlockEntity var7 = GameTestHarnessStructures.createNewEmptyTest(var12, var6, new BaseBlockPosition(var2, var3, var4), EnumBlockRotation.NONE, var5);
        BlockPosition var8 = var7.getStructurePos();
        BlockPosition var9 = var8.offset(var2 - 1, 0, var4 - 1);
        BlockPosition.betweenClosedStream(var8, var9).forEach(var1 -> var5.setBlockAndUpdate((BlockPosition)var1, Blocks.BEDROCK.defaultBlockState()));
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.test.create.success", var7.getTestName()), true);
        return 1;
    }

    private static int showPos(CommandListenerWrapper var0, String var1) throws CommandSyntaxException {
        WorldServer var5;
        EntityPlayer var2 = var0.getPlayerOrException();
        MovingObjectPositionBlock var3 = (MovingObjectPositionBlock)var2.pick(10.0, 1.0f, false);
        BlockPosition var4 = var3.getBlockPos();
        Optional<BlockPosition> var6 = GameTestHarnessStructures.findTestContainingPos(var4, 15, var5 = var0.getLevel());
        if (var6.isEmpty()) {
            var6 = GameTestHarnessStructures.findTestContainingPos(var4, 250, var5);
        }
        if (var6.isEmpty()) {
            throw NO_TEST_CONTAINING.create((Object)var4.getX(), (Object)var4.getY(), (Object)var4.getZ());
        }
        TileEntity tileEntity = var5.getBlockEntity(var6.get());
        if (!(tileEntity instanceof TestInstanceBlockEntity)) {
            throw TEST_INSTANCE_COULD_NOT_BE_FOUND.create();
        }
        TestInstanceBlockEntity var7 = (TestInstanceBlockEntity)tileEntity;
        BlockPosition var8 = var7.getStructurePos();
        BlockPosition var9 = var4.subtract(var8);
        String var10 = var9.getX() + ", " + var9.getY() + ", " + var9.getZ();
        String var11 = var7.getTestName().getString();
        IChatMutableComponent var12 = IChatBaseComponent.translatable("commands.test.coordinates", var9.getX(), var9.getY(), var9.getZ()).setStyle(ChatModifier.EMPTY.withBold(true).withColor(EnumChatFormat.GREEN).withHoverEvent(new ChatHoverable.e(IChatBaseComponent.translatable("commands.test.coordinates.copy"))).withClickEvent(new ChatClickable.CopyToClipboard("final BlockPos " + var1 + " = new BlockPos(" + var10 + ");")));
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.test.relative_position", var11, var12), false);
        var2.connection.send(new ClientboundGameTestHighlightPosPacket(var4, var9));
        return 1;
    }

    private static int stopTests() {
        GameTestHarnessTicker.SINGLETON.clear();
        return 1;
    }

    public static int trackAndStartRunner(CommandListenerWrapper var02, GameTestHarnessRunner var1) {
        var1.addListener(new a(var02));
        GameTestHarnessCollector var2 = new GameTestHarnessCollector(var1.getTestInfos());
        var2.addListener(new b(var02, var2));
        var2.addFailureListener(var0 -> FailedTestTracker.rememberFailedTest(var0.getTestHolder()));
        var1.start();
        return 1;
    }

    private static int exportTestStructure(CommandListenerWrapper var0, Holder<GameTestInstance> var1) {
        if (!TestInstanceBlockEntity.export(var0.getLevel(), var1.value().structure(), var0::sendSystemMessage)) {
            return 0;
        }
        return 1;
    }

    private static boolean verifyStructureExists(CommandListenerWrapper var0, MinecraftKey var1) {
        if (var0.getLevel().getStructureManager().get(var1).isEmpty()) {
            var0.sendFailure(IChatBaseComponent.translatable("commands.test.error.structure_not_found", IChatBaseComponent.translationArg(var1)));
            return false;
        }
        return true;
    }

    private static BlockPosition createTestPositionAround(CommandListenerWrapper var0) {
        BlockPosition var1 = BlockPosition.containing(var0.getPosition());
        int var2 = var0.getLevel().getHeightmapPos(HeightMap.Type.WORLD_SURFACE, var1).getY();
        return new BlockPosition(var1.getX(), var2, var1.getZ() + 3);
    }

    private static /* synthetic */ IChatBaseComponent a(String var0) {
        return IChatBaseComponent.literal(var0);
    }

    record a(CommandListenerWrapper source) implements GameTestBatchListener
    {
        @Override
        public void testBatchStarting(GameTestHarnessBatch var0) {
            this.source.sendSuccess(() -> IChatBaseComponent.translatable("commands.test.batch.starting", var0.environment().getRegisteredName(), var0.index()), true);
        }

        @Override
        public void testBatchFinished(GameTestHarnessBatch var0) {
        }
    }

    public record b(CommandListenerWrapper source, GameTestHarnessCollector tracker) implements GameTestHarnessListener
    {
        @Override
        public void testStructureLoaded(GameTestHarnessInfo var0) {
        }

        @Override
        public void testPassed(GameTestHarnessInfo var0, GameTestHarnessRunner var1) {
            this.showTestSummaryIfAllDone();
        }

        @Override
        public void testFailed(GameTestHarnessInfo var0, GameTestHarnessRunner var1) {
            this.showTestSummaryIfAllDone();
        }

        @Override
        public void testAddedForRerun(GameTestHarnessInfo var0, GameTestHarnessInfo var1, GameTestHarnessRunner var2) {
            this.tracker.addTestToTrack(var1);
        }

        private void showTestSummaryIfAllDone() {
            if (this.tracker.isDone()) {
                this.source.sendSuccess(() -> IChatBaseComponent.translatable("commands.test.summary", this.tracker.getTotalCount()).withStyle(EnumChatFormat.WHITE), true);
                if (this.tracker.hasFailedRequired()) {
                    this.source.sendFailure(IChatBaseComponent.translatable("commands.test.summary.failed", this.tracker.getFailedRequiredCount()));
                } else {
                    this.source.sendSuccess(() -> IChatBaseComponent.translatable("commands.test.summary.all_required_passed").withStyle(EnumChatFormat.GREEN), true);
                }
                if (this.tracker.hasFailedOptional()) {
                    this.source.sendSystemMessage(IChatBaseComponent.translatable("commands.test.summary.optional_failed", this.tracker.getFailedOptionalCount()));
                }
            }
        }
    }
}

