/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public final class NBTTagByteArray
implements NBTList {
    private static final int SELF_SIZE_IN_BYTES = 24;
    public static final NBTTagType<NBTTagByteArray> TYPE = new NBTTagType.b<NBTTagByteArray>(){

        @Override
        public NBTTagByteArray load(DataInput var0, NBTReadLimiter var1) throws IOException {
            return new NBTTagByteArray(1.readAccounted(var0, var1));
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            return var1.visit(1.readAccounted(var0, var2));
        }

        private static byte[] readAccounted(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.accountBytes(24L);
            int var2 = var0.readInt();
            var1.accountBytes(1L, var2);
            byte[] var3 = new byte[var2];
            var0.readFully(var3);
            return var3;
        }

        @Override
        public void skip(DataInput var0, NBTReadLimiter var1) throws IOException {
            var0.skipBytes(var0.readInt() * 1);
        }

        @Override
        public String getName() {
            return "BYTE[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Byte_Array";
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, nBTReadLimiter);
        }
    };
    private byte[] data;

    public NBTTagByteArray(byte[] var0) {
        this.data = var0;
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeInt(this.data.length);
        var0.write(this.data);
    }

    @Override
    public int sizeInBytes() {
        return 24 + 1 * this.data.length;
    }

    @Override
    public byte getId() {
        return 7;
    }

    public NBTTagType<NBTTagByteArray> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitByteArray(this);
        return var0.build();
    }

    @Override
    public NBTBase copy() {
        byte[] var0 = new byte[this.data.length];
        System.arraycopy(this.data, 0, var0, 0, this.data.length);
        return new NBTTagByteArray(var0);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagByteArray && Arrays.equals(this.data, ((NBTTagByteArray)var0).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitByteArray(this);
    }

    public byte[] getAsByteArray() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public NBTTagByte get(int var0) {
        return NBTTagByte.valueOf(this.data[var0]);
    }

    @Override
    public boolean setTag(int var0, NBTBase var1) {
        if (var1 instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)var1;
            this.data[var0] = var2.byteValue();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int var0, NBTBase var1) {
        if (var1 instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)var1;
            this.data = ArrayUtils.add((byte[])this.data, (int)var0, (byte)var2.byteValue());
            return true;
        }
        return false;
    }

    @Override
    public NBTTagByte remove(int var0) {
        byte var1 = this.data[var0];
        this.data = ArrayUtils.remove((byte[])this.data, (int)var0);
        return NBTTagByte.valueOf(var1);
    }

    @Override
    public void clear() {
        this.data = new byte[0];
    }

    @Override
    public Optional<byte[]> asByteArray() {
        return Optional.of(this.data);
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.data);
    }

    @Override
    public /* synthetic */ NBTBase get(int n2) {
        return this.get(n2);
    }

    @Override
    public /* synthetic */ NBTBase remove(int n2) {
        return this.remove(n2);
    }
}

