/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.parsing.packrat.DelayedException;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.SuggestionSupplier;
import org.jspecify.annotations.Nullable;

public class SnbtOperations {
    static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_STRING_UUID = DelayedException.create(new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("snbt.parser.expected_string_uuid")));
    static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_NUMBER_OR_BOOLEAN = DelayedException.create(new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("snbt.parser.expected_number_or_boolean")));
    public static final String BUILTIN_TRUE = "true";
    public static final String BUILTIN_FALSE = "false";
    public static final Map<a, b> BUILTIN_OPERATIONS = Map.of(new a("bool", 1), new b(){

        @Override
        public <T> T run(DynamicOps<T> var0, List<T> var1, ParseState<StringReader> var2) {
            Boolean var3 = 1.convert(var0, var1.getFirst());
            if (var3 == null) {
                var2.errorCollector().store(var2.mark(), ERROR_EXPECTED_NUMBER_OR_BOOLEAN);
                return null;
            }
            return (T)var0.createBoolean(var3.booleanValue());
        }

        private static <T> @Nullable Boolean convert(DynamicOps<T> var0, T var1) {
            Optional var2 = var0.getBooleanValue(var1).result();
            if (var2.isPresent()) {
                return (Boolean)var2.get();
            }
            Optional var3 = var0.getNumberValue(var1).result();
            if (var3.isPresent()) {
                return ((Number)var3.get()).doubleValue() != 0.0;
            }
            return null;
        }
    }, new a("uuid", 1), new b(){

        @Override
        public <T> T run(DynamicOps<T> var0, List<T> var1, ParseState<StringReader> var2) {
            UUID var4;
            Optional var3 = var0.getStringValue(var1.getFirst()).result();
            if (var3.isEmpty()) {
                var2.errorCollector().store(var2.mark(), ERROR_EXPECTED_STRING_UUID);
                return null;
            }
            try {
                var4 = UUID.fromString((String)var3.get());
            }
            catch (IllegalArgumentException var5) {
                var2.errorCollector().store(var2.mark(), ERROR_EXPECTED_STRING_UUID);
                return null;
            }
            return (T)var0.createIntList(IntStream.of(UUIDUtil.uuidToIntArray(var4)));
        }
    });
    public static final SuggestionSupplier<StringReader> BUILTIN_IDS = new SuggestionSupplier<StringReader>(){
        private final Set<String> keys = Stream.concat(Stream.of("false", "true"), BUILTIN_OPERATIONS.keySet().stream().map(a::id)).collect(Collectors.toSet());

        @Override
        public Stream<String> possibleValues(ParseState<StringReader> var0) {
            return this.keys.stream();
        }
    };

    public record a(String id, int argCount) {
        @Override
        public String toString() {
            return this.id + "/" + this.argCount;
        }
    }

    public static interface b {
        public <T> @Nullable T run(DynamicOps<T> var1, List<T> var2, ParseState<StringReader> var3);
    }
}

