/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import javax.crypto.Cipher;
import net.minecraft.SharedConstants;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.LocalFrameDecoder;
import net.minecraft.network.LocalFrameEncoder;
import net.minecraft.network.MonitoredLocalFrameDecoder;
import net.minecraft.network.PacketBundlePacker;
import net.minecraft.network.PacketBundleUnpacker;
import net.minecraft.network.PacketCompressor;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketDecompressor;
import net.minecraft.network.PacketDecrypter;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketEncrypter;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketPrepender;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.PacketSplitter;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.UnconfiguredPipelineHandler;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.HandshakeProtocols;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.network.protocol.status.PacketStatusOutListener;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.network.EventLoopGroupHolder;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.debugchart.LocalSampleLogger;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class NetworkManager
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float AVERAGE_PACKETS_SMOOTHING = 0.75f;
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Marker ROOT_MARKER = MarkerFactory.getMarker((String)"NETWORK");
    public static final Marker PACKET_MARKER = SystemUtils.make(MarkerFactory.getMarker((String)"NETWORK_PACKETS"), var0 -> var0.add(ROOT_MARKER));
    public static final Marker PACKET_RECEIVED_MARKER = SystemUtils.make(MarkerFactory.getMarker((String)"PACKET_RECEIVED"), var0 -> var0.add(PACKET_MARKER));
    public static final Marker PACKET_SENT_MARKER = SystemUtils.make(MarkerFactory.getMarker((String)"PACKET_SENT"), var0 -> var0.add(PACKET_MARKER));
    private static final ProtocolInfo<PacketHandshakingInListener> INITIAL_PROTOCOL = HandshakeProtocols.SERVERBOUND;
    private final EnumProtocolDirection receiving;
    private volatile boolean sendLoginDisconnect = true;
    private final Queue<Consumer<NetworkManager>> pendingActions = Queues.newConcurrentLinkedQueue();
    public Channel channel;
    public SocketAddress address;
    private volatile @Nullable PacketListener disconnectListener;
    private volatile @Nullable PacketListener packetListener;
    private @Nullable DisconnectionDetails disconnectionDetails;
    private boolean encrypted;
    private boolean disconnectionHandled;
    private int receivedPackets;
    private int sentPackets;
    private float averageReceivedPackets;
    private float averageSentPackets;
    private int tickCount;
    private boolean handlingFault;
    private volatile @Nullable DisconnectionDetails delayedDisconnect;
    @Nullable BandwidthDebugMonitor bandwidthDebugMonitor;

    public NetworkManager(EnumProtocolDirection var0) {
        this.receiving = var0;
    }

    public void channelActive(ChannelHandlerContext var0) throws Exception {
        super.channelActive(var0);
        this.channel = var0.channel();
        this.address = this.channel.remoteAddress();
        if (this.delayedDisconnect != null) {
            this.disconnect(this.delayedDisconnect);
        }
    }

    public void channelInactive(ChannelHandlerContext var0) {
        this.disconnect(IChatBaseComponent.translatable("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext var0, Throwable var1) {
        if (var1 instanceof SkipEncodeException) {
            LOGGER.debug("Skipping packet due to errors", var1.getCause());
            return;
        }
        boolean var2 = !this.handlingFault;
        this.handlingFault = true;
        if (!this.channel.isOpen()) {
            return;
        }
        if (var1 instanceof TimeoutException) {
            LOGGER.debug("Timeout", var1);
            this.disconnect(IChatBaseComponent.translatable("disconnect.timeout"));
        } else {
            IChatMutableComponent var3 = IChatBaseComponent.translatable("disconnect.genericReason", "Internal Exception: " + String.valueOf(var1));
            PacketListener var5 = this.packetListener;
            DisconnectionDetails var4 = var5 != null ? var5.createDisconnectionInfo(var3, var1) : new DisconnectionDetails(var3);
            if (var2) {
                LOGGER.debug("Failed to sent packet", var1);
                if (this.getSending() == EnumProtocolDirection.CLIENTBOUND) {
                    Record var6 = this.sendLoginDisconnect ? new PacketLoginOutDisconnect(var3) : new ClientboundDisconnectPacket(var3);
                    this.send((Packet<?>)((Object)var6), PacketSendListener.thenRun(() -> this.disconnect(var4)));
                } else {
                    this.disconnect(var4);
                }
                this.setReadOnly();
            } else {
                LOGGER.debug("Double fault", var1);
                this.disconnect(var4);
            }
        }
    }

    protected void channelRead0(ChannelHandlerContext var0, Packet<?> var1) {
        if (!this.channel.isOpen()) {
            return;
        }
        PacketListener var2 = this.packetListener;
        if (var2 == null) {
            throw new IllegalStateException("Received a packet before the packet listener was initialized");
        }
        if (var2.shouldHandleMessage(var1)) {
            try {
                NetworkManager.genericsFtw(var1, var2);
            }
            catch (CancelledPacketHandleException cancelledPacketHandleException) {
            }
            catch (RejectedExecutionException var3) {
                this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.server_shutdown"));
            }
            catch (ClassCastException var3) {
                LOGGER.error("Received {} that couldn't be processed", var1.getClass(), (Object)var3);
                this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_packet"));
            }
            ++this.receivedPackets;
        }
    }

    private static <T extends PacketListener> void genericsFtw(Packet<T> var0, PacketListener var1) {
        var0.handle(var1);
    }

    private void validateListener(ProtocolInfo<?> var0, PacketListener var1) {
        Objects.requireNonNull(var1, "packetListener");
        EnumProtocolDirection var2 = var1.flow();
        if (var2 != this.receiving) {
            throw new IllegalStateException("Trying to set listener for wrong side: connection is " + String.valueOf((Object)this.receiving) + ", but listener is " + String.valueOf((Object)var2));
        }
        EnumProtocol var3 = var1.protocol();
        if (var0.id() != var3) {
            throw new IllegalStateException("Listener protocol (" + String.valueOf((Object)var3) + ") does not match requested one " + String.valueOf(var0));
        }
    }

    private static void syncAfterConfigurationChange(ChannelFuture var0) {
        try {
            var0.syncUninterruptibly();
        }
        catch (Exception var1) {
            if (var1 instanceof ClosedChannelException) {
                LOGGER.info("Connection closed during protocol change");
                return;
            }
            throw var1;
        }
    }

    public <T extends PacketListener> void setupInboundProtocol(ProtocolInfo<T> var0, T var12) {
        this.validateListener(var0, var12);
        if (var0.flow() != this.getReceiving()) {
            throw new IllegalStateException("Invalid inbound protocol: " + String.valueOf((Object)var0.id()));
        }
        this.packetListener = var12;
        this.disconnectListener = null;
        UnconfiguredPipelineHandler.b var2 = UnconfiguredPipelineHandler.setupInboundProtocol(var0);
        BundlerInfo var3 = var0.bundlerInfo();
        if (var3 != null) {
            PacketBundlePacker var4 = new PacketBundlePacker(var3);
            var2 = var2.andThen(var1 -> var1.pipeline().addAfter("decoder", "bundler", (ChannelHandler)var4));
        }
        NetworkManager.syncAfterConfigurationChange(this.channel.writeAndFlush((Object)var2));
    }

    public void setupOutboundProtocol(ProtocolInfo<?> var0) {
        if (var0.flow() != this.getSending()) {
            throw new IllegalStateException("Invalid outbound protocol: " + String.valueOf((Object)var0.id()));
        }
        UnconfiguredPipelineHandler.d var12 = UnconfiguredPipelineHandler.setupOutboundProtocol(var0);
        BundlerInfo var2 = var0.bundlerInfo();
        if (var2 != null) {
            PacketBundleUnpacker var3 = new PacketBundleUnpacker(var2);
            var12 = var12.andThen(var1 -> var1.pipeline().addAfter("encoder", "unbundler", (ChannelHandler)var3));
        }
        boolean var3 = var0.id() == EnumProtocol.LOGIN;
        NetworkManager.syncAfterConfigurationChange(this.channel.writeAndFlush((Object)var12.andThen(var1 -> {
            this.sendLoginDisconnect = var3;
        })));
    }

    public void setListenerForServerboundHandshake(PacketListener var0) {
        if (this.packetListener != null) {
            throw new IllegalStateException("Listener already set");
        }
        if (this.receiving != EnumProtocolDirection.SERVERBOUND || var0.flow() != EnumProtocolDirection.SERVERBOUND || var0.protocol() != INITIAL_PROTOCOL.id()) {
            throw new IllegalStateException("Invalid initial listener");
        }
        this.packetListener = var0;
    }

    public void initiateServerboundStatusConnection(String var0, int var1, PacketStatusOutListener var2) {
        this.initiateServerboundConnection(var0, var1, StatusProtocols.SERVERBOUND, StatusProtocols.CLIENTBOUND, var2, ClientIntent.STATUS);
    }

    public void initiateServerboundPlayConnection(String var0, int var1, PacketLoginOutListener var2) {
        this.initiateServerboundConnection(var0, var1, LoginProtocols.SERVERBOUND, LoginProtocols.CLIENTBOUND, var2, ClientIntent.LOGIN);
    }

    public <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void initiateServerboundPlayConnection(String var0, int var1, ProtocolInfo<S> var2, ProtocolInfo<C> var3, C var4, boolean var5) {
        this.initiateServerboundConnection(var0, var1, var2, var3, var4, var5 ? ClientIntent.TRANSFER : ClientIntent.LOGIN);
    }

    private <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void initiateServerboundConnection(String var0, int var1, ProtocolInfo<S> var2, ProtocolInfo<C> var3, C var4, ClientIntent var5) {
        if (var2.id() != var3.id()) {
            throw new IllegalStateException("Mismatched initial protocols");
        }
        this.disconnectListener = var4;
        this.runOnceConnected(var6 -> {
            this.setupInboundProtocol(var3, var4);
            var6.sendPacket(new PacketHandshakingInSetProtocol(SharedConstants.getCurrentVersion().protocolVersion(), var0, var1, var5), null, true);
            this.setupOutboundProtocol(var2);
        });
    }

    public void send(Packet<?> var0) {
        this.send(var0, null);
    }

    public void send(Packet<?> var0, @Nullable ChannelFutureListener var1) {
        this.send(var0, var1, true);
    }

    public void send(Packet<?> var0, @Nullable ChannelFutureListener var1, boolean var2) {
        if (this.isConnected()) {
            this.flushQueue();
            this.sendPacket(var0, var1, var2);
        } else {
            this.pendingActions.add(var3 -> var3.sendPacket(var0, var1, var2));
        }
    }

    public void runOnceConnected(Consumer<NetworkManager> var0) {
        if (this.isConnected()) {
            this.flushQueue();
            var0.accept(this);
        } else {
            this.pendingActions.add(var0);
        }
    }

    private void sendPacket(Packet<?> var0, @Nullable ChannelFutureListener var1, boolean var2) {
        ++this.sentPackets;
        if (this.channel.eventLoop().inEventLoop()) {
            this.doSendPacket(var0, var1, var2);
        } else {
            this.channel.eventLoop().execute(() -> this.doSendPacket(var0, var1, var2));
        }
    }

    private void doSendPacket(Packet<?> var0, @Nullable ChannelFutureListener var1, boolean var2) {
        if (var1 != null) {
            ChannelFuture var3 = var2 ? this.channel.writeAndFlush(var0) : this.channel.write(var0);
            var3.addListener((GenericFutureListener)var1);
        } else if (var2) {
            this.channel.writeAndFlush(var0, this.channel.voidPromise());
        } else {
            this.channel.write(var0, this.channel.voidPromise());
        }
    }

    public void flushChannel() {
        if (this.isConnected()) {
            this.flush();
        } else {
            this.pendingActions.add(NetworkManager::flush);
        }
    }

    private void flush() {
        if (this.channel.eventLoop().inEventLoop()) {
            this.channel.flush();
        } else {
            this.channel.eventLoop().execute(() -> this.channel.flush());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushQueue() {
        if (this.channel == null || !this.channel.isOpen()) {
            return;
        }
        Queue<Consumer<NetworkManager>> queue = this.pendingActions;
        synchronized (queue) {
            Consumer<NetworkManager> var1;
            while ((var1 = this.pendingActions.poll()) != null) {
                var1.accept(this);
            }
        }
    }

    public void tick() {
        this.flushQueue();
        PacketListener packetListener = this.packetListener;
        if (packetListener instanceof TickablePacketListener) {
            TickablePacketListener var0 = (TickablePacketListener)packetListener;
            var0.tick();
        }
        if (!this.isConnected() && !this.disconnectionHandled) {
            this.handleDisconnection();
        }
        if (this.channel != null) {
            this.channel.flush();
        }
        if (this.tickCount++ % 20 == 0) {
            this.tickSecond();
        }
        if (this.bandwidthDebugMonitor != null) {
            this.bandwidthDebugMonitor.tick();
        }
    }

    protected void tickSecond() {
        this.averageSentPackets = MathHelper.lerp(0.75f, this.sentPackets, this.averageSentPackets);
        this.averageReceivedPackets = MathHelper.lerp(0.75f, this.receivedPackets, this.averageReceivedPackets);
        this.sentPackets = 0;
        this.receivedPackets = 0;
    }

    public SocketAddress getRemoteAddress() {
        return this.address;
    }

    public String getLoggableAddress(boolean var0) {
        if (this.address == null) {
            return "local";
        }
        if (var0) {
            return this.address.toString();
        }
        return "IP hidden";
    }

    public void disconnect(IChatBaseComponent var0) {
        this.disconnect(new DisconnectionDetails(var0));
    }

    public void disconnect(DisconnectionDetails var0) {
        if (this.channel == null) {
            this.delayedDisconnect = var0;
        }
        if (this.isConnected()) {
            this.channel.close().awaitUninterruptibly();
            this.disconnectionDetails = var0;
        }
    }

    public boolean isMemoryConnection() {
        return this.channel instanceof LocalChannel || this.channel instanceof LocalServerChannel;
    }

    public EnumProtocolDirection getReceiving() {
        return this.receiving;
    }

    public EnumProtocolDirection getSending() {
        return this.receiving.getOpposite();
    }

    public static NetworkManager connectToServer(InetSocketAddress var0, EventLoopGroupHolder var1, @Nullable LocalSampleLogger var2) {
        NetworkManager var3 = new NetworkManager(EnumProtocolDirection.CLIENTBOUND);
        if (var2 != null) {
            var3.setBandwidthLogger(var2);
        }
        ChannelFuture var4 = NetworkManager.connect(var0, var1, var3);
        var4.syncUninterruptibly();
        return var3;
    }

    public static ChannelFuture connect(InetSocketAddress var0, EventLoopGroupHolder var1, final NetworkManager var2) {
        return ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(var1.eventLoopGroup())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel var0) {
                try {
                    var0.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline var1 = var0.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                NetworkManager.configureSerialization(var1, EnumProtocolDirection.CLIENTBOUND, false, var2.bandwidthDebugMonitor);
                var2.configurePacketHandler(var1);
            }
        })).channel(var1.channelCls())).connect(var0.getAddress(), var0.getPort());
    }

    private static String outboundHandlerName(boolean var0) {
        return var0 ? "encoder" : "outbound_config";
    }

    private static String inboundHandlerName(boolean var0) {
        return var0 ? "decoder" : "inbound_config";
    }

    public void configurePacketHandler(ChannelPipeline var0) {
        var0.addLast("hackfix", (ChannelHandler)new ChannelOutboundHandlerAdapter(this){

            public void write(ChannelHandlerContext var0, Object var1, ChannelPromise var2) throws Exception {
                super.write(var0, var1, var2);
            }
        }).addLast("packet_handler", (ChannelHandler)this);
    }

    public static void configureSerialization(ChannelPipeline var0, EnumProtocolDirection var1, boolean var2, @Nullable BandwidthDebugMonitor var3) {
        EnumProtocolDirection var4 = var1.getOpposite();
        boolean var5 = var1 == EnumProtocolDirection.SERVERBOUND;
        boolean var6 = var4 == EnumProtocolDirection.SERVERBOUND;
        var0.addLast("splitter", (ChannelHandler)NetworkManager.createFrameDecoder(var3, var2)).addLast(new ChannelHandler[]{new FlowControlHandler()}).addLast(NetworkManager.inboundHandlerName(var5), var5 ? new PacketDecoder<PacketHandshakingInListener>(INITIAL_PROTOCOL) : new UnconfiguredPipelineHandler.a()).addLast("prepender", (ChannelHandler)NetworkManager.createFrameEncoder(var2)).addLast(NetworkManager.outboundHandlerName(var6), var6 ? new PacketEncoder<PacketHandshakingInListener>(INITIAL_PROTOCOL) : new UnconfiguredPipelineHandler.c());
    }

    private static ChannelOutboundHandler createFrameEncoder(boolean var0) {
        return var0 ? new LocalFrameEncoder() : new PacketPrepender();
    }

    private static ChannelInboundHandler createFrameDecoder(@Nullable BandwidthDebugMonitor var0, boolean var1) {
        if (!var1) {
            return new PacketSplitter(var0);
        }
        if (var0 != null) {
            return new MonitoredLocalFrameDecoder(var0);
        }
        return new LocalFrameDecoder();
    }

    public static void configureInMemoryPipeline(ChannelPipeline var0, EnumProtocolDirection var1) {
        NetworkManager.configureSerialization(var0, var1, true, null);
    }

    public static NetworkManager connectToLocalServer(SocketAddress var0) {
        final NetworkManager var1 = new NetworkManager(EnumProtocolDirection.CLIENTBOUND);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(EventLoopGroupHolder.local().eventLoopGroup())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel var0) {
                ChannelPipeline var12 = var0.pipeline();
                NetworkManager.configureInMemoryPipeline(var12, EnumProtocolDirection.CLIENTBOUND);
                var1.configurePacketHandler(var12);
            }
        })).channel(EventLoopGroupHolder.local().channelCls())).connect(var0).syncUninterruptibly();
        return var1;
    }

    public void setEncryptionKey(Cipher var0, Cipher var1) {
        this.encrypted = true;
        this.channel.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new PacketDecrypter(var0));
        this.channel.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new PacketEncrypter(var1));
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isOpen();
    }

    public boolean isConnecting() {
        return this.channel == null;
    }

    public @Nullable PacketListener getPacketListener() {
        return this.packetListener;
    }

    public @Nullable DisconnectionDetails getDisconnectionDetails() {
        return this.disconnectionDetails;
    }

    public void setReadOnly() {
        if (this.channel != null) {
            this.channel.config().setAutoRead(false);
        }
    }

    public void setupCompression(int var0, boolean var1) {
        if (var0 >= 0) {
            Object var2;
            ChannelHandler channelHandler = this.channel.pipeline().get("decompress");
            if (channelHandler instanceof PacketDecompressor) {
                var2 = (PacketDecompressor)channelHandler;
                ((PacketDecompressor)((Object)var2)).setThreshold(var0, var1);
            } else {
                this.channel.pipeline().addAfter("splitter", "decompress", (ChannelHandler)new PacketDecompressor(var0, var1));
            }
            channelHandler = this.channel.pipeline().get("compress");
            if (channelHandler instanceof PacketCompressor) {
                var2 = (PacketCompressor)channelHandler;
                ((PacketCompressor)((Object)var2)).setThreshold(var0);
            } else {
                this.channel.pipeline().addAfter("prepender", "compress", (ChannelHandler)new PacketCompressor(var0));
            }
        } else {
            if (this.channel.pipeline().get("decompress") instanceof PacketDecompressor) {
                this.channel.pipeline().remove("decompress");
            }
            if (this.channel.pipeline().get("compress") instanceof PacketCompressor) {
                this.channel.pipeline().remove("compress");
            }
        }
    }

    public void handleDisconnection() {
        PacketListener var1;
        if (this.channel == null || this.channel.isOpen()) {
            return;
        }
        if (this.disconnectionHandled) {
            LOGGER.warn("handleDisconnection() called twice");
            return;
        }
        this.disconnectionHandled = true;
        PacketListener var0 = this.getPacketListener();
        PacketListener packetListener = var1 = var0 != null ? var0 : this.disconnectListener;
        if (var1 != null) {
            DisconnectionDetails var2 = Objects.requireNonNullElseGet(this.getDisconnectionDetails(), () -> new DisconnectionDetails(IChatBaseComponent.translatable("multiplayer.disconnect.generic")));
            var1.onDisconnect(var2);
        }
    }

    public float getAverageReceivedPackets() {
        return this.averageReceivedPackets;
    }

    public float getAverageSentPackets() {
        return this.averageSentPackets;
    }

    public void setBandwidthLogger(LocalSampleLogger var0) {
        this.bandwidthDebugMonitor = new BandwidthDebugMonitor(var0);
    }

    protected /* synthetic */ void channelRead0(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        this.channelRead0(channelHandlerContext, (Packet)object);
    }
}

