/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public interface ChatHoverable {
    public static final Codec<ChatHoverable> CODEC = EnumHoverAction.CODEC.dispatch("action", ChatHoverable::action, var0 -> var0.codec);

    public EnumHoverAction action();

    public static final class EnumHoverAction
    extends Enum<EnumHoverAction>
    implements INamable {
        public static final /* enum */ EnumHoverAction SHOW_TEXT = new EnumHoverAction("show_text", true, e.CODEC);
        public static final /* enum */ EnumHoverAction SHOW_ITEM = new EnumHoverAction("show_item", true, d.CODEC);
        public static final /* enum */ EnumHoverAction SHOW_ENTITY = new EnumHoverAction("show_entity", true, c.CODEC);
        public static final Codec<EnumHoverAction> UNSAFE_CODEC;
        public static final Codec<EnumHoverAction> CODEC;
        private final String name;
        private final boolean allowFromServer;
        final MapCodec<? extends ChatHoverable> codec;
        private static final /* synthetic */ EnumHoverAction[] i;

        public static EnumHoverAction[] values() {
            return (EnumHoverAction[])i.clone();
        }

        public static EnumHoverAction valueOf(String var0) {
            return Enum.valueOf(EnumHoverAction.class, var0);
        }

        private EnumHoverAction(String var2, boolean var3, MapCodec var4) {
            this.name = var2;
            this.allowFromServer = var3;
            this.codec = var4;
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return "<action " + this.name + ">";
        }

        private static DataResult<EnumHoverAction> filterForSerialization(EnumHoverAction var0) {
            if (!var0.isAllowedFromServer()) {
                return DataResult.error(() -> "Action not allowed: " + String.valueOf(var0));
            }
            return DataResult.success((Object)var0, (Lifecycle)Lifecycle.stable());
        }

        private static /* synthetic */ EnumHoverAction[] b() {
            return new EnumHoverAction[]{SHOW_TEXT, SHOW_ITEM, SHOW_ENTITY};
        }

        static {
            i = EnumHoverAction.b();
            UNSAFE_CODEC = INamable.fromValues(EnumHoverAction::values);
            CODEC = UNSAFE_CODEC.validate(EnumHoverAction::filterForSerialization);
        }
    }

    public static class b {
        public static final MapCodec<b> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id").forGetter(var0 -> var0.type), (App)UUIDUtil.LENIENT_CODEC.fieldOf("uuid").forGetter(var0 -> var0.uuid), (App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(var0 -> var0.name)).apply((Applicative)var02, b::new));
        public final EntityTypes<?> type;
        public final UUID uuid;
        public final Optional<IChatBaseComponent> name;
        private @Nullable List<IChatBaseComponent> linesCache;

        public b(EntityTypes<?> var0, UUID var1, @Nullable IChatBaseComponent var2) {
            this(var0, var1, Optional.ofNullable(var2));
        }

        public b(EntityTypes<?> var0, UUID var1, Optional<IChatBaseComponent> var2) {
            this.type = var0;
            this.uuid = var1;
            this.name = var2;
        }

        public List<IChatBaseComponent> getTooltipLines() {
            if (this.linesCache == null) {
                this.linesCache = new ArrayList<IChatBaseComponent>();
                this.name.ifPresent(this.linesCache::add);
                this.linesCache.add(IChatBaseComponent.translatable("gui.entity_tooltip.type", this.type.getDescription()));
                this.linesCache.add(IChatBaseComponent.literal(this.uuid.toString()));
            }
            return this.linesCache;
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            b var1 = (b)var0;
            return this.type.equals(var1.type) && this.uuid.equals(var1.uuid) && this.name.equals(var1.name);
        }

        public int hashCode() {
            int var0 = this.type.hashCode();
            var0 = 31 * var0 + this.uuid.hashCode();
            var0 = 31 * var0 + this.name.hashCode();
            return var0;
        }
    }

    public record c(b entity) implements ChatHoverable
    {
        public static final MapCodec<c> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)b.CODEC.forGetter(c::entity)).apply((Applicative)var0, c::new));

        @Override
        public EnumHoverAction action() {
            return EnumHoverAction.SHOW_ENTITY;
        }
    }

    public record d(ItemStack item) implements ChatHoverable
    {
        public static final MapCodec<d> CODEC = ItemStack.MAP_CODEC.xmap(d::new, d::item);

        public d(ItemStack var0) {
            this.item = var0 = var0.copy();
        }

        @Override
        public EnumHoverAction action() {
            return EnumHoverAction.SHOW_ITEM;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object var0) {
            if (!(var0 instanceof d)) return false;
            d var1 = (d)var0;
            if (!ItemStack.matches(this.item, var1.item)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return ItemStack.hashItemAndComponents(this.item);
        }
    }

    public record e(IChatBaseComponent value) implements ChatHoverable
    {
        public static final MapCodec<e> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ComponentSerialization.CODEC.fieldOf("value").forGetter(e::value)).apply((Applicative)var0, e::new));

        @Override
        public EnumHoverAction action() {
            return EnumHoverAction.SHOW_TEXT;
        }
    }
}

