/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.waypoints.TrackedWaypoint;
import net.minecraft.world.waypoints.TrackedWaypointManager;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointManager;

public record ClientboundTrackedWaypointPacket(a operation, TrackedWaypoint waypoint) implements Packet<PacketListenerPlayOut>
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundTrackedWaypointPacket> STREAM_CODEC = StreamCodec.composite(a.STREAM_CODEC, ClientboundTrackedWaypointPacket::operation, TrackedWaypoint.STREAM_CODEC, ClientboundTrackedWaypointPacket::waypoint, ClientboundTrackedWaypointPacket::new);

    public static ClientboundTrackedWaypointPacket removeWaypoint(UUID var0) {
        return new ClientboundTrackedWaypointPacket(a.UNTRACK, TrackedWaypoint.empty(var0));
    }

    public static ClientboundTrackedWaypointPacket addWaypointPosition(UUID var0, Waypoint.a var1, BaseBlockPosition var2) {
        return new ClientboundTrackedWaypointPacket(a.TRACK, TrackedWaypoint.setPosition(var0, var1, var2));
    }

    public static ClientboundTrackedWaypointPacket updateWaypointPosition(UUID var0, Waypoint.a var1, BaseBlockPosition var2) {
        return new ClientboundTrackedWaypointPacket(a.UPDATE, TrackedWaypoint.setPosition(var0, var1, var2));
    }

    public static ClientboundTrackedWaypointPacket addWaypointChunk(UUID var0, Waypoint.a var1, ChunkCoordIntPair var2) {
        return new ClientboundTrackedWaypointPacket(a.TRACK, TrackedWaypoint.setChunk(var0, var1, var2));
    }

    public static ClientboundTrackedWaypointPacket updateWaypointChunk(UUID var0, Waypoint.a var1, ChunkCoordIntPair var2) {
        return new ClientboundTrackedWaypointPacket(a.UPDATE, TrackedWaypoint.setChunk(var0, var1, var2));
    }

    public static ClientboundTrackedWaypointPacket addWaypointAzimuth(UUID var0, Waypoint.a var1, float var2) {
        return new ClientboundTrackedWaypointPacket(a.TRACK, TrackedWaypoint.setAzimuth(var0, var1, var2));
    }

    public static ClientboundTrackedWaypointPacket updateWaypointAzimuth(UUID var0, Waypoint.a var1, float var2) {
        return new ClientboundTrackedWaypointPacket(a.UPDATE, TrackedWaypoint.setAzimuth(var0, var1, var2));
    }

    @Override
    public PacketType<ClientboundTrackedWaypointPacket> type() {
        return GamePacketTypes.CLIENTBOUND_WAYPOINT;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleWaypoint(this);
    }

    public void apply(TrackedWaypointManager var0) {
        this.operation.action.accept(var0, this.waypoint);
    }

    static final class a
    extends Enum<a> {
        public static final /* enum */ a TRACK = new a(WaypointManager::trackWaypoint);
        public static final /* enum */ a UNTRACK = new a(WaypointManager::untrackWaypoint);
        public static final /* enum */ a UPDATE = new a(WaypointManager::updateWaypoint);
        final BiConsumer<TrackedWaypointManager, TrackedWaypoint> action;
        public static final IntFunction<a> BY_ID;
        public static final StreamCodec<ByteBuf, a> STREAM_CODEC;
        private static final /* synthetic */ a[] g;

        public static a[] values() {
            return (a[])g.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(BiConsumer var2) {
            this.action = var2;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{TRACK, UNTRACK, UPDATE};
        }

        static {
            g = a.a();
            BY_ID = ByIdMap.continuous(Enum::ordinal, a.values(), ByIdMap.a.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

