/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;

public class PacketPlayInBlockDig
implements Packet<PacketListenerPlayIn> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayInBlockDig> STREAM_CODEC = Packet.codec(PacketPlayInBlockDig::write, PacketPlayInBlockDig::new);
    private final BlockPosition pos;
    private final EnumDirection direction;
    private final EnumPlayerDigType action;
    private final int sequence;

    public PacketPlayInBlockDig(EnumPlayerDigType var0, BlockPosition var1, EnumDirection var2, int var3) {
        this.action = var0;
        this.pos = var1.immutable();
        this.direction = var2;
        this.sequence = var3;
    }

    public PacketPlayInBlockDig(EnumPlayerDigType var0, BlockPosition var1, EnumDirection var2) {
        this(var0, var1, var2, 0);
    }

    private PacketPlayInBlockDig(PacketDataSerializer var0) {
        this.action = var0.readEnum(EnumPlayerDigType.class);
        this.pos = var0.readBlockPos();
        this.direction = EnumDirection.from3DDataValue(var0.readUnsignedByte());
        this.sequence = var0.readVarInt();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeEnum(this.action);
        var0.writeBlockPos(this.pos);
        var0.writeByte(this.direction.get3DDataValue());
        var0.writeVarInt(this.sequence);
    }

    @Override
    public PacketType<PacketPlayInBlockDig> type() {
        return GamePacketTypes.SERVERBOUND_PLAYER_ACTION;
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handlePlayerAction(this);
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public EnumDirection getDirection() {
        return this.direction;
    }

    public EnumPlayerDigType getAction() {
        return this.action;
    }

    public int getSequence() {
        return this.sequence;
    }

    public static final class EnumPlayerDigType
    extends Enum<EnumPlayerDigType> {
        public static final /* enum */ EnumPlayerDigType START_DESTROY_BLOCK = new EnumPlayerDigType();
        public static final /* enum */ EnumPlayerDigType ABORT_DESTROY_BLOCK = new EnumPlayerDigType();
        public static final /* enum */ EnumPlayerDigType STOP_DESTROY_BLOCK = new EnumPlayerDigType();
        public static final /* enum */ EnumPlayerDigType DROP_ALL_ITEMS = new EnumPlayerDigType();
        public static final /* enum */ EnumPlayerDigType DROP_ITEM = new EnumPlayerDigType();
        public static final /* enum */ EnumPlayerDigType RELEASE_USE_ITEM = new EnumPlayerDigType();
        public static final /* enum */ EnumPlayerDigType SWAP_ITEM_WITH_OFFHAND = new EnumPlayerDigType();
        public static final /* enum */ EnumPlayerDigType STAB = new EnumPlayerDigType();
        private static final /* synthetic */ EnumPlayerDigType[] i;

        public static EnumPlayerDigType[] values() {
            return (EnumPlayerDigType[])i.clone();
        }

        public static EnumPlayerDigType valueOf(String var0) {
            return Enum.valueOf(EnumPlayerDigType.class, var0);
        }

        private static /* synthetic */ EnumPlayerDigType[] a() {
            return new EnumPlayerDigType[]{START_DESTROY_BLOCK, ABORT_DESTROY_BLOCK, STOP_DESTROY_BLOCK, DROP_ALL_ITEMS, DROP_ITEM, RELEASE_USE_ITEM, SWAP_ITEM_WITH_OFFHAND, STAB};
        }

        static {
            i = EnumPlayerDigType.a();
        }
    }
}

