/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.world.EnumHand;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class PacketPlayInUseItem
implements Packet<PacketListenerPlayIn> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayInUseItem> STREAM_CODEC = Packet.codec(PacketPlayInUseItem::write, PacketPlayInUseItem::new);
    private final MovingObjectPositionBlock blockHit;
    private final EnumHand hand;
    private final int sequence;

    public PacketPlayInUseItem(EnumHand var0, MovingObjectPositionBlock var1, int var2) {
        this.hand = var0;
        this.blockHit = var1;
        this.sequence = var2;
    }

    private PacketPlayInUseItem(PacketDataSerializer var0) {
        this.hand = var0.readEnum(EnumHand.class);
        this.blockHit = var0.readBlockHitResult();
        this.sequence = var0.readVarInt();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeEnum(this.hand);
        var0.writeBlockHitResult(this.blockHit);
        var0.writeVarInt(this.sequence);
    }

    @Override
    public PacketType<PacketPlayInUseItem> type() {
        return GamePacketTypes.SERVERBOUND_USE_ITEM_ON;
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleUseItemOn(this);
    }

    public EnumHand getHand() {
        return this.hand;
    }

    public MovingObjectPositionBlock getHitResult() {
        return this.blockHit;
    }

    public int getSequence() {
        return this.sequence;
    }
}

