/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public class PacketPlayOutBlockChange
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutBlockChange> STREAM_CODEC = StreamCodec.composite(BlockPosition.STREAM_CODEC, PacketPlayOutBlockChange::getPos, ByteBufCodecs.idMapper(Block.BLOCK_STATE_REGISTRY), PacketPlayOutBlockChange::getBlockState, PacketPlayOutBlockChange::new);
    private final BlockPosition pos;
    public final IBlockData blockState;

    public PacketPlayOutBlockChange(BlockPosition var0, IBlockData var1) {
        this.pos = var0;
        this.blockState = var1;
    }

    public PacketPlayOutBlockChange(IBlockAccess var0, BlockPosition var1) {
        this(var1, var0.getBlockState(var1));
    }

    @Override
    public PacketType<PacketPlayOutBlockChange> type() {
        return GamePacketTypes.CLIENTBOUND_BLOCK_UPDATE;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleBlockUpdate(this);
    }

    public IBlockData getBlockState() {
        return this.blockState;
    }

    public BlockPosition getPos() {
        return this.pos;
    }
}

