/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutCollect
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutCollect> STREAM_CODEC = Packet.codec(PacketPlayOutCollect::write, PacketPlayOutCollect::new);
    private final int itemId;
    private final int playerId;
    private final int amount;

    public PacketPlayOutCollect(int var0, int var1, int var2) {
        this.itemId = var0;
        this.playerId = var1;
        this.amount = var2;
    }

    private PacketPlayOutCollect(PacketDataSerializer var0) {
        this.itemId = var0.readVarInt();
        this.playerId = var0.readVarInt();
        this.amount = var0.readVarInt();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.itemId);
        var0.writeVarInt(this.playerId);
        var0.writeVarInt(this.amount);
    }

    @Override
    public PacketType<PacketPlayOutCollect> type() {
        return GamePacketTypes.CLIENTBOUND_TAKE_ITEM_ENTITY;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleTakeItemEntity(this);
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public int getAmount() {
        return this.amount;
    }
}

