/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import org.jspecify.annotations.Nullable;

public class PacketPlayOutCommands
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutCommands> STREAM_CODEC = Packet.codec(PacketPlayOutCommands::write, PacketPlayOutCommands::new);
    private static final byte MASK_TYPE = 3;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_REDIRECT = 8;
    private static final byte FLAG_CUSTOM_SUGGESTIONS = 16;
    private static final byte FLAG_RESTRICTED = 32;
    private static final byte TYPE_ROOT = 0;
    private static final byte TYPE_LITERAL = 1;
    private static final byte TYPE_ARGUMENT = 2;
    private final int rootIndex;
    private final List<b> entries;

    public <S> PacketPlayOutCommands(RootCommandNode<S> var0, e<S> var1) {
        Object2IntMap<CommandNode<S>> var2 = PacketPlayOutCommands.enumerateNodes(var0);
        this.entries = PacketPlayOutCommands.createEntries(var2, var1);
        this.rootIndex = var2.getInt(var0);
    }

    private PacketPlayOutCommands(PacketDataSerializer var0) {
        this.entries = var0.readList(PacketPlayOutCommands::readNode);
        this.rootIndex = var0.readVarInt();
        PacketPlayOutCommands.validateEntries(this.entries);
    }

    private void write(PacketDataSerializer var02) {
        var02.writeCollection(this.entries, (var0, var1) -> var1.write((PacketDataSerializer)((Object)var0)));
        var02.writeVarInt(this.rootIndex);
    }

    private static void validateEntries(List<b> var0, BiPredicate<b, IntSet> var1) {
        IntOpenHashSet var2 = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)var0.size()));
        while (!var2.isEmpty()) {
            boolean var3 = var2.removeIf(arg_0 -> PacketPlayOutCommands.a(var1, var0, (IntSet)var2, arg_0));
            if (var3) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static void validateEntries(List<b> var0) {
        PacketPlayOutCommands.validateEntries(var0, b::canBuild);
        PacketPlayOutCommands.validateEntries(var0, b::canResolve);
    }

    private static <S> Object2IntMap<CommandNode<S>> enumerateNodes(RootCommandNode<S> var0) {
        CommandNode var3;
        Object2IntOpenHashMap var1 = new Object2IntOpenHashMap();
        ArrayDeque<Object> var2 = new ArrayDeque<Object>();
        var2.add(var0);
        while ((var3 = (CommandNode)var2.poll()) != null) {
            if (var1.containsKey((Object)var3)) continue;
            int var4 = var1.size();
            var1.put((Object)var3, var4);
            var2.addAll(var3.getChildren());
            if (var3.getRedirect() == null) continue;
            var2.add(var3.getRedirect());
        }
        return var1;
    }

    private static <S> List<b> createEntries(Object2IntMap<CommandNode<S>> var0, e<S> var1) {
        ObjectArrayList var2 = new ObjectArrayList(var0.size());
        var2.size(var0.size());
        for (Object2IntMap.Entry var4 : Object2IntMaps.fastIterable(var0)) {
            var2.set(var4.getIntValue(), (Object)PacketPlayOutCommands.createEntry((CommandNode)var4.getKey(), var1, var0));
        }
        return var2;
    }

    private static b readNode(PacketDataSerializer var0) {
        byte var1 = var0.readByte();
        int[] var2 = var0.readVarIntArray();
        int var3 = (var1 & 8) != 0 ? var0.readVarInt() : 0;
        g var4 = PacketPlayOutCommands.read(var0, var1);
        return new b(var4, var1, var3, var2);
    }

    private static @Nullable g read(PacketDataSerializer var0, byte var1) {
        int var2 = var1 & 3;
        if (var2 == 2) {
            String var3 = var0.readUtf();
            int var4 = var0.readVarInt();
            ArgumentTypeInfo var5 = (ArgumentTypeInfo)BuiltInRegistries.COMMAND_ARGUMENT_TYPE.byId(var4);
            if (var5 == null) {
                return null;
            }
            Object var6 = var5.deserializeFromNetwork(var0);
            MinecraftKey var7 = (var1 & 0x10) != 0 ? var0.readIdentifier() : null;
            return new a(var3, (ArgumentTypeInfo.a<?>)var6, var7);
        }
        if (var2 == 1) {
            String var3 = var0.readUtf();
            return new c(var3);
        }
        return null;
    }

    private static <S> b createEntry(CommandNode<S> var0, e<S> var1, Object2IntMap<CommandNode<S>> var2) {
        Record var5;
        int var4;
        int var3 = 0;
        if (var0.getRedirect() != null) {
            var3 |= 8;
            var4 = var2.getInt((Object)var0.getRedirect());
        } else {
            var4 = 0;
        }
        if (var1.isExecutable(var0)) {
            var3 |= 4;
        }
        if (var1.isRestricted(var0)) {
            var3 |= 0x20;
        }
        CommandNode<S> commandNode = var0;
        Objects.requireNonNull(commandNode);
        CommandNode<S> commandNode2 = commandNode;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RootCommandNode.class, ArgumentCommandNode.class, LiteralCommandNode.class}, commandNode2, n2)) {
            case 0: {
                RootCommandNode var8 = (RootCommandNode)commandNode2;
                var3 |= 0;
                var5 = null;
                break;
            }
            case 1: {
                ArgumentCommandNode var9 = (ArgumentCommandNode)commandNode2;
                MinecraftKey var10 = var1.suggestionId(var9);
                var5 = new a(var9.getName(), ArgumentTypeInfos.unpack(var9.getType()), var10);
                var3 |= 2;
                if (var10 != null) {
                    var3 |= 0x10;
                }
                break;
            }
            case 2: {
                LiteralCommandNode var10 = (LiteralCommandNode)commandNode2;
                var5 = new c(var10.getLiteral());
                var3 |= 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown node type " + String.valueOf(var0));
            }
        }
        int[] var6 = var0.getChildren().stream().mapToInt(arg_0 -> var2.getInt(arg_0)).toArray();
        return new b((g)((Object)var5), var3, var4, var6);
    }

    @Override
    public PacketType<PacketPlayOutCommands> type() {
        return GamePacketTypes.CLIENTBOUND_COMMANDS;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleCommands(this);
    }

    public <S> RootCommandNode<S> getRoot(CommandBuildContext var0, d<S> var1) {
        return (RootCommandNode)new f<S>(var0, var1, this.entries).resolve(this.rootIndex);
    }

    private static /* synthetic */ boolean a(BiPredicate var0, List var1, IntSet var2, int var3) {
        return var0.test((b)var1.get(var3), var2);
    }

    public static interface e<S> {
        public @Nullable MinecraftKey suggestionId(ArgumentCommandNode<S, ?> var1);

        public boolean isExecutable(CommandNode<S> var1);

        public boolean isRestricted(CommandNode<S> var1);
    }

    static final class b
    extends Record {
        final @Nullable g stub;
        final int flags;
        final int redirect;
        final int[] children;

        b(@Nullable g var0, int var1, int var2, int[] var3) {
            this.stub = var0;
            this.flags = var1;
            this.redirect = var2;
            this.children = var3;
        }

        public void write(PacketDataSerializer var0) {
            var0.writeByte(this.flags);
            var0.writeVarIntArray(this.children);
            if ((this.flags & 8) != 0) {
                var0.writeVarInt(this.redirect);
            }
            if (this.stub != null) {
                this.stub.write(var0);
            }
        }

        public boolean canBuild(IntSet var0) {
            if ((this.flags & 8) != 0) {
                return !var0.contains(this.redirect);
            }
            return true;
        }

        public boolean canResolve(IntSet var0) {
            for (int var4 : this.children) {
                if (!var0.contains(var4)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "stub;flags;redirect;children", "stub", "flags", "redirect", "children"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "stub;flags;redirect;children", "stub", "flags", "redirect", "children"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "stub;flags;redirect;children", "stub", "flags", "redirect", "children"}, this, var0);
        }

        public @Nullable g stub() {
            return this.stub;
        }

        public int flags() {
            return this.flags;
        }

        public int redirect() {
            return this.redirect;
        }

        public int[] children() {
            return this.children;
        }
    }

    static interface g {
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext var1, d<S> var2);

        public void write(PacketDataSerializer var1);
    }

    record a(String id, ArgumentTypeInfo.a<?> argumentType, @Nullable MinecraftKey suggestionId) implements g
    {
        @Override
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext var0, d<S> var1) {
            Object var2 = this.argumentType.instantiate(var0);
            return var1.createArgument(this.id, (ArgumentType<?>)var2, this.suggestionId);
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeUtf(this.id);
            a.serializeCap(var0, this.argumentType);
            if (this.suggestionId != null) {
                var0.writeIdentifier(this.suggestionId);
            }
        }

        private static <A extends ArgumentType<?>> void serializeCap(PacketDataSerializer var0, ArgumentTypeInfo.a<A> var1) {
            a.serializeCap(var0, var1.type(), var1);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.a<A>> void serializeCap(PacketDataSerializer var0, ArgumentTypeInfo<A, T> var1, ArgumentTypeInfo.a<A> var2) {
            var0.writeVarInt(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getId(var1));
            var1.serializeToNetwork(var2, var0);
        }
    }

    record c(String id) implements g
    {
        @Override
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext var0, d<S> var1) {
            return var1.createLiteral(this.id);
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeUtf(this.id);
        }
    }

    static class f<S> {
        private final CommandBuildContext context;
        private final d<S> builder;
        private final List<b> entries;
        private final List<CommandNode<S>> nodes;

        f(CommandBuildContext var0, d<S> var1, List<b> var2) {
            this.context = var0;
            this.builder = var1;
            this.entries = var2;
            ObjectArrayList var3 = new ObjectArrayList();
            var3.size(var2.size());
            this.nodes = var3;
        }

        public CommandNode<S> resolve(int var0) {
            RootCommandNode var3;
            CommandNode<S> var1 = this.nodes.get(var0);
            if (var1 != null) {
                return var1;
            }
            b var2 = this.entries.get(var0);
            if (var2.stub == null) {
                var3 = new RootCommandNode();
            } else {
                ArgumentBuilder<S, ?> var4 = var2.stub.build(this.context, this.builder);
                if ((var2.flags & 8) != 0) {
                    var4.redirect(this.resolve(var2.redirect));
                }
                boolean var5 = (var2.flags & 4) != 0;
                boolean var6 = (var2.flags & 0x20) != 0;
                var3 = this.builder.configure(var4, var5, var6).build();
            }
            this.nodes.set(var0, (CommandNode<S>)var3);
            for (int var7 : var2.children) {
                CommandNode<S> var8 = this.resolve(var7);
                if (var8 instanceof RootCommandNode) continue;
                var3.addChild(var8);
            }
            return var3;
        }
    }

    public static interface d<S> {
        public ArgumentBuilder<S, ?> createLiteral(String var1);

        public ArgumentBuilder<S, ?> createArgument(String var1, ArgumentType<?> var2, @Nullable MinecraftKey var3);

        public ArgumentBuilder<S, ?> configure(ArgumentBuilder<S, ?> var1, boolean var2, boolean var3);
    }
}

