/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.Entity;

public class PacketPlayOutEntitySound
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutEntitySound> STREAM_CODEC = Packet.codec(PacketPlayOutEntitySound::write, PacketPlayOutEntitySound::new);
    private final Holder<SoundEffect> sound;
    private final SoundCategory source;
    private final int id;
    private final float volume;
    private final float pitch;
    private final long seed;

    public PacketPlayOutEntitySound(Holder<SoundEffect> var0, SoundCategory var1, Entity var2, float var3, float var4, long var5) {
        this.sound = var0;
        this.source = var1;
        this.id = var2.getId();
        this.volume = var3;
        this.pitch = var4;
        this.seed = var5;
    }

    private PacketPlayOutEntitySound(RegistryFriendlyByteBuf var0) {
        this.sound = (Holder)SoundEffect.STREAM_CODEC.decode(var0);
        this.source = var0.readEnum(SoundCategory.class);
        this.id = var0.readVarInt();
        this.volume = var0.readFloat();
        this.pitch = var0.readFloat();
        this.seed = var0.readLong();
    }

    private void write(RegistryFriendlyByteBuf var0) {
        SoundEffect.STREAM_CODEC.encode(var0, this.sound);
        var0.writeEnum(this.source);
        var0.writeVarInt(this.id);
        var0.writeFloat(this.volume);
        var0.writeFloat(this.pitch);
        var0.writeLong(this.seed);
    }

    @Override
    public PacketType<PacketPlayOutEntitySound> type() {
        return GamePacketTypes.CLIENTBOUND_SOUND_ENTITY;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSoundEntityEvent(this);
    }

    public Holder<SoundEffect> getSound() {
        return this.sound;
    }

    public SoundCategory getSource() {
        return this.source;
    }

    public int getId() {
        return this.id;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public long getSeed() {
        return this.seed;
    }
}

