/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutEntityVelocity
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutEntityVelocity> STREAM_CODEC = Packet.codec(PacketPlayOutEntityVelocity::write, PacketPlayOutEntityVelocity::new);
    private final int id;
    private final Vec3D movement;

    public PacketPlayOutEntityVelocity(Entity var0) {
        this(var0.getId(), var0.getDeltaMovement());
    }

    public PacketPlayOutEntityVelocity(int var0, Vec3D var1) {
        this.id = var0;
        this.movement = var1;
    }

    private PacketPlayOutEntityVelocity(PacketDataSerializer var0) {
        this.id = var0.readVarInt();
        this.movement = var0.readLpVec3();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.id);
        var0.writeLpVec3(this.movement);
    }

    @Override
    public PacketType<PacketPlayOutEntityVelocity> type() {
        return GamePacketTypes.CLIENTBOUND_SET_ENTITY_MOTION;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSetEntityMotion(this);
    }

    public int getId() {
        return this.id;
    }

    public Vec3D getMovement() {
        return this.movement;
    }
}

