/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Objects;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.ScoreboardObjective;
import org.jspecify.annotations.Nullable;

public class PacketPlayOutScoreboardDisplayObjective
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutScoreboardDisplayObjective> STREAM_CODEC = Packet.codec(PacketPlayOutScoreboardDisplayObjective::write, PacketPlayOutScoreboardDisplayObjective::new);
    private final DisplaySlot slot;
    private final String objectiveName;

    public PacketPlayOutScoreboardDisplayObjective(DisplaySlot var0, @Nullable ScoreboardObjective var1) {
        this.slot = var0;
        this.objectiveName = var1 == null ? "" : var1.getName();
    }

    private PacketPlayOutScoreboardDisplayObjective(PacketDataSerializer var0) {
        this.slot = var0.readById(DisplaySlot.BY_ID);
        this.objectiveName = var0.readUtf();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeById(DisplaySlot::id, this.slot);
        var0.writeUtf(this.objectiveName);
    }

    @Override
    public PacketType<PacketPlayOutScoreboardDisplayObjective> type() {
        return GamePacketTypes.CLIENTBOUND_SET_DISPLAY_OBJECTIVE;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSetDisplayObjective(this);
    }

    public DisplaySlot getSlot() {
        return this.slot;
    }

    public @Nullable String getObjectiveName() {
        return Objects.equals(this.objectiveName, "") ? null : this.objectiveName;
    }
}

