/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public record PacketPlayOutTabComplete(int id, int start, int length, List<a> suggestions) implements Packet<PacketListenerPlayOut>
{
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutTabComplete> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, PacketPlayOutTabComplete::id, ByteBufCodecs.VAR_INT, PacketPlayOutTabComplete::start, ByteBufCodecs.VAR_INT, PacketPlayOutTabComplete::length, a.STREAM_CODEC.apply(ByteBufCodecs.list()), PacketPlayOutTabComplete::suggestions, PacketPlayOutTabComplete::new);

    public PacketPlayOutTabComplete(int var02, Suggestions var1) {
        this(var02, var1.getRange().getStart(), var1.getRange().getLength(), var1.getList().stream().map(var0 -> new a(var0.getText(), Optional.ofNullable(var0.getTooltip()).map(ChatComponentUtils::fromMessage))).toList());
    }

    @Override
    public PacketType<PacketPlayOutTabComplete> type() {
        return GamePacketTypes.CLIENTBOUND_COMMAND_SUGGESTIONS;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleCommandSuggestions(this);
    }

    public Suggestions toSuggestions() {
        StringRange var0 = StringRange.between((int)this.start, (int)(this.start + this.length));
        return new Suggestions(var0, this.suggestions.stream().map(var1 -> new Suggestion(var0, var1.text(), (Message)var1.tooltip().orElse(null))).toList());
    }

    public record a(String text, Optional<IChatBaseComponent> tooltip) {
        public static final StreamCodec<RegistryFriendlyByteBuf, a> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, a::text, ComponentSerialization.TRUSTED_OPTIONAL_STREAM_CODEC, a::tooltip, a::new);
    }
}

