/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutUpdateHealth
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutUpdateHealth> STREAM_CODEC = Packet.codec(PacketPlayOutUpdateHealth::write, PacketPlayOutUpdateHealth::new);
    private final float health;
    private final int food;
    private final float saturation;

    public PacketPlayOutUpdateHealth(float var0, int var1, float var2) {
        this.health = var0;
        this.food = var1;
        this.saturation = var2;
    }

    private PacketPlayOutUpdateHealth(PacketDataSerializer var0) {
        this.health = var0.readFloat();
        this.food = var0.readVarInt();
        this.saturation = var0.readFloat();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeFloat(this.health);
        var0.writeVarInt(this.food);
        var0.writeFloat(this.saturation);
    }

    @Override
    public PacketType<PacketPlayOutUpdateHealth> type() {
        return GamePacketTypes.CLIENTBOUND_SET_HEALTH;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSetHealth(this);
    }

    public float getHealth() {
        return this.health;
    }

    public int getFood() {
        return this.food;
    }

    public float getSaturation() {
        return this.saturation;
    }
}

